<?php

if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}

if(isset($_GET['requestid']) && ($userId = validateUser()) > 0)
{
    $request = getRequest( $_GET['requestid']);
    if($userId != $request->getUserId() && !in_array($userId, KeyRing::$admins))
    {
        exit();
    }
}


?>

<div class="span11">
    
    <div class="row">
        <div class="span11">
            <ul class="breadcrumb">
                <li><a href=".">Home</a> <span class="divider">/</span></li>
                <li class="active">Request</li>
            </ul>
        </div>
    </div>
    <div class="row">
        <div class="span8">
            
<?php
if(isset($request) && $request->getId() > 0)
{
?>    
            <h3><?php echo TypeMgr::getRequestType($request->getType());?> Request</h3>
<?php
            switch ($request->getType()){
                case TypeMgr::quoteRequest :

                    $basket = new Basket();
                    $basket = createBasketFromQuoteRequest($_GET['requestid']);
                    

                    if($basket->getNbLineItems() <= 0)
                    {           
?>
                        <p>There are no items.</p>
<?php                    
                    }
                    else
                    {
?>
                    <table class="table table-striped">
                        <thead>
                            <th colspan="2">Item Description</th>
                            <th>Quantity</th>
                            <th>Product Code</th>
                        </thead>
                        <tbody>               
<?php
                            for($i=1; $i <= $basket->getNbLineItems(); $i++)    
                            {
                                $nxtItem = $basket->items->readNode($i);
?>
                            <tr>
                                <td>

<?php 
                                $nxtProduct = getProductBaseByCode($nxtItem->getProductCode());
                                $nxtImg = getBestImageByProductCode($nxtProduct->getProductCode(), 48, 48);
?>
                                    <img src="<?php echo $nxtImg->getSrc();?>" width="48" height="48" class="thumbnail"/>
                                </td>
                                <td>
                                    <?php
                                    if($nxtProduct->getId()>0)
                                    {
                                    ?>
                                    <a href="<?php echo getProductDetailLink($nxtProduct->getId());?>">
                                        <p class="header_text"><?php echo $nxtProduct->getName(); ?></p>
                                    </a>
                                    <?php
                                    }
                                    else
                                    {
                                    ?>
                                    <strong>WARNING: Can't find this product code!</strong>
                                    <?php
                                    }
                                    ?>
                                </td>
                                <td>
                                    <?php echo $nxtItem->getQty();?>
                                </td>
                                <td>
                                    <?php echo $nxtItem->getProductCode();?>
                                </td>
                            </tr>
<?php
                            }
?>
                        </tbody>
                    </table>   
<?php
                        }
            
                    break;
                case TypeMgr::contactRequest :
                    
                    $contactMessage = getMessageByReq($request->getId());
?>
                        <dl class="dl-horizontal">
                                <dt>Internal Id</dt><dd><?php echo $contactMessage->getId();?></dd>
<?php 
                                $name = $contactMessage->getName();
                                $email = $contactMessage->getEmail();
                                $fax = $contactMessage->getFax();
                                $phone = $contactMessage->getPhone();
                                $message = $contactMessage->getMessage();
                                
                                if(isset($name) && !empty($name))
                                {
?>
                                <dt>Name</dt><dd><?php echo $name;?></dd>
<?php
                                }
                                if(isset($email) && !empty($email))
                                {
?>
                                <dt>Email</dt><dd><?php echo $email;?></dd>
<?php
                                }
                                if(isset($fax) && !empty($fax))
                                {
?>
                                <dt>Fax</dt><dd><?php echo $fax;?></dd>
<?php
                                }
                                if(isset($phone) && !empty($phone))
                                {
?>
                                <dt>Phone</dt><dd><?php echo $phone;?></dd>
<?php
                                }
                                if(isset($message) && !empty($message))
                                {
?>
                                <dt>Message</dt><dd><?php echo $message;?></dd>
<?php
                                }
?>
                            </dl>
<?php


                    
                    break;
            }
        }
?>
            <div class="row">
                <div class="span5">
                    <a href="<?php if(isset($_SERVER['HTTP_REFERER'])){echo $_SERVER['HTTP_REFERER'];}else{echo "javascript:history.back();";}?>" class="btn">Back</a>
                </div>
            </div>
            
        </div>
    </div>
</div>

