<?php

if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}



$productSearchKey = "";
if(isset($_GET['productSearchKey'])){
        $productSearchKey = cleanQuery(trim($_GET['productSearchKey']));
}
$productSearchCat = 0;
if(isset($_GET['catid'])){
        $productSearchCat = cleanQuery($_GET['catid']);
}



if(isset($_GET['pageSize'])){
        $resultsPerPage = cleanQuery($_GET['pageSize']);
}
$resultPage = 1;
if(isset($_GET['resultpage'])){
        $resultPage = cleanQuery($_GET['resultpage']);
}

/*
 * pagination 
 */

$resultsPerPageOptionsArr = array("5", "10", "50");
$resultsPerPage = 5;
$pagesPerWindow = 10;


$userId = validateUser();

$resultList = new LinkList();
if(!empty($productSearchKey))
{
    if(isset($productSearchCat) && $productSearchCat > 0)
    {
        $resultList = getSearchResultProductBasesNameDescCat($productSearchKey, $productSearchCat);
    }
    else
    {
        $resultList = getSearchResultProductBasesNameDesc($productSearchKey);    
    }
}
?>

<div class="span11">

    <div class="row">
        <div class="span11">
            <ul class="breadcrumb">
                <li><a href=".">Home</a> <span class="divider">/</span></li>
                <li class="active">Search - (<?php echo $resultList->totalNodes();?>) Results for "<?php echo $productSearchKey;?>"</li>
            </ul>
        </div>
    </div>
<?php
        
        
        
        if(isset($resultList) && $resultList->totalNodes() > 0)
        {
?>

    <div class="row">
        <div class="span9">

<table class="table table-hover">
                    <thead><th colspan="2">Product</th><th>Documentation</th></thead>
                    <tbody>
            
<?php

    $startIndex = 1;
    $endIndex = $resultList->totalNodes();
    
    if($endIndex > $resultsPerPage){
        $endIndex = $resultsPerPage;
    }
    
    if(isset($resultPage) && $resultPage > 1){
        $startIndex = $resultsPerPage * ($resultPage-1) + 1;
        $endIndex =  $resultsPerPage * ($resultPage-1) + $resultsPerPage;
    }
    
    if($endIndex > $resultList->totalNodes()){
        $endIndex = $resultList->totalNodes();
    }

?>                
<?php
                for($i=$startIndex; $i <= $endIndex; $i++)    
                {
                    $nxtResult = $resultList->readNode($i);
    ?>
                        
                    <script type="text/javascript">
                        $(document).ready(function(){
                            $('#result_row_img_<?php echo $i;?>').click(function() {
                                window.open('<?php echo getProductDetailLink($nxtResult->getId(), "");?>',"_self");
                            });
                            $('#result_row_desc_<?php echo $i;?>').click(function() {
                                window.open('<?php echo getProductDetailLink($nxtResult->getId(), "");?>',"_self");
                            });
                        });
                    </script>
                    <tr>
                        
                        <td class="span1"   id="result_row_img_<?php echo $i;?>" style="cursor:pointer">                   
<?php 
                        $nxtImg = getBestImageByProductCode($nxtResult->getProductCode(),48,48);
?>
                            <img src="<?php echo $nxtImg->getSrc();?>" width="48" height="48" class="thumbnail"/>
                            
                        </td>
                        <?php
                            $highlightedName = str_ireplace($productSearchKey,"<b>".$productSearchKey."</b>",$nxtResult->getName());
                            $highlightedDesc = str_ireplace($productSearchKey,"<b>".$productSearchKey."</b>",$nxtResult->getDescription());
                        ?>
                            <td   id="result_row_desc_<?php echo $i;?>" style="cursor:pointer">
                                <h3 class="header_text"><?php echo $highlightedName;?></h3>
                                <br/><?php echo $highlightedDesc;?>
                            </td>
                        
                            <td>
                                <?php
                                
                                    if($userId > 0)
                                    {  
                                        $productDocuments = getDocumentsByProductCode($nxtResult->getProductCode());
                                        $productDocLoc = "./files/".$nxtResult->getProductCode();

                                        if(isset($productDocuments) && $productDocuments->totalNodes() > 0)
                                        {
    ?>
                                        <table class="table table-striped table-condensed table-hover">
                                            <thead><th>Name</th><th>Type</th></thead>
                                            <tbody>
    <?php
                                                for($j=1; $j <= $productDocuments->totalNodes(); $j++)    
                                                {
                                                    $nxtDoc = $productDocuments->readNode($j);
                                                    
                                                    $name = substr($nxtDoc,0,strpos($nxtDoc,'.'));
                                                    
                                                    //$nxtDocTarget = getTargetById($nxtDoc->getTargetId());
                                                    //$nxtDocType = getDocumentationTypeById($nxtDocTarget->getTargetType());
    ?>
                                                <script type="text/javascript">
                                                    $(document).ready(function(){
                                                        $('#document_row_<?php echo $name;?>').click(function() {
                                                            window.open("<?php echo $productDocLoc.'/'.$nxtDoc;?>","_blank");
                                                        });
                                                    });
                                                </script>
                                                <tr id="document_row_<?php echo $name;?>" style="cursor:pointer">
                                                    <td><?php echo basename($nxtDoc);?></td>
                                                    <td>PDF</td>
                                                </tr>   
    <?php
                                                }
    ?>
                                            </tbody>
                                        </table>
    <?php    
                                        }
                                        else
                                        {
?>
                                                <p>There is no documentation available at this time.</p>
<?php
                                        }
                                    }
                                    else
                                    {
?>
                                        <p>Please <a href="./Login?returnUrl=<?php echo $_SERVER['REQUEST_URI'];?>">sign in</a> or <a href="./Register?returnUrl=<?php echo $_SERVER['REQUEST_URI'];?>">register.</a></p>
<?php
                                    }
                                ?>
                            </td>
                        </tr>   
    <?php
                }
?>
                    </tbody>
                </table>
        </div>
    </div>
    <?php
        }
?>
    
    <div class="row">
        <div class="span9">
<?php
    getPaginationDiv($resultList, $resultsPerPageOptionsArr, $resultsPerPage, $pagesPerWindow, $resultPage, $_SERVER['REQUEST_URI']);
?>
        </div>
    </div>
</div>

