<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}
$catid = 0;
if(isset($_GET['catshortname'])){
    $catshortname = cleanQuery($_GET['catshortname']);  
    $catid = getCatIdByShortname($catshortname);
}
if(isset($_GET['shortname'])){
    $shortname = cleanQuery($_GET['shortname']);  
    $productid = getProductIdByShortname($shortname);
}
if(isset($_GET['productid'])){
    $productid = cleanQuery($_GET['productid']);  
}

$info_desc = "desc";
$info_details = "details";
$info_spec = "spec";
$info_avail = "avail";

$info = "";

if (isset($_GET['info']))
{
    $info = $_GET['info'];
}

$liveUpdate = false;
if(isset($_GET['liveupdate'])){
    $liveUpdate = cleanQuery($_GET['liveupdate']);  
}

/*
 * handle recently viewed products
 */
$recentlyViewed = array();
if (isset($_SESSION['recentlyViewed']))
{
    $recentlyViewed = $_SESSION['recentlyViewed'];    
}
if(!in_array($productid,$recentlyViewed))
{
    $recentlyViewed[] = $productid;
}
if (count($recentlyViewed) > 4 ){
    array_shift($recentlyViewed);
}
$_SESSION['recentlyViewed'] = $recentlyViewed;

$userId = validateUser();

if ($userId > 0){
    $thisUser = getUserById($userId);
}


?>

<div class="span11">
            <?php
                if(isset($productid))
                {
                    $spotProduct = getProductBaseById($productid);
                    $spotCat = getCategoryById($catid);
                    
                    $spotlightImg = getBestImageByProductCode($spotProduct->getProductCode(), 400, 400);
                    //product spotlight
            ?>

    <div class="row">
        <div class="span11">
            <ul class="breadcrumb">
                <li><a href=".">Home</a> <span class="divider">/</span></li>
                <li><a href="./<?php echo $spotCat->getShortname();?>"><?php echo $spotCat->getName();?></a> <span class="divider">/</span></li>
                <li class="active"><?php echo $spotProduct->getName();?></li>
            </ul>          
        </div>
    </div>
    
        
<?php
        if(in_array($userId, KeyRing::$admins))
        {
?>
    <div class="row">
        <div class="span2">
            <div class="btn-group">
                <a class="btn btn-warning dropdown-toggle" data-toggle="dropdown">
                    Edit
                    <span class="caret"></span>
                </a>
                <ul class="dropdown-menu">
                    <li><a href="<?php echo append_querystring_var(getProductDetailLink($spotProduct->getId(),$info_desc), "liveupdate=true");?>">Description</a></li>
                    <li><a href="<?php echo append_querystring_var(getProductDetailLink($spotProduct->getId(),$info_avail), "liveupdate=true");?>">Availability</a></li>
                    <li><a href="<?php echo append_querystring_var(getProductDetailLink($spotProduct->getId(),$info_details), "liveupdate=true");?>">Product Details</a></li>
                    <li><a href="<?php echo append_querystring_var(getProductDetailLink($spotProduct->getId(),$info_spec), "liveupdate=true");?>">Specifications</a></li>
                </ul>
            </div>
        </div>
    </div>
        
<?php
        }
?>
    <div class="row">
        <div class="span9">
            <!-- product description -->
            <div class="row">
                    <div class="span3">
                        <a href="#img-modal" data-toggle="modal"><img class="thumbnail" src="<?php if(isset($spotlightImg)){echo $spotlightImg->getSrc();}?>"/></a>
                    </div>
                    <div id="img-modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="img-label" aria-hidden="true">
                        <div class="modal-body">
                            <img class="thumbnail" style="margin: 0 auto;" src="<?php if(isset($spotlightImg)){echo $spotlightImg->getSrc();}?>"/>
                        </div>
                        <div class="modal-footer">
                            <button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
                        </div>
                    </div>
                    <div class="span5">
                        
                        <div class="row">
                        <div class="span5">
                        
                        
                            <div class="pull-right">
                                <span class='st_facebook_large' displayText='Facebook'></span>
                                <span class='st_amazon_wishlist_large' displayText='Amazon Wishlist'></span>
                                <span class='st_sharethis_large' displayText='ShareThis'></span>
                                <span class='st_twitter_large' displayText='Tweet'></span>
                                <span class='st_pinterest_large' displayText='Pinterest'></span>
                                <span class='st_email_large' displayText='Email'></span>
                            </div>
                        
                        <h3><?php echo $spotProduct->getName();?></h3>
                        
<?php
                if(in_array($userId, KeyRing::$admins) && $liveUpdate && $info == $info_desc)
                {
?>
                    <form action="<?php echo getProductDetailLink($spotProduct->getId());?>" method="post" id="productDescriptionEditArea">
                        <input type="hidden" name="formType" value="editproductdescription"/>
                        <input type="hidden" name="productId" value="<?php echo $spotProduct->getId();?>"/>
                        <textarea class="config_min" id="productDescriptionTextArea" name="productDescriptionTextArea" rows="2"> 
                            <?php echo $spotProduct->getDescription();?>
                        </textarea>
                        <br/>
                        <button id="editProductDescriptionUpdateBtn" type="submit" class="btn btn-warning" onclick="javascript:$(this).parent().children('#page_loading').show();">Update</button>
                        <img id="page_loading" src="img/ajax-loader.gif" alt="loading" style="display:none">

                        <?php include("./include/ckeditor.php"); ?>
                    </form>
                    <br/>
<?php 
                }
                else
                {
?>
                    <p><?php echo $spotProduct->getDescription();?></p>
                    <br/>
<?php
                }
?>

                        
                        
                        
                        
                        <div class="well">
                            <p><a href="#contact-modal" data-toggle="modal" class="btn btn-block">Ask A Question</a></p>
<?php
                            if($spotProduct->getIsCheckoutItem() > 0)
                            {
?>
                            <p>
                                <form action="./Basket" method="post">
                                    <input type="hidden" name="formType" value="addBasketItem"/>
                                    <input type="hidden" name="addBasketItem" value="<?php echo $spotProduct->getId();?>"/>
                                    <input type="submit" class="btn btn-block" value="Add To Basket"/>
                                </form>
                            </p>
                            
<?php
                             if(in_array($userId, KeyRing::$admins) && $liveUpdate && $info == $info_avail)
                                {
?>
                            <p>Availability: 

                    <form action="<?php echo getProductDetailLink($spotProduct->getId());?>" method="post" id="productAvailabillityEditArea">
                        <input type="hidden" name="formType" value="editproductavailability"/>
                        <input type="hidden" name="productId" value="<?php echo $spotProduct->getId();?>"/>
                        <input type="text"  id="productAvailabilityText" name="productAvailabilityText" value="<?php echo $spotProduct->getAvailability();?>"/>
                        <br/>
                        <button id="editProductAvailabilityUpdateBtn" type="submit" class="btn btn-warning" onclick="javascript:$(this).parent().children('#page_loading').show();">Update</button>
                        <img id="page_loading" src="img/ajax-loader.gif" alt="loading" style="display:none">

                        <?php include("./include/ckeditor.php"); ?>
                    </form>   
                            </p>
<?php 
                                }
                                else
                                {
?>
                            <p>Availability: <?php echo $spotProduct->getAvailability();?></p>
<?php
                                }
?>

                            
<?php
                            }
                            $spotProductProductCode = $spotProduct->getProductCode();
                            if(!empty($spotProductProductCode))
                            {
?>
                            <p>Product Code: <?php echo $spotProductProductCode;?></p>
<?php
                            }
?>
                        </div>                        
                    </div> 
                            
                    </div>  
                        
    <div class="row">
        <div class="span5">
            
<?php
            
            $productComponents = getComponentProductsByCode($spotProduct->getProductCode());
            $totalCompoentCount = 0;

            if(isset($productComponents) && $productComponents->totalNodes() > 0)
            {
?>
            <div class="well">
            <form action="./Basket" method="post" id="addDefaultComponentsForm">
                <input type="hidden" name="formType" value="addBasketItems"/>
            <table class="table table-striped table-condensed table-hover">
                <thead><th>Component</th><th>Availability</th><th>Unit Price</th><th id="addDefaultComponentsFormQtyFieldHeader">Qty (default)</th><th></th></thead>
                <tbody>
<?php
                    for($j=1; $j <= $productComponents->totalNodes(); $j++)    
                    {
                        $nxtComponent = $productComponents->readNode($j);
?>
                    <tr>
                        <td><a href="<?php echo getProductDetailLink($nxtComponent->getId());?>"><?php echo $nxtComponent->getName();?></a></td>
                        <td><?php echo $nxtComponent->getAvailability();?></td>
                        <td><?php echo $nxtComponent->getPrice();?></td>
                        <td>
                            <input type="hidden" name="addBasketItems[]" value="<?php echo $nxtComponent->getId();?>"/>
                            
                            <?php
                            $nxtComponentDefaultCount = getComponentDefaultQty($spotProduct->getProductCode(), $nxtComponent->getProductCode());
                            $totalCompoentCount = $totalCompoentCount + $nxtComponentDefaultCount;
                            
                            ?>
                            <input class="input-mini" name="addBasketItemCount[]" type="number" min="0" max="999" value="<?php echo $nxtComponentDefaultCount;?>">
                        </td>
                    </tr>   
<?php
                    }
?>
                <tr>
                    <td></td>
                    <td></td>
                    <td></td>
                    <td>                            
                            <button class="btn btn-primary" type="button" id="addDefaultComponentsBtn"><i class="icon-shopping-cart icon-white"></i> Add (<span id="addDefaultComponentsBtnCount"><?php echo $totalCompoentCount; ?></span>)</button>
                            <script>
                                $(document).ready(function(){
                                    $('#addDefaultComponentsBtnCount').text(getTotalComponentCount());
                                    function getTotalComponentCount(){
                                        var totalComponentCount = 0;
                                        $('#addDefaultComponentsForm :input[type="number"]').each(function(){
                                            totalComponentCount += Number($(this).val());
                                        });
                                        return totalComponentCount;
                                    }
                                    $('#addDefaultComponentsBtn').click(function(){
                                        if(getTotalComponentCount() > 0){
                                            $('#addDefaultComponentsForm').submit();   
                                        }
                                    });
                                    $('#addDefaultComponentsForm :input[type="number"]').bind('keyup mouseup', function() {
                                        $('#addDefaultComponentsBtnCount').text(getTotalComponentCount());
                                        $('#addDefaultComponentsFormQtyFieldHeader').text('Qty'); 
                                    });
                                });
                            </script>
                    </td>
                </tr>
                </tbody>
            </table>
            </form>
            </div>
<?php    
            }
?>
            
        </div>
    </div>                      
                    </div>
                
                    <div id="contact-modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="contact-modal" aria-hidden="true">
                        <div class="modal-body">
                            <form id="modal-contact-form" class="form-horizontal" action="<?php echo $_SERVER['REQUEST_URI'];?>" method="post">
                                <input type="hidden" name="formType" value="contactMessage"/>

                                <div class="control-group">
                                    <label class="control-label" for="inputName">Name</label>
                                    <div class="controls">
                                        <input type="text" id="inputName" name="inputName" placeholder="name" <?php if (isset($thisUser)){ echo "value='".$thisUser->getFirstname()." ".$thisUser->getLastname()."'";}?>>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputEmail">Email</label>
                                    <div class="controls">
                                        <input type="text" id="inputEmail" name="inputEmail" placeholder="Email" <?php if (isset($thisUser)){ echo "value='".$thisUser->getEmail()."'";}?>>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputPhone">Phone</label>
                                    <div class="controls">
                                        <input type="text" id="inputPhone" name="inputPhone" placeholder="Phone" <?php if (isset($thisUser)){ echo "value='".$thisUser->getContactPhoneNo()."'";}?>>
                                    </div>
                                </div>
                                <div class="control-group">
                                    <label class="control-label" for="inputComments">Question</label>
                                    <div class="controls">
                                        <textarea rows="5" name="inputComments">Q. Regarding <?php echo $spotProduct->getName();?>...</textarea>

                                <br /><br />
                <?php
                                require_once('./include/recaptchalib.php');
                                echo recaptcha_get_html(KeyRing::recaptcha_publickey);
                ?>
                                    </div>
                                </div>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button class="btn" onclick="javascript:$('#modal-contact-form').submit();" data-dismiss="modal" aria-hidden="true">Send</button>
                            <button class="btn" data-dismiss="modal" aria-hidden="true">Cancel</button>
                            <a href="./Contact">Other Contact Details</a>
                        </div>
                    </div>
            </div>
            <!-- product description END-->
            <!-- product details-->
            
    <div class="row">
        <div class="span9">
            <div class="row border_top_pic">
        
        <div class="span5">
            <div class="row">
            <br/>    
            </div>
            <div class="row">
                <div class="span5">
                    <h4>Product Details</h4>
<?php
                if(in_array($userId, KeyRing::$admins) && $liveUpdate && $info == $info_details)
                {
?>
                    <form action="<?php echo getProductDetailLink($spotProduct->getId());?>" method="post" id="productDetailsEditArea">
                        <input type="hidden" name="formType" value="editproductdetails"/>
                        <input type="hidden" name="productId" value="<?php echo $spotProduct->getId();?>"/>
                        <textarea class="config_max" id="productDetailsTextArea" name="productDetailsTextArea" rows="5"> 
                                                        <?php echo $spotProduct->getDetails();?>
                        </textarea>
                        <br/>
                        <button id="editProductDetailsUpdateBtn" type="submit" class="btn btn-warning" onclick="javascript:$(this).parent().children('#page_loading').show();">Update</button>
                        <img id="page_loading" src="img/ajax-loader.gif" alt="loading" style="display:none">

                        <?php include("./include/ckeditor.php"); ?>
                    </form>
<?php  
                }
                else
                {
?>
                        <p>
                            <?php echo $spotProduct->getDetails();?>
                        </p>
<?php
                }
?>

                
                                        <br/>
                </div>
                <!-- info -->
            </div>
        </div>
        <div class="span4">
            <div class="row">
            <br/>    
            </div>

            <div class="row">
                <div class="span4 border_left_grey padding_small">
            <div class="row">
                <div class="span4">
                                    <h5>Documentation</h5>
    <?php
                                    if($userId > 0)
                                    {  
                                        $productDocuments = getDocumentsByProductCode($spotProduct->getProductCode());
                                        $productDocLoc = "./files/".$spotProduct->getProductCode();
                                        if(isset($productDocuments) && $productDocuments->totalNodes() > 0)
                                        {
    ?>
                                        <table class="table table-striped table-condensed table-hover">
                                            <thead><th>Name</th><th>Type</th></thead>
                                            <tbody>
    <?php
                                                for($j=1; $j <= $productDocuments->totalNodes(); $j++)    
                                                {
                                                    $nxtDoc = $productDocuments->readNode($j);
                                                    $name = substr($nxtDoc,0,strpos($nxtDoc,'.'));
    ?>
                                                <script type="text/javascript">
                                                    $(document).ready(function(){
                                                        $('#document_row_<?php echo $name;?>').click(function() {
                                                            window.open("<?php echo $productDocLoc.'/'.$nxtDoc;?>","_blank");
                                                        });
                                                    });
                                                </script>
                                                <tr id="document_row_<?php echo $name;?>" style="cursor:pointer">
                                                    <td><?php echo basename($nxtDoc);?></td>
                                                    <td>PDF</td>
                                                </tr>   
    <?php
                                                }
    ?>
                                            </tbody>
                                        </table>
    <?php    
                                        }
                                        else
                                        {
?>
                                                <p>There is no documentation available at this time.</p>
<?php
                                        }
                                    }
                                    else
                                    {
?>
                                        <p>Please <a href="./SignIn?returnUrl=<?php echo $_SERVER['REQUEST_URI'];?>">sign in</a> or <a href="./Register?returnUrl=<?php echo $_SERVER['REQUEST_URI'];?>">register.</a></p>
<?php
                                    }
    ?>
                </div>
                <!-- downloads -->
            </div>
            <div class="row">
                <div class="span4">
                                    <h5>Specifications</h5>
                                    
<?php
                if(in_array($userId, KeyRing::$admins) && $liveUpdate && $info == $info_spec)
                {
?>
                    <form action="<?php echo getProductDetailLink($spotProduct->getId());?>" method="post" id="productSpecificationsEditArea">
                        <input type="hidden" name="formType" value="editproductspecifications"/>
                        <input type="hidden" name="productId" value="<?php echo $spotProduct->getId();?>"/>
                        <textarea class="config_max" id="productSpecificationsTextArea" name="productSpecificationsTextArea" rows="5"> 
                            <?php echo $spotProduct->getSpecifications();?>
                        </textarea>
                        <br/>
                        <button id="editProductSpecificationsUpdateBtn" type="submit" class="btn btn-warning" onclick="javascript:$(this).parent().children('#page_loading').show();">Update</button>
                        <img id="page_loading" src="img/ajax-loader.gif" alt="loading" style="display:none">

                        <?php include("./include/ckeditor.php"); ?>
                    </form>
<?php    
                }
                else
                {
?>
                        <p>
                            <?php echo $spotProduct->getSpecifications();?>
                        </p>
<?php
                }
?>


                </div>
            </div>
        </div>
                
            </div>
        </div>
            </div>
            
        </div>
            </div>
            <!-- product details END-->
            
            <div class="row border_bottom_pic">
                <br/>
            </div> 
            <!-- product reviews -->
            <div class="row">
                <div class="span9">
                     <div id="disqus_thread"></div>
                        <script type="text/javascript">
                            /* * * CONFIGURATION VARIABLES: EDIT BEFORE PASTING INTO YOUR WEBPAGE * * */
                            var disqus_shortname = 'adgdevelopments'; // required: replace example with your forum shortname
                            var disqus_identifier = 'productDetail_<?php echo $spotProduct->getProductCode();?>';
                            var disqus_title = '<?php echo $spotProduct->getName();?>';
                            var disqus_url = '<?php echo getProductDetailLink($spotProduct->getId());?>';

                            /* * * DON'T EDIT BELOW THIS LINE * * */
                            (function() {
                                var dsq = document.createElement('script'); dsq.type = 'text/javascript'; dsq.async = true;
                                dsq.src = '//' + disqus_shortname + '.disqus.com/embed.js';
                                (document.getElementsByTagName('head')[0] || document.getElementsByTagName('body')[0]).appendChild(dsq);
                            })();
                        </script>
                        <noscript>Please enable JavaScript to view the <a href="http://disqus.com/?ref_noscript">comments powered by Disqus.</a></noscript>
                        <a href="http://disqus.com" class="dsq-brlink">comments powered by <span class="logo-disqus">Disqus</span></a>

                </div>
            </div>  
            <!-- product reviews END -->

        </div>
        <div class="span2">

<?php
        if(count($recentlyViewed) > 1){
?>
            <!-- recently viewed -->
            <div class="row">
                <div class="span2">
                    <h5 class="badge">Recently Viewed</h5>
                </div>
            </div>
<?php

            foreach ($recentlyViewed as $recentProductId)
            {
                //don't show if this product is in list
                if ($recentProductId != $productid) 
                {
                    $nxtProduct = getProductBaseById($recentProductId);
                    if(isset($nxtProduct) && $nxtProduct->getId() > 0)
                    {
?>
            <div class="row">
                <div class="span2">
                        <a  class="thumbnail" href="<?php echo getProductDetailLink($nxtProduct->getId());?>">
                            <img class="" src="<?php echo getBestImageByProductCode($nxtProduct->getProductCode(), 400, 200)->getSrc();?>"/>
                        <div class="caption">
                            <h4 class="header_text"><?php echo $nxtProduct->getName();?></h4>
                        </div>
                        </a>
                </div>
            </div>
            <br/>
<?php
                    }
                }
            }


?>
            
            <!-- recently viewed END-->
            
<?php
        }
        else
        {
?>
            <!-- top products -->
            

            <div class="span2">
                <div class="row">
                    <div class="span2">
                        <h5 class="badge">Top Products</h5>
                    </div>
                </div>
            <?php
                $productList = getTopProducts(3);

                for($i=1; $i <= $productList->totalNodes(); $i++)    
                {
                    $nxtProduct = $productList->readNode($i);
                    ?>
                <div class="row">
                    <div class="span2">
                            <a  class="thumbnail" href="<?php echo getProductDetailLink($nxtProduct->getId());?>">
                                <img class="" src="<?php echo getBestImageByProductCode($nxtProduct->getProductCode(),400,200)->getSrc();?>"/>
                            <div class="caption">
                                <h4 class="header_text"><?php echo $nxtProduct->getName();?></h4>
                            </div>
                            </a>
                    </div>
                </div>
                <br/>
                    <?php
                }
            ?>
            </div>
            
            <!-- top products END -->

<?php
        }
?>
            
        </div>
    </div>
          
<?php
            }
?>
</div>