<?php
$INC_DIR = "./classes/";
include("include/dbconnect.php");
include("include/validate.php");
include("include/process.php");
include("include/support.php");
include("include/misc.php");
date_default_timezone_set('Europe/Dublin');
/*
create/resume session
*/
my_session_restart();

$_SESSION['valid'] = true;

$userId = 0;

$messages = new LinkList();

if((!empty($_GET['preprocess'])) && (isset($_GET['preprocess'])))
{
    $messages = processGet();
}
if((!empty($_POST['formType'])) && (isset($_POST['formType'])))
{
    $messages = processPost();
}

$userId = validateUser();


if((!empty($_GET['catshortname'])) && isset($_GET['catshortname']))
{
    $catid = getCatIdByShortname($_GET['catshortname']);
}

    if(empty($content) || !isset($content))
    {
        if((!empty($_GET['page'])) && isset($_GET['page']))
        {
            $pagename = $_GET['page'];

            switch ($pagename){
                    case "welcome":
                            $content = "welcome.php";
                    break;
                    case "browse":
                            //$content = "productBrowse.php";
                            $content = "productFilter.php";
                            if((empty($_GET['catshortname'])) || !isset($_GET['catshortname']))
                            {
                                $content = "welcome.php";
                            }
                    break;
                    case "product":
                            $content = "productDetail.php";
                    break;
                    case "basketDetails":
                            $content = "basketDetail.php";
                    break;
                    case "register":
                            $content = "register.php";
                    break;
                    case "signIn":
                            $content = "signIn.php";
                    break;
                    case "policy":
                            $content = "policy.php";
                    break;
                    case "contact":
                            $content = "contact.php";
                    break;
                    case "request":
                            $content = "requestDetail.php";
                    break;
                    case "review":
                            $content = "productReview.php";
                    break;
                    case "store":
                    break;
                    case "search":
                            $content = "productSearch.php";
                    break;
                    case "company":
                    break;
                    case "gallery":
                            $content = "gallery.php";
                    break;
                    case "decrypt":
                            $content = "decrypt.php";
                    break;
            }
             
            /* Logged in users */   
            if(empty($content) || !isset($content))
            {
                if($userId > 0)
                {
                    switch ($pagename){
                        case "account":
                            if($userId > 0)
                            {
                                $content = "account.php";
                            }
                            else
                            {
                                $content = "userLogin.php";
                            }

                        break;
                    }
                }
            }
                
            /* Admin users */
            if(empty($content) || !isset($content))
            {
                
                if(in_array($userId, KeyRing::$admins) )
                {

                    switch ($pagename){
                        case "adminSelect":
                                $content = "admin/adminSelect.php";
                            break;
                        case "Delete":
                                $content = "admin/deleteProduct.php";
                            break;
                        case "EditProducts":
                                $content = "admin/editProducts.php";
                            break;
                        case "EditCategories":
                                $content = "admin/editCategories.php";
                            break;
                        case "EditProduct":
                                $content = "admin/editProduct.php";
                            break;
                        case "Attributes":
                                $content = "admin/editAttributes.php";
                            break;
                        case "Files":
                                $content = "admin/editFiles.php";
                            break;
                        case "Images":
                                $content = "admin/editImages.php";
                            break;
                        case "Users":
                                $content = "admin/editUsers.php";
                            break;
                        case "Requests":
                                $content = "admin/requests.php";
                            break;
                    case "oss":
                            $content = "admin/oss.php";
                    break;
                    }
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Page not found.</p>");
                    $messages->insertLast($alert);
                }
            }
        }
    }

if(!isset($content) || empty($content))
{
    $content = 'welcome.php';
}

$metaKeywords = generateMetaKeywords($pagename);
?>

<!DOCTYPE html>
<html lang="en">
  <head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" /> 
    <title></title>
    
    <meta name="author" content="">
    <meta name="description" content="Ariel Door Gears supply high quality interior exterior sliding door gear, gate automation solutions with a large selection of gate door accessories" />
    <meta name="keywords" content="<?php echo $metaKeywords;?>" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <!-- Le styles -->
    <base href="<?php echo KeyRing::baseHref;?>" />
    <link href="css/bootstrap.css" rel="stylesheet">
    <link href="css/style1.0.css" rel="stylesheet"> 
    <link href="css/blitzer/jquery-ui-1.9.0.custom.css" rel="stylesheet">
    
    

    <script type="text/javascript" src="js/jquery-1.8.2.js"></script>
    
    
    <script type="text/javascript" src="js/bootstrap.js"></script>
    <script type="text/javascript" src="js/animation.js"></script>
    <script type="text/javascript" src="js/jquery-ui-1.9.0.custom.js"></script>
    <script type="text/javascript" src="ckeditor/ckeditor.js"></script>
    <script type="text/javascript" src="ckeditor/adapters/jquery.js"></script>
    <script type="text/javascript" src="js/galleriffic/jquery.history.js"></script>
    <script type="text/javascript" src="js/galleriffic/jquery.galleriffic.js"></script>
    <script type="text/javascript" src="js/galleriffic/jquery.opacityrollover.js"></script>
    
    
   <!-- <script type="text/javascript">var switchTo5x=true;</script> -->
   <!-- <script type="text/javascript" src="http://w.sharethis.com/button/buttons.js"></script>-->
   <!-- <script type="text/javascript">stLight.options({publisher: "ae640043-84b1-469a-a74a-a65f98c5db42", doNotHash: false, doNotCopy: false, hashAddressBar: false});</script>-->
    
    <!-- Le HTML5 shim, for IE6-8 support of HTML5 elements -->
    <!--[if lt IE 9]>
      <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->

    <!-- Le fav and touch icons -->
    <link rel="shortcut icon" href="./img/favicon.ico">

    
<?php
include_once('analyticstracking.php');
?>
      
  </head>

  <body>
      
      <a name="top"></a>
      <div class="container">
        <div class="row">
            <div class="span12">
                <div class="top-header">
                    <div class="row">
                        <div class="span4">
                            Free delivery available!
                        </div>
                        <div class="span3 pull-right">
                             <a href=".">Home</a> | <a href="./Contact">Contact</a> | <a href="./Policy?policy=privacy">Cookies</a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="span12">
                <div class="basebackground padding_bottom_large">
                
                
                <div class="row">
                        <?php
                        include('indexHeader.php');
                        ?>
                </div>
                
<?php

                            if (in_array($userId, KeyRing::$admins))
                            {
                            ?>
                        <div class="row">
                        <div class="span2 pull-right">
                            <div class="btn-group">
                                <a class="btn dropdown-toggle" data-toggle="dropdown">
                                    Administration
                                    <span class="caret"></span>
                                </a>
                                <ul class="dropdown-menu">
                                    <li><a tabindex="-1" href="./Admin/oss">Product OSS</a></li>
                                    <?php
                                        //EDIT#201309291331:img updates are currently disabled
                                        //EDIT#201405142029:replacing product updates with oss, and files with FTP
                                        
                                        if(false)
                                        {
                                    ?>
                                    <li><a tabindex="-1" href="./Admin/EditCategories">Categories</a></li>
                                    <li><a tabindex="-1" href="./Admin/EditProducts">Products</a></li>
                                    <li><a tabindex="-1" href="./Admin/Attributes">Attributes</a></li>
                                    <li><a tabindex="-1" href="./Admin/Files">Files</a></li>
                                    <li><a tabindex="-1" href="./Admin/Images">Images</a></li>
                                    <?php
                                        }
                                    ?>
                                    <li><a tabindex="-1" href="./Admin/Users">Users</a></li>
                                    <li><a href="<?php echo "./Admin/Requests?requestType=".TypeMgr::quoteRequest."&requestState=".StateMgr::requestPending;?>"><?php echo "Quotes (".getRequestCountByTypeAndState(TypeMgr::quoteRequest,StateMgr::requestPending).")";?></a></li>
                                    <li><a href="<?php echo "./Admin/Requests?requestType=".TypeMgr::contactRequest."&requestState=".StateMgr::requestPending;?>"><?php echo "Messages (".getRequestCountByTypeAndState(TypeMgr::contactRequest,StateMgr::requestPending).")";?></a></li>
                    
                    
                                </ul>
                            </div>
                            </div>
                            </div>
                    <br/>
                            <?php
                            }
?>

                <div class="row">
                    <div class="span11">
                        <div class="navbar center">
                            <div class="navbar-inner">
                                <ul class="nav">
                                    
<?php
                $cats = getCategories();

                if(isset($cats) && $cats->totalNodes() > 0)
                {
                            for($i=1; $i <= $cats->totalNodes(); $i++)    
                            {
                                $nxtCat = $cats->readNode($i);
?>
                                    <li class="<?php if(isset($catid) && (strcmp($catid,$nxtCat->getId()) == 0)){echo "active";}?>">
                                        <a href="./<?php echo $nxtCat->getShortname();?>">
                                            <?php echo $nxtCat->getName();?>
                                        </a>
                                    </li>
<?php
                            }
                }
                                
?>
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="main_content">
<?php
if(isset($_SESSION['messages']) && !is_null($_SESSION['messages']))
{
    $messages->addListToEnd($_SESSION['messages']);
    $_SESSION['messages'] = new LinkList();
}

if(isset($messages) && $messages->totalNodes() > 0)
{
?>
                        <div class="row">
                            <div class="span9 offset1">
<?php
    for($i=1; $i <= $messages->totalNodes(); $i++)    
    {
        $message = $messages->readNode($i);
?>
                                <div class="<?php echo $message->getClasses()?>"><?php echo $message->getContent()?></div>    
<?php   
    }
?>
                            </div>
                        </div>
<?php
}
                        
include($content);
?>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </div>
    <footer>
        <div class="container">
            <div class="row footer_main">
                <div class="span10 offset1">
                    <div class="row">
                        <div class="span2">
                            <h6 class="border_bottom">Contact</h6>
                            <p>
                                <address>
                                    <strong>Ariel Door Gears <small>Ltd</small></strong><br>
                                    Unit 1A <br>
                                    Dunboyne Ind. Est.<br>
                                    Dunboyne<br>
                                    Co Meath<br>
                                    Ireland<br><br>
                                    <strong>Phone:</strong><br> (003531) 833 3168<br>
                                    <strong>Fax:</strong> (003531) 833 5841<br>
                                    <strong>Email:</strong> info [at] adg.ie<br>
                                    <strong>Skype:</strong> 
                                    <script type="text/javascript" src="http://download.skype.com/share/skypebuttons/js/skypeCheck.js"></script>
                                    <a href="skype:ariel_door_gears?call">
                                        <img src="http://download.skype.com/share/skypebuttons/buttons/call_blue_transparent_70x23.png" style="border: none;" width="70" height="23" alt="Skype Me™!" />
                                    </a>
                                    <br/>
                                </address>
                            </p>
                        </div>
                        <div class="span4 offset1">
                            <h6 class="border_bottom">Explore</h6>
                            <div class="row">
                                <div class="span4">
                                    
                                    <h6>Categories</h6>
                                    <table class="span4">
                                        <tbody>
                                        <tr>
<?php
                $cats = getCategories();

                if(isset($cats) && $cats->totalNodes() > 0)
                {
                            $halfCatsPrinted = false;
                            for($i=1; $i <= $cats->totalNodes(); $i++)    
                            {
                                $nxtCat = $cats->readNode($i);
?>
                                    <td>
                                        
                                        <a href="./<?php echo $nxtCat->getShortname();?>">
                                            <?php echo $nxtCat->getName();?>
                                        </a>
                                    </td>
<?php
                                if($i%2 == 0)
                                {
?>
                                </tr>
                                <tr>
<?php
                                    
                                }

                            }
                }
                                
?>
                                      </tr>
                                      </tbody>
                                    </table>
                                </div>
                            </div>
                            <div class="row">
                                <div class="span2">
                                    <h6>Help / FAQ</h6>
                                    <ul style="list-style-type: none;">
                                        <li><a href="./Contact">Contact us</a></li>
                                        <li><a href="#">Delivery & Collection</a></li>
                                        <li><a href="#">Support</a></li>
                                        <li><a href="./Policy">Return policy</a></li>
                                        <li><a href="#">Payment methods</a></li>
                                    </ul>
                                </div>
                                <div class="span2">
                                    <h6>Security / Policies</h6>
                                    <ul style="list-style-type: none;">
                                        <li><a href="./Policy?policy=privacy">Privacy & Security</a></li>
                                        <li><a href="./Policy?policy=contact">Contacting our customers</a></li>
                                        <li><a href="./Policy?policy=purchase">Purchasing Terms & Conditions</a></li>
                                        <li><a href="./Policy?policy=website">Site terms of use</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <div class="span2 offset1">
                            <h6 class="border_bottom">Register</h6>
                            <p>
                                Sign up to www.adg.ie today to acquire access to our online catalogue database.
                            <br/>
                                Registered users also can request quotes on our products and services.
                            <br/>
                                <a role="button" href="./Register?returnUrl=<?php echo $_SERVER['REQUEST_URI'];?>" class="btn btn-primary btn-small pull-right">Register</a>
                            </p>
                        </div>
                    </div>
                    <br/>
                    <br/>
                    <div class="row border_top">
                        <br/>
                        <div class="span6">
                            <p>&copy; Ariel Door Gears Ltd <?php echo date("Y");?>. All rights reserved.</p>
                        </div>
                        <div class="span3 offset1">
                            <p class="pull-right"><a href="#top">Back to top <i class="icon-chevron-up"></i></a></p>
                    
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer>
	
<?php
include_once('statcountertracking.php');
?>
      
  </body>
</html>
