<?php

function validateOSSDELETEJob($job, &$errorStr)
{
    
    $headers = OSSKeyRing::$deleteHeaders;
    
    foreach($headers as $col){
        if(!isset($job[$col])){
            $errorStr = "missing column [$col]";
            return false;
        }
    }
    if(strcasecmp($job[OSSKeyRing::header_operation], "delete") != 0){
        $errorStr = "invalid operation";
        return false;
    }
    return true;
}

function validateOSSCREATEJob($job, &$errorStr)
{
    $headers = OSSKeyRing::$createHeaders;
    
    foreach($headers as $col){
        if(!isset($job[$col])){
            $errorStr = "missing column [$col]";
            return false;
        }
    }
    if(strcasecmp($job[OSSKeyRing::header_operation], "create") != 0){
        $errorStr = "invalid operation";
        return false;
    }
    if($job[OSSKeyRing::header_price]<0){
        $errorStr = "invalid price [".$job[OSSKeyRing::header_price]."], must be positive";
        return false;
    }
    if(validateDecimal($job[OSSKeyRing::header_price])===false){
        $errorStr = "invalid price [".$job[OSSKeyRing::header_price]."], failed to validate decimal value";
        return false;
    }
    if($job[OSSKeyRing::header_discount]<0 || $job[OSSKeyRing::header_discount]>100){
        $errorStr = "invalid discount [".$job[OSSKeyRing::header_discount]."], must be positive beteen 0 and 100";
        return false;
    }
    if(validateDecimal($job[OSSKeyRing::header_discount])===false){
        $errorStr = "invalid discount [".$job[OSSKeyRing::header_discount]."], failed to validate decimal value";
        return false;
    }
    if($job[OSSKeyRing::header_availability]<0){
        $errorStr = "invalid availability [".$job[OSSKeyRing::header_availability]."], must not be negative";
        return false;
    }
    
    return true;
}
function validateBasket($basket)
{
    //is the list well formed?
    //are the counts correct & positive?
    try{
        if(!isset($basket) || is_null($basket))
            throw new Exception("Basket is not set or null.");
        
        if(!$basket->validateBasket())
            throw new Exception("Basket failed to validate itself.");
        
        $lineItemCount = $basket->getNbLineItems(); 
        if($lineItemCount < 0)
        {
            throw new Exception("No. of line items in baskets is negative.");
        }
        $totalItemCount = $basket->getTotalItems();
        if($totalItemCount < 0)
        {
            throw new Exception("No. of total items in baskets is negative.");
        }
        $localLineItemCount = 0;
        $localTotalItemCount = 0;
        for($i=1; $i <= $lineItemCount; $i++)    
        {
            $localLineItemCount++;
            $nxtItem = $basket->items->readNode($i);
            $qty = $nxtItem->getQty();
            if($qty < 0){throw new Exception("Product Qty is negative.");}
            $localTotalItemCount += $qty;
            $listPrice = $nxtItem->getListPrice();
            if($listPrice < 0){throw new Exception("Product List Price is negative.");}
            $discountPercent = $nxtItem->getDiscountPercent();
            if($discountPercent < 0){throw new Exception("Product Discount Percent is negative.");}
            $itemPrice = $nxtItem->calculateItemPrice();
            if($itemPrice < 0){throw new Exception("Product Item Price is negative.");}
            $itemSubtotal = $nxtItem->calculateItemSubtotal();
            if($itemSubtotal < 0){throw new Exception("Product Item Subtotal is negative.");}
        }
        if($localLineItemCount != $lineItemCount){throw new Exception("Line item count does not match current count.");}
        if($localTotalItemCount != $totalItemCount){throw new Exception("Total item count does not match current count.");}
    }catch(Exception $e)
    {
        $alert = new Div();
        $alert->setClasses("alert alert-error");
        $alert->setContent("<p>Sorry, an error occured your and basket has been cleared as a result.</p>");
        addToMessages($alert);
        $specifics = $e->getMessage();
        $specifics .= $e->getTraceAsString();
        logEntry(StateMgr::logSevere,"Exception thrown when validating basket. [$specifics]");
        return false;
    }
    return true;    
}
function addToMessages($msg)
{
    $msgs = new LinkList();

    if(isset($_SESSION['messages']) && !is_null($_SESSION['messages']))
    {
        $msgs = $_SESSION['messages'];
    }

    $msgs->insertLast($msg);

    $_SESSION['messages'] = $msgs;
}
function validateDecimal($decimal)
{
    $result = false;
    $result = filter_var($decimal,FILTER_VALIDATE_REGEXP,array("options"=>array("regexp"=>"/^[0-9]+(\.\d{0,2})?$/")));
    //note: use === to check result of this fn, as a zero might be a valid result but be interpreted as false
    return $result;
}
function validateUser()
{
    if((isset($_SESSION['userid'])) && ($_SESSION['userid'] > 0))
    {
        $user = getUserById($_SESSION['userid']);
        if ($user->getUserState() == StateMgr::userApproved)
        {
            return $_SESSION['userid'];   
        }
    }
    
    return 0;
}
function validateEmail($email)
{
	$result = true;
	if (!strpbrk($email, '@')) $result = false;

	if (phpversion() >= '5.0.0')
	{
		if(!filter_var($email, FILTER_VALIDATE_EMAIL))
		{
			$result = false;
		}
	}
	
	return $result;
}
function validateIntArray($intArray)
{
    foreach($intArray as $nxtInt){
        if(!is_numeric($nxtInt)){
            return false;
        }
    }
    return true;    
}
function cleanQueryArray($stringArray)
{
    $mysqli = dbconnecti();
    for($i=0; $i < count($stringArray); $i++)    
    {
        if(get_magic_quotes_gpc())  // prevents duplicate backslashes
        {
                $stringArray[$i] = stripslashes($stringArray[$i]);
        }
        if (phpversion() >= '4.3.0')
        {
                $stringArray[$i] = $mysqli->real_escape_string($stringArray[$i]);
        }
        else
        {
                $stringArray[$i] = mysql_escape_string($stringArray[$i]);
        }
    }
    dbclosei($mysqli);
    return $stringArray;
}

function cleanQuery($string)
{
    $mysqli = dbconnecti();
    if(get_magic_quotes_gpc())  // prevents duplicate backslashes
    {
            $string = stripslashes($string);
    }
    if (phpversion() >= '4.3.0')
    {
            $string = $mysqli->real_escape_string($string);
    }
    else
    {
            $string = mysql_escape_string($string);
    }
    dbclosei($mysqli);
    return $string;
}



?>
