<?php

include("classesProxy.php");
include("dataLayer.php");

require_once('recaptchalib.php');
                
function processPost()
{
    $user_id = 0;
    if(isset($_SESSION['userid']))
    {
            $user_id = $_SESSION['userid'];
    }
    $messages = new LinkList();
    
/*
 - retreive request data
 - clean data
 - validate request data

*/

    switch ($_POST['formType']){
        case "ossImport":

            if(!empty($_FILES['fileupload']))
            {

                $targetfilename = $_FILES["fileupload"]["name"];
                if ($_FILES["fileupload"]["error"] > 0)
                {                                                        
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Return Code: " . $_FILES["fileupload"]["error"]."</p>");
                        $messages->insertLast($alert);
                        break;
                }
                                 
                $alert = new Div();
                $alert->setClasses("alert alert-success");
                $alert->setContent("<p><strong>File:</strong> " .$targetfilename."</p>");
                $messages->insertLast($alert);
                
                $filename = $_FILES["fileupload"]["tmp_name"];
                $jobLines = csv_to_array($filename);
                
                $successJobCount = 0;
                $failedJobCount = 0;
                $createJobCount = 0;
                $updateJobCount = 0;
                $deleteJobCount = 0;
                
                for ($i=0; $i<count($jobLines); $i++) {
                    $job = $jobLines[$i];
                    $errorStr = "";
                    if(!isset($job[OSSKeyRing::header_operation]))
                    {
                        $lineNum = $i+2;
                        $failedJobCount = $failedJobCount + 1;
                        
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p><strong>Error on line ".$lineNum.":</strong> column [".OSSKeyRing::header_operation."] not found</p><br/><p>The remaining lines have been skipped</p>");
                        $messages->insertLast($alert);
                        break 1;
                    }
                    
                    if(strcasecmp($job[OSSKeyRing::header_operation], "create") == 0 && validateOSSCREATEJob($job,$errorStr) && executeOSSCREATEJob($user_id,$job, $errorStr))
                    {
                        $successJobCount = $successJobCount + 1;
                        $createJobCount = $createJobCount + 1;
                    }
                    elseif(strcasecmp($job[OSSKeyRing::header_operation], "delete") == 0 && validateOSSDELETEJob($job,$errorStr) && executeOSSDELETEJob($user_id,$job, $errorStr))
                    {
                        $successJobCount = $successJobCount + 1;
                        $deleteJobCount = $deleteJobCount + 1;
                    }
                    else
                    {    
                        $lineNum = $i+2;
                        $failedJobCount = $failedJobCount + 1;
                        
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p><strong>Error on line ".$lineNum.":</strong> $errorStr</p><br/><p>The remaining lines have been skipped</p>");
                        $messages->insertLast($alert);
                        break 1;
                    }
                }
                

                if(!removeEmptyCategories())
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p><strong>Failed to delete orphan categories</p>");
                    $messages->insertLast($alert);
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-success");
                $alert->setContent("<p><strong>Summary:</strong> $successJobCount successful, $failedJobCount errors</p>");
                $messages->insertLast($alert);               

            }
            else
            {
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>No file found.</p>");
                $messages->insertLast($alert);
                break;
            }
            break;
        
        case "productReview":
            
                $productid = cleanQuery($_POST['productid']);
                $identityChoice = cleanQuery($_POST['identityChoice']);
                $reviewBody = cleanQuery($_POST['reviewBody']);
                $qualityChoice = cleanQuery($_POST['qualityChoice']);
                $valueChoice = cleanQuery($_POST['valueChoice']);
                $performanceChoice = cleanQuery($_POST['performanceChoice']);
                $appearanceChoice = cleanQuery($_POST['appearanceChoice']);

                if(isset($_POST['user_acceptpolicy']) && strcmp($_POST['user_acceptpolicy'],"on") == 0){
                    $user_acceptpolicy = "1";
                }else{
                    $user_acceptpolicy = "0";
                }    
                
                
                //verify acceptance of privacy and terms and conditions
                if($user_acceptpolicy != 1)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Sorry, you must accept the privacy policy.</p>");
                    $messages->insertLast($alert);        
                    break;
                }
                
                $userid = 0;
                if ($identityChoice == "user")
                {
                    $userid = validateUser();
                }
                
                if(submitReviewRequest($productid,$qualityChoice,$valueChoice,$performanceChoice,$appearanceChoice,$reviewBody,$userid))
                {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Thank you, your review will be published following an approval.</p>");
                        $messages->insertLast($alert);        
                        break;   
                }
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, an error has occured.</p>");
                $messages->insertLast($alert);        
                break; 
                
            break;
        case "securityDetailsUpdate":
            
                if ($user_id > 0)
                {
                    $user_password = cleanQuery($_POST['user_password']);
                    $user_passwordconfirm = cleanQuery($_POST['user_passwordconfirm']);

                    //verify password length
                    if(Strlen($user_password) < 5)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Account update failed, password is too short.</p>");
                        $messages->insertLast($alert);        
                        break;   
                    }
                    //verify passwords match
                    if(strcmp($user_password,$user_passwordconfirm) != 0)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Account update failed, password and confirmation password didn't match.</p>");
                        $messages->insertLast($alert);        
                        break;
                    }
                    if (updateSecurityDetails($user_id,$user_password))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Account update succeeded.</p>");
                        $messages->insertLast($alert); 
                        break;
                    }  
                    
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, update failed.</p>");
                $messages->insertLast($alert);
                
            break;
        case "AddUserAddr":
            
                if ($user_id > 0)
                {
                    if (createBillingDetails($user_id))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Account update succeeded.</p>");
                        $messages->insertLast($alert); 
                        break;
                    } 
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, update failed.</p>");
                $messages->insertLast($alert);
                
            break;
        case "billingDetailsUpdate":
            
                if ($user_id > 0)
                {
                    $addr_index = cleanQuery($_POST['billingDetailsIndex']);
                    if($addr_index > 0)
                    {
                        $user_billingaddr1 = cleanQuery($_POST['user_billingaddr1-'.$addr_index]);
                        $user_billingaddr2 = cleanQuery($_POST['user_billingaddr2-'.$addr_index]);
                        $user_county = cleanQuery($_POST['user_county-'.$addr_index]);
                        $user_postcode = cleanQuery($_POST['user_postcode-'.$addr_index]);
                        $user_country = cleanQuery($_POST['user_country-'.$addr_index]);

                        if (updateBillingDetails($user_id,$addr_index,$user_billingaddr1,$user_billingaddr2, $user_county, $user_postcode,$user_country))
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Account update succeeded.</p>");
                            $messages->insertLast($alert); 
                            break;
                        } 
                    }
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, update failed.</p>");
                $messages->insertLast($alert);
                
            break;
        case "RemoveUserAddr":
            
                if ($user_id > 0)
                {
                    $addr_index = cleanQuery($_POST['billingDetailsIndex']);
                    if (deleteBillingDetails($user_id,$addr_index))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Account update succeeded.</p>");
                        $messages->insertLast($alert); 
                        break;
                    } 
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, update failed.</p>");
                $messages->insertLast($alert);
                
            break;
        case "userDetailsUpdate":
                if ($user_id > 0)
                {
                    $user_title = cleanQuery($_POST['user_title']);
                    $user_firstname = cleanQuery($_POST['user_firstname']);
                    $user_lastname = cleanQuery($_POST['user_lastname']);
                    $user_billingphoneno = cleanQuery($_POST['user_billingphoneno']);
                    $user_contactphoneno = cleanQuery($_POST['user_contactphoneno']);
                    $user_email = cleanQuery($_POST['user_email']);
                    $user_emailconfirm = cleanQuery($_POST['user_emailconfirm']);  
                    //may not exists
                    if(isset($_POST['user_newslettersubscribe']) && strcmp($_POST['user_newslettersubscribe'],"on") == 0){
                        $user_newslettersubscribe = "1";
                    }else{
                        $user_newslettersubscribe = "0";
                    }

                    //verify emails match
                    if(strcmp($user_email,$user_emailconfirm) != 0)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Account update failed, email and confirmation email didn't match.</p>");
                        $messages->insertLast($alert);        
                        break;
                    }
                    //verify email is not already registered to another user
                    $idByEmail = getUserIdByEmail($user_email);
                    if($idByEmail > 0 && $idByEmail != $user_id)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Account update failed, email $user_email is already registered.</p>");
                        $messages->insertLast($alert);        
                        break;
                    }
                    if (updateUserDetails($user_id,$user_title,$user_firstname,$user_lastname,$user_billingphoneno,$user_contactphoneno,$user_email,$user_newslettersubscribe))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Account update succeeded.</p>");
                        $messages->insertLast($alert); 
                        break;
                    }  
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, update failed.</p>");
                $messages->insertLast($alert);
                
            break;
            
        case "contactMessage":
            

                //recaptcha

                $recaptcha_resp = recaptcha_check_answer (KeyRing::recaptcha_privatekey,
                        $_SERVER["REMOTE_ADDR"],
                        $_POST["recaptcha_challenge_field"],
                        $_POST["recaptcha_response_field"]);

                if(!$recaptcha_resp->is_valid)
                {                       
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>You appear to have entered the reCAPTHCA incorrectly. Please try again.</p>");
                    $messages->insertLast($alert);

                }
                else
                {

                    $name = cleanQuery($_POST['inputName']);
                    $email = cleanQuery($_POST['inputEmail']);
                    $fax = "";//cleanQuery($_POST['inputFax']);
                    $phone = cleanQuery($_POST['inputPhone']);
                    $comments = cleanQuery($_POST['inputComments']);

                    if(isset($name) && (isset($email) || isset($phone)))
                    {
                        if(addMessage($name, $email,$fax, $phone,$comments,$user_id))
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Thank you $name, we will process this as soon as possible.</p>");
                            $messages->insertLast($alert);
                            break;
                        }
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Sorry, a processing error has occured.</p>");
                        $messages->insertLast($alert);
                        break;
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Sorry, not enough information has been supplied.</p>");
                        $messages->insertLast($alert);
                        break;
                    }
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Sorry, an error has occured.</p>");
                    $messages->insertLast($alert);
                }
                
                break;
            
        case "quoteRequestRegister":
            
                $user_title = cleanQuery($_POST['user_title']);
                $user_firstname = cleanQuery($_POST['user_firstname']);
                $user_lastname = cleanQuery($_POST['user_lastname']);
                $user_contactphoneno = cleanQuery($_POST['user_contactphoneno']);
                $user_email = cleanQuery($_POST['user_email']);
                
                if(isset($_POST['user_acceptpolicy']) && strcmp($_POST['user_acceptpolicy'],"on") == 0){
                    $user_acceptpolicy = "1";
                }else{
                    $user_acceptpolicy = "0";
                }         
                
                //verify acceptance of privacy and terms and conditions
                if($user_acceptpolicy == 0)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Request failed, you must accept the privacy policy & terms and conditions.</p>");
                    $messages->insertLast($alert);        
                    break;
                }
                //verify email is not already registered to a user
                if(getUserIdByEmail($user_email) > 0)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Request failed, email $user_email is already registered.</p>");
                    $messages->insertLast($alert);        
                    break;
                }
                
                //geolocation (if IE enabled  = true otherwise false)
                
                $userState = StateMgr::userPending;

                $realIpAddr = getRealIpAddr();
                $country = file_get_contents('http://api.hostip.info/country.php?ip='.$realIpAddr);
                if(isset($country) && strcmp($country,"IE") == 0)
                {
                    $userState = StateMgr::userApproved;
                }
                
                logEntry(StateMgr::logDebug, "Irish user geolocation, ip: [$realIpAddr] => country: [$country] => [".StateMgr::getUserStatus($userState)."]");
                $user_password = $user_lastname.generatePassword(3);
                if(addUser($user_title,$user_firstname,$user_lastname,$user_contactphoneno,$user_email,$user_password,$userState))
                {
                    logEntry(StateMgr::logDebug, "user registration sucess email: [$user_email] userState: [".StateMgr::getUserStatus($userState)."]");
                    
                    $hash = hash('sha256', $user_password);
                    $thisUserId = getUserId($user_email, $hash);
                    
                    $requestResult = submitQuoteRequest($_SESSION['basket'], $thisUserId);
                    if($requestResult){
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Thank you for requesting a quote, our sales team will be in contact shortly.</p>");
                        $messages->insertLast($alert);
                        break;

                    }
                    

                    break;
                }
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, this request has failed.</p>");
                $messages->insertLast($alert);
                
                break;
        case "userRegister":
            
                $user_title = cleanQuery($_POST['user_title']);
                $user_firstname = cleanQuery($_POST['user_firstname']);
                $user_lastname = cleanQuery($_POST['user_lastname']);
                $user_contactphoneno = cleanQuery($_POST['user_contactphoneno']);
                $user_email = cleanQuery($_POST['user_email']);
                
                if(isset($_POST['user_acceptpolicy']) && strcmp($_POST['user_acceptpolicy'],"on") == 0){
                    $user_acceptpolicy = "1";
                }else{
                    $user_acceptpolicy = "0";
                }         
                
                //verify acceptance of privacy and terms and conditions
                if($user_acceptpolicy == 0)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Registration failed, you must accept the privacy policy & terms and conditions.</p>");
                    $messages->insertLast($alert);        
                    break;
                }
                //verify email is not already registered to a user
                if(getUserIdByEmail($user_email) > 0)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Registration failed, email $user_email is already registered.</p>");
                    $messages->insertLast($alert);        
                    break;
                }
                
                //geolocation (if IE enabled  = true otherwise false)
                
                $userState = StateMgr::userPending;

                $realIpAddr = getRealIpAddr();
                $country = file_get_contents('http://api.hostip.info/country.php?ip='.$realIpAddr);
                if(isset($country) && strcmp($country,"IE") == 0)
                {
                    $userState = StateMgr::userApproved;
                }
                
                logEntry(StateMgr::logDebug, "Irish user geolocation, ip: [$realIpAddr] => country: [$country] => [".StateMgr::getUserStatus($userState)."]");
                $user_password = $user_lastname.generatePassword(3);
                if(addUser($user_title,$user_firstname,$user_lastname,$user_contactphoneno,$user_email,$user_password,$userState))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->addContent("<p>Thank you $user_title $user_lastname, your registration was successful.</p>");
                    
                    
                    logEntry(StateMgr::logDebug, "user registration sucess email: [$user_email] userState: [".StateMgr::getUserStatus($userState)."]");
                    
                    if($userState == StateMgr::userApproved)
                    {
                        $alert->addContent("<p>You can now use $user_email and $user_password to sign in.</p>");
                        $alert->addContent("<p>We recommend you change this password immediately <a href=\"./Account\">Here</a>.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert->addContent("<p>Your account will require activation by our support team.</p>");
                        $alert->addContent("<p>An email will be sent to $user_email once the account is activated.</p>");
                        $messages->insertLast($alert);  
                        break;
                    }
                    
                    //perform login
                    $hash = hash('sha256', $user_password);
                    $thisUserId = getUserId($user_email, $hash);
                    if($thisUserId == 0)		  
                    {
                        logEntry(StateMgr::logDebug, "failed user login using $user_email and $user_password following registration");
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Something went wrong!</p>");
                        $messages->insertLast($alert);

                        break;
                    }

                    $_SESSION['userid'] = $thisUserId;

                    logEntry(StateMgr::logDebug, "user login success using $user_email");
                        
                    $user_id = $thisUserId;

                    //session_write_close();
                    //header("Location: ".$_SESSION['']);
                    break;
                }
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, registration failed.</p>");
                $messages->insertLast($alert);
                
                
            break;
        case "addBasketItemAsProductCode":
                $addProductCode = cleanQuery($_POST['addProductCode']);
                if(empty($addProductCode))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>This is not a valid product code.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                $addProductId = getProductBaseIdByCode($addProductCode);
                
                if($addProductId > 0 && isValidProductId($addProductId))
                {
                    $basket = $_SESSION['basket'];
                    
                    $basket->addItem(1, $addProductCode);
                    
                    $_SESSION['basket'] = $basket;
                    
                    
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>Your basket has been updated.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Sorry, that code was not found.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, an error occured.</p>");
                $messages->insertLast($alert);
                
            break;
        case "addBasketItem":
            
                $addProductId = cleanQuery($_POST['addBasketItem']);
                $prodToAdd = getProductBaseById($addProductId);
                if($prodToAdd->getId() > 0)
                {
                    $basket = $_SESSION['basket'];
                    
                    if(isset($_POST['totalBasketItemCount']))
                    {
                        $totalProductCount = cleanQuery($_POST['totalBasketItemCount']);
                        if($basket->itemExists($prodToAdd->getProductCode()))
                        {
                            $basket->setItemQty($prodToAdd->getProductCode(), $totalProductCount);
                        }
                        else
                        {
                            $basket->addItem($totalProductCount, $prodToAdd->getProductCode());
                        }
                    }
                    else
                    {
                        $basket->addItem(1, $prodToAdd->getProductCode());
                    }
                    
                    $_SESSION['basket'] = $basket;
                    
                    
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>Your basket has been updated.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, an error occured.</p>");
                $messages->insertLast($alert);
                
            break;
        case "addBasketItems":
            
                $addProductIds = cleanQueryArray($_POST['addBasketItems']);
                $addBasketItemCounts = cleanQueryArray($_POST['addBasketItemCount']);
                
                if(count($addProductIds) == count($addBasketItemCounts) && Count($addProductIds) > 0)
                {
                    $basket = $_SESSION['basket'];
                    
                    for($i=0; $i<count($addProductIds); $i++)
                    {
                        $addProd = getProductBaseById($addProductIds[$i]);
                        if($addProd->getId() > 0 && $addBasketItemCounts[$i] > 0)
                        {
                            $basket->addItem($addBasketItemCounts[$i], $addProd->getProductCode());
                        }
                    }   
                    
                    $_SESSION['basket'] = $basket;
                    
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>Your basket has been updated.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, an error occured.</p>");
                $messages->insertLast($alert);
                
            break;
        
        case "removeBasketItem":
            
                $removeProductId = cleanQuery($_POST['removeBasketItem']);
                $basket = $_SESSION['basket'];
                $removeProd = getProductBaseById($removeProductId);
                $basket->removeItem($removeProd->getProductCode());
                $_SESSION['basket'] = $basket;
            
            break;
        case "changeRequestState":
                if(isset($_POST['requestId']) && isset($_POST['targetRequestState']))
                {
                    $requestId = cleanQuery($_POST['requestId']); 
                    $targetRequestState = cleanQuery($_POST['targetRequestState']); 
                    
                    if(updateRequestState($targetRequestState,$requestId))
                    {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Request have been successfully updated.</p>");
                            $messages->insertLast($alert);
                    }
                    else
                    {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>Request have not been successfully updated.</p>");
                            $messages->insertLast($alert);
                    }
                }
            break;
        case "editRequests":
            
            
                if(isset($_POST['requestId']) && isset($_POST['requestStatus']))
                {
                    $requestIds = cleanQueryArray($_POST['requestId']); 
                    $requestStatus = cleanQueryArray($_POST['requestStatus']); 

                    if(count($requestIds) == count($requestStatus) && Count($requestIds) > 0)
                    {
                        $updateCount = 0;
                        for($i=0; $i<count($requestIds); $i++)
                        {
                            if(updateRequestState($requestStatus[$i],$requestIds[$i]))
                            {
                                $updateCount++;
                            }
                        }   
                        
                        if($updateCount == count($requestIds))
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>Requests have been successfully updated.</p>");
                                $messages->insertLast($alert);
                        }
                        else
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>Requests have not been successfully updated.</p>");
                                $messages->insertLast($alert);
                        }
                        break;
                    }                    
                
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Sorry, processing error.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, something went wrong.</p>");
                $messages->insertLast($alert);
                     
                
            break;
            /*
        case "editCategory":
            $addCatchSpecId = cleanQuery($_POST['addCatchSpecId']);
            $addCatchInstanceId = cleanQuery($_POST['addCatchSpecInstanceId']);
            $performActionId = cleanQueryArray($_POST['performActionId']);
            $productsSelected = cleanQueryArray($_POST['productSelected']);
                    
            if(count($productsSelected) > 0)
            {
                if($performActionId == 1)
                {
                    if($addCatchSpecId > 0 && $addCatchInstanceId > 0)
                    {
                        //assign catch
                        $addCount = 0;
                        foreach( $productsSelected as $i => $productId)
                        {
                            if(addProductSpecMapping(0,$productId,$addCatchSpecId,$addCatchInstanceId))
                            {
                                $addCount = $addCount + 1;
                            }
                        }
                        if($addCount > 0)
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>Catch has been sucessfully added to ".$addCount." products.</p>");
                                $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>Sorry, no catches were assigned.</p>");
                            $messages->insertLast($alert);                            
                        }
                        break;
                    }
                }
                else if($performActionId == 2)
                {
                    //clear catches
                    $clearCount = 0;
                    foreach( $productsSelected as $i => $productId)
                    {
                        if(clearAllProductSpecMapping(0,$productId))
                        {
                            $clearCount = $clearCount + 1;
                        }
                    }
                    if($clearCount > 0)
                    {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Catch has been sucessfully removed from ".$clearCount." products.</p>");
                            $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Sorry, no catches were cleared.</p>");
                        $messages->insertLast($alert);                            
                    }
                    break;
                }
                else if($performActionId == 3)
                {
                    //delete products
                    $deleteCount = 0;
                    foreach( $productsSelected as $i => $productId)
                    {
                        if(deleteProductBase($productId))
                        {
                            $deleteCount = $deleteCount + 1;
                        }
                    }
                    if($deleteCount > 0)
                    {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>".$deleteCount." products sucessfully deleted.</p>");
                            $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Sorry, no products were deleted.</p>");
                        $messages->insertLast($alert);                            
                    }
                    break;
                }
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, Something went wrong.</p>");
                $messages->insertLast($alert);
            }
            $alert = new Div();
            $alert->setClasses("alert alert-error");
            $alert->setContent("<p>Oops, no product Selected.</p>");
            $messages->insertLast($alert);
            break;
        case "editCategories":
            
            $delCatId = cleanQuery($_POST['delCatId']);
            $addCatName = cleanQuery($_POST['newCatName']);
            $addCatShortname = cleanQuery($_POST['newCatShortName']);
            
            
            if($delCatId > 0)
            {
                //delete cat
                if(removeCategoryById($delCatId))
                {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Category has been successfully deleted.</p>");
                        $messages->insertLast($alert);
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Category failed to delete.</p>");
                    $messages->insertLast($alert);
                }
            }
            
            if(strlen($addCatName) > 0 && strlen($addCatShortname) > 0 )
            {
                if(getCatIdByName($addCatName) > 0)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Category name is already in use.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                if(getCatIdByShortname($addCatShortname) > 0)
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Category shortname is already in use.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                if(createCategory($addCatName, $addCatShortname))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>Category has been successfully created.</p>");
                    $messages->insertLast($alert);
                }
            }
            break;
            
        case "editSpecs":
            
            $delSpecId = cleanQuery($_POST['delFilterSpecId']);
            
            $delSpecValId = cleanQuery($_POST['delCatchSpecId']);
            
            $catchSpecId = cleanQuery($_POST['newCatchSpecId']);
            $catchVal = cleanQuery($_POST['newCatchValLower']);
            $catchValUpper = cleanQuery($_POST['newCatchValUpper']);
            
            $filterName = cleanQuery($_POST['newFilterName']);
            $filterValType = cleanQuery($_POST['newFilterValType']);
            $filterDim = cleanQuery($_POST['newFilterDim']);
            
            
            if($delSpecId > 0)
            {
                //delete filter
                $result = deleteProductSpec(0, $delSpecId);
                if($result)
                {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Filter has been successfully deleted.</p>");
                        $messages->insertLast($alert);
                }
            }
            if($delSpecValId > 0)
            {
                //delete catch
                $result = deleteProductSpecInstance(0, $delSpecValId);
                if($result)
                {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Catch has been successfully deleted.</p>");
                        $messages->insertLast($alert);
                }
            }
            if($catchSpecId > 0 && strlen($catchVal) > 0)
            {
                //create new catch
                if(!isset($catchValUpper) || empty($catchValUpper)){$catchValUpper = "";}
                $result = addProductSpecInstance(0,$catchSpecId,$catchVal, $catchValUpper);
                if($result)
                {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Catch has been sucessfully created.</p>");
                        $messages->insertLast($alert);
                }
            }
            
            if(strlen($filterName) > 0)
            {
                //create new filter
            

                $result = addProductSpec(0, $filterName, $filterValType, $filterDim);
                if($result)
                {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Filter has been successfully created.</p>");
                        $messages->insertLast($alert);
                }
            }
            
            break;
*/
        case "deleteproductbase":
            
            $baseid = cleanQuery($_POST['deletebase']);
            
            $result = deleteProductBase($baseid);
            if($result)
            {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>product has been successfully deleted.</p>");
                    $messages->insertLast($alert);
            }
            
            break;
            /*
	case "addproductbase":

            $cat = cleanQuery($_POST['catid']);
            $productid = cleanQuery($_POST['productid']);
            $name = cleanQuery($_POST['productName']);
            $productCode = cleanQuery($_POST['productCode']);
            $shortname = cleanQuery($_POST['productShortname']);
            $desc = cleanQuery($_POST['productDesc']);
            $details = cleanQuery($_POST['productDetails']);
            
            //EDIT#201309291331:img updates are currently disabled
            $searchImgId = 0;//cleanQuery($_POST['searchImgId']);
            $spotlightImgId = 0;//cleanQuery($_POST['spotlightImgId']);
            $basketImgId = 0;//cleanQuery($_POST['basketImgId']);
            
            $availability = cleanQuery($_POST['availability']);
            
            $listPrice = cleanQuery($_POST['listprice']);
            $discount = cleanQuery($_POST['discount']);
            
            
            $docAddId = cleanQuery($_POST['docAddId']);
            
            $browseItemCatNew = cleanQuery($_POST['browseItemCat_new']);
            $componentIdNew = cleanQuery($_POST['componentId_new']);
            if(isset($_POST['isCheckoutItem']) && strcmp($_POST['isCheckoutItem'],"on") == 0){
                $isCheckoutItem = "1";
            }else{
                $isCheckoutItem = "0";
            }    

            //check shortname is unique
            if(empty($shortname) || doesBaseShortnameExists($shortname,$productid))
            {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product was not created/updated, meta name is not unique.</p>");
                    $messages->insertLast($alert);
                    break;
            }
            //check productCode is unique
            if(empty($productCode) || doesBaseCodeExists($productCode,$productid))
            {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product was not created/updated, product code is not unique.</p>");
                    $messages->insertLast($alert);
                    break;
            }
            
            if(!isset($listPrice)  || $listPrice<0 || validateDecimal($listPrice)===false)
            {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product list price must be a positive number.</p>");
                    $messages->insertLast($alert);
                    break;
            }
            if(!isset($discount) || $discount<0 ||  $discount>100 || validateDecimal($discount)===false)
            {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product discount must be a positive number between 0.00 to 100.00</p>");
                    $messages->insertLast($alert);
                    break;
            }

            
            if($productid > 0)
            {
                $result = updateProductBase(0, $cat, $productid, $name, $shortname, $desc, $details,$searchImgId,$spotlightImgId,$basketImgId,$availability,$isCheckoutItem,$productCode,$listPrice,$discount);
                
                //handle components update
                
                if(isset($_POST['addComponentItems']) && !empty($_POST['addComponentItems']) && isset($_POST['addComponentItemCount']) && !empty($_POST['addComponentItemCount']))
                {
                    $addComponentItemsIds = cleanQueryArray($_POST['addComponentItems']);
                    $addComponentItemCounts = cleanQueryArray($_POST['addComponentItemCount']);
                    if(count($addComponentItemsIds) == count($addComponentItemCounts) && Count($addComponentItemsIds) > 0)
                    {
                        $updateCount = 0;
                        for($i=0; $i<count($addComponentItemsIds); $i++)
                        {
                            if(updateComponentMapping($productid, $addComponentItemsIds[$i], $addComponentItemCounts[$i]))
                            {
                                $updateCount++;
                            }
                        }   
                        
                        if($updateCount > 0)
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>$updateCount components were successfully updated.</p>");
                            $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>No components were successfully updated.</p>");
                            $messages->insertLast($alert);
                        }
                    }
                }
                
                if(isset($_POST['removeComponentItems']) && !empty($_POST['removeComponentItems']))
                {
                    $removeComponentItems = cleanQueryArray($_POST['removeComponentItems']);
                    $removecount = 0;
                    foreach( $removeComponentItems as $i => $componentItemId){

                        if(removeComponentItem($productid,$componentItemId))
                        {
                            $removecount = $removecount + 1;                                            
                        }
                    }

                    if($removecount > 0)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>$removecount components were successfully removed.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>No Components were successfully removed.</p>");
                        $messages->insertLast($alert);
                    }

                }
                
                if(isset($componentIdNew) && $componentIdNew > 0)
                {
                    if(updateComponentMapping($productid, $componentIdNew, 0))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Component successfully added.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Component was not successfully added.</p>");
                        $messages->insertLast($alert);
                    }
                }
                //handle browse items update
                
                if(isset($browseItemCatNew) && $browseItemCatNew > 0)
                {
                    if(addBrowseItem($browseItemCatNew, $productid))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Browse item successfully added.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Browse item was not successfully added.</p>");
                        $messages->insertLast($alert);
                    }
                }
                if(isset($_POST['browseItemId']) && !empty($_POST['browseItemId']) && isset($_POST['browseItemCat']) && !empty($_POST['browseItemCat']))
                {
                    $browseItemIds = cleanQueryArray($_POST['browseItemId']);
                    $browseItemCats = cleanQueryArray($_POST['browseItemCat']);
                    if(count($browseItemIds) == count($browseItemCats) && Count($browseItemCats) > 0)
                    {
                        $updateCount = 0;
                        for($i=0; $i<count($browseItemIds); $i++)
                        {
                            if(updateBrowseItemCat($browseItemIds[$i],$browseItemCats[$i]))
                            {
                                $updateCount++;
                            }
                        }   
                        
                        if($updateCount > 0)
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>$updateCount browse items were successfully updated.</p>");
                            $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>No browse items were successfully updated.</p>");
                            $messages->insertLast($alert);
                        }
                    }
                }
                if(isset($_POST['removeBrowseItem']) && !empty($_POST['removeBrowseItem']))
                {
                    $removeBrowseItems = cleanQueryArray($_POST['removeBrowseItem']);
                    $removecount = 0;
                    foreach( $removeBrowseItems as $i => $browseItemId){

                        if(removeBrowseItemById($browseItemId))
                        {
                            $removecount = $removecount + 1;                                            
                        }
                    }

                    if($removecount > 0)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>$removecount browse items were successfully removed.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>No browse items were successfully removed.</p>");
                        $messages->insertLast($alert);
                    }

                }
                
                if(isset($_POST['removeDoc']) && !empty($_POST['removeDoc']))
                {
                    $removeDocs = cleanQueryArray($_POST['removeDoc']);
                    $removecount = 0;
                    foreach( $removeDocs as $i => $docid){

                        if(removeDocumentationById(0, $docid))
                        {
                            $removecount = $removecount + 1;                                            
                        }
                    }

                    if($removecount > 0)
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>$removecount docs were successfully removed.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>No docs were successfully removed.</p>");
                        $messages->insertLast($alert);
                    }

                }
                
                if(isset($docAddId) && $docAddId > 0)
                {
                    if(addDocumentation(0,$productid,$docAddId))
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>document was successfully added.</p>");
                        $messages->insertLast($alert);
                    }
                    else
                    {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>No docs were successfully added.</p>");
                        $messages->insertLast($alert);
                    }
                }

                
            }
            else
            {
                $result = addProductBase(0, $cat, $name, $shortname, $desc, $details,$searchImgId,$spotlightImgId,$basketImgId,$availability,$productCode,$listPrice,$discount);
                
                if($result && isset($docAddId) && $docAddId > 0)
                {
                    $productid = getProductIdByShortname($shortname);
                    if($productid > 0)
                    {
                        if(addDocumentation(0,$productid,$docAddId))
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>document was successfully added.</p>");
                            $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>No docs were successfully added.</p>");
                            $messages->insertLast($alert);
                        }
                    }
                }
            }
            if($result)
            {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    if($productid > 0)
                    {
                        $alert->setContent("<p>$name has been successfully updated.</p>");
                    }
                    else
                    {
                        $alert->setContent("<p>$name has been successfully added.</p>");
                    }
                    
                    $messages->insertLast($alert);
            }


            break;
             */
        case "editproductdescription":
                $productid = cleanQuery($_POST['productId']);
                $productDescription = cleanQuery($_POST['productDescriptionTextArea']);
                
                if(updateProductDescription($productid, $productDescription))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>product description updated.</p>");
                    $messages->insertLast($alert);
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product description failed to update.</p>");
                    $messages->insertLast($alert);
                }
            break;
        case "editproductdetails":
                $productid = cleanQuery($_POST['productId']);
                $productDetails = cleanQuery($_POST['productDetailsTextArea']);
                
                if(updateProductDetails($productid, $productDetails))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>product details updated.</p>");
                    $messages->insertLast($alert);
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product details failed to update.</p>");
                    $messages->insertLast($alert);
                }
            break;
        case "editproductspecifications":
                $productid = cleanQuery($_POST['productId']);
                $productSpecifications = cleanQuery($_POST['productSpecificationsTextArea']);
                
                if(updateProductSpecifications($productid, $productSpecifications))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>product specifications updated.</p>");
                    $messages->insertLast($alert);
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product specifications failed to update.</p>");
                    $messages->insertLast($alert);
                }
            break;
        case "editproductavailability":
                $productid = cleanQuery($_POST['productId']);
                $productAvailability = cleanQuery($_POST['productAvailabilityText']);
                if(updateProductAvailability($productid, $productAvailability))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>product availability updated.</p>");
                    $messages->insertLast($alert);
                }
                else
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>product availability failed to update.</p>");
                    $messages->insertLast($alert);
                }
            break;
            
	case "userlogin":

            $email = "";
            if(validateEmail($_POST['email']))
            {
                $email = cleanQuery($_POST['email']);
            }
            $password = cleanQuery($_POST['password']);
            
            $hash = hash('sha256', $password);

            $thisUserId = getUserId($email, $hash);

            if($thisUserId == 0)		  
            {
                logEntry(StateMgr::logDebug, "failed user login using $email");
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Invalid email or password.</p>");
                $messages->insertLast($alert);
                
                break;
            }
            
            /*
            create/resume session
            */
            //my_session_restart();

            $_SESSION['userid'] = $thisUserId;

            logEntry(StateMgr::logDebug, "user login success using $email");
            $user_id = $thisUserId;
            
            //session_write_close();
            //header("Location: ./Welcome");
            //exit();

            break;
	
        case "regenNotifyPass":
            
            $email = "";
            if(validateEmail($_POST['loginEmail']))
            {
                $email = cleanQuery($_POST['loginEmail']);
            }
            
            //does user exist?
            $userId = getUserIdByEmail($email);
            
            if($userId > 0)
            {
                
                if(updateUserState(StateMgr::userApproved,$userId) && reGenPasswordAndNotifyUser($userId))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>Account $email has been approved, instructions have been sent to $email on how to login.</p>");
                    $messages->insertLast($alert);
                }
                else
                {

                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>An error occured, please retry later.</p>");
                    $messages->insertLast($alert);
                }
            }
            else
            {
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Invalid email address $email</p>");
                $messages->insertLast($alert);
            }
            
            break;
        case "forgotLogin":
            
            $email = "";
            if(validateEmail($_POST['forgotLoginEmail']))
            {
                $email = cleanQuery($_POST['forgotLoginEmail']);
            }
            
            //does user exist?
            $forgottenUserId = getUserIdByEmail($email);
            
            if($forgottenUserId > 0)
            {
                if(reGenPasswordAndNotifyUser($forgottenUserId))
                {
                    $alert = new Div();
                    $alert->setClasses("alert alert-success");
                    $alert->setContent("<p>We've sent instructions on how to proceed to your email address.</p>
                        <p>If you don't receive instructions within a minute or two, check your email's spam and junk filters, or try <a href=\"./SignIn\">resending your request</a>.</p>");
                    $messages->insertLast($alert);
                }
                else
                {

                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>An error occured, please retry later.</p>");
                    $messages->insertLast($alert);
                }
                

            }
            else
            {
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Invalid email address ".$email."</p>");
                $messages->insertLast($alert);
            }
            
            break;
            
            /*
             case "generatesitemap":
                 
                 if($user_id == 1)
                 {
                     
                     if(generateSitemapXML())
                     {
                        $alert = new Div();
                        $alert->setClasses("alert alert-success");
                        $alert->setContent("<p>Sitemap successfully generated.</p>");
                        $messages->insertLast($alert);
                     }
                     else
                     {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Sitemap was not generated.</p>");
                        $messages->insertLast($alert);
                     }
                 }
                 else
                 {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Invalid privileges.</p>");
                        $messages->insertLast($alert);
                 }
                 
                 
        break;
        case "autobackup":
            
                 if($user_id == 1)
                 {
                     
                    if(isset($_POST['backupdb']))
                    {
                        if(backupDb())
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Database backup successfully created.</p>");
                            $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>Database backup was not created.</p>");
                            $messages->insertLast($alert);
                        }
                    }
                    if(isset($_POST['backupimages']))
                    {
                        if(backupImages())
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Images backup successfully created.</p>");
                            $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>Images backup was not created.</p>");
                            $messages->insertLast($alert);
                        }
                    }
                    if(isset($_POST['backupfiles']))
                    {
                        if(backupFiles())
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-success");
                            $alert->setContent("<p>Files backup successfully created.</p>");
                            $messages->insertLast($alert);
                        }
                        else
                        {
                            $alert = new Div();
                            $alert->setClasses("alert alert-error");
                            $alert->setContent("<p>Files backup was not created.</p>");
                            $messages->insertLast($alert);
                        }
                    }
                 }
                 else
                 {
                        $alert = new Div();
                        $alert->setClasses("alert alert-error");
                        $alert->setContent("<p>Invalid privileges.</p>");
                        $messages->insertLast($alert);
                 }
            
        break;
          */   

        case "editUsers":
            
                if(isset($_POST['userId']) &&  
                        isset($_POST['vatRates']) && 
                        isset($_POST['discountRates']))
                {
                    $userIds = cleanQueryArray($_POST['userId']); 
                    $vatRates = cleanQueryArray($_POST['vatRates']); 
                    $discountRates = cleanQueryArray($_POST['discountRates']); 

                    if(isset($_POST['deleteUser']) && count($_POST['deleteUser'])>0)
                    {
                        $delCount = 0;
                        $delUserIds = cleanQueryArray($_POST['deleteUser']); 
                        foreach( $delUserIds as $i => $userid){
                            if(!in_array($userid, KeyRing::$admins)){
                                if(removeUser($userid))
                                {
                                    $delCount++; 
                                }
                            }
                            
                        }
                        
                        if($delCount>0)
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>$delCount Users have been successfully removed.</p>");
                                $messages->insertLast($alert);
                        }
                        else
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>No users have been removed.</p>");
                                $messages->insertLast($alert);
                        }
                    }
                    if(count($userIds) == count($vatRates) && 
                            count($vatRates) == count($discountRates) && 
                            Count($userIds) > 0)
                    {
                        $updateCount = 0;
                        for($i=0; $i<count($userIds); $i++)
                        {
                            if($vatRates[$i]<0 || $vatRates[$i]>100 || validateDecimal($vatRates[$i])===false)
                            {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>VAT must be a positive number between 0.00 and 100.00</p>");
                                    $messages->insertLast($alert);
                                    break;
                            }
                            if($discountRates[$i]<0 || $discountRates[$i]>100 || validateDecimal($discountRates[$i])===false)
                            {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>Discount must be a positive number between 0.00 and 100.00</p>");
                                    $messages->insertLast($alert);
                                    break;
                            }
                            
                            if(updateUserVAT($vatRates[$i],$userIds[$i]) &&
                               updateUserDiscount($discountRates[$i],$userIds[$i]))
                            {
                                $updateCount++;
                            }
                        }   
                        
                        if($updateCount == count($userIds))
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>Users have been successfully updated.</p>");
                                $messages->insertLast($alert);
                        }
                        else
                        {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>Users have not been successfully updated.</p>");
                                $messages->insertLast($alert);
                        }
                        break;
                    }                    
                
                    $alert = new Div();
                    $alert->setClasses("alert alert-error");
                    $alert->setContent("<p>Sorry, processing error.</p>");
                    $messages->insertLast($alert);
                    break;
                }
                
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, something went wrong.</p>");
                $messages->insertLast($alert);
                     
                
                            
            
            break;
/*

		case "editImages":
                    
                    
                        $performActionId = cleanQuery($_POST['performActionId']);

                        if($performActionId == 1)
                        {
                            //add new image
                            
                            $addimagecount = 0;
                            if(!empty($_FILES['fileupload']))
                            {
				
                                $folder = cleanQuery($_POST['folder']);
				$uploaddir = "./images/orig/$folder/";

                                $uploadSuccess = false;	
                                $targetfilename = $_FILES["fileupload"]["name"];
                                //unique name
                                if(doesImageNameExist($targetfilename) > 0)
                                {      
                                        $alert = new Div();
                                        $alert->setClasses("alert alert-error");
                                        $alert->setContent("<p>'$targetfilename' is not a unique name.</p>");
                                        $messages->insertLast($alert);
                                }
                                elseif ($_FILES["fileupload"]["size"] < 200000000)//200MB limit
                                {
                                        if ($_FILES["fileupload"]["error"] > 0)
                                        {                                                        
                                                $alert = new Div();
                                                $alert->setClasses("alert alert-error");
                                                $alert->setContent("<p>Return Code: " . $_FILES["fileupload"]["error"]."</p>");
                                                $messages->insertLast($alert);
                                        }
                                        else
                                        {
                                                if (file_exists($uploaddir . $_FILES["fileupload"]["name"]))
                                                {
                                                    $alert = new Div();
                                                    $alert->setClasses("alert alert-error");
                                                    $alert->setContent("<p>".$_FILES["fileupload"]["name"] . " already exists... </p>");
                                                    $messages->insertLast($alert);
                                                }
                                                else
                                                {
                                                        if(move_uploaded_file($_FILES["fileupload"]["tmp_name"],$uploaddir . $_FILES["fileupload"]["name"]))
                                                        {
                                                            $uploadSuccess = true;
                                                            chmod($uploaddir . $_FILES["fileupload"]["name"], 0644);
                                                        }

                                                }
                                        }
                                }
                                else
                                {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>File is too big(".$_FILES["fileupload"]["size"]."), 200MB limit!</p>");
                                    $messages->insertLast($alert);
                                }

                                if($uploadSuccess)
                                {
                                    //create image entry
                                    $origImage = new SimpleImage();
                                    $origImage->load($uploaddir . $targetfilename);

                                    if(addImage(0, $uploaddir.$targetfilename, "", $origImage->getWidth(), $origImage->getHeight()))
                                    {
                                        $alert = new Div();
                                        $alert->setClasses("alert alert-success");
                                        $alert->setContent("<p>Image was added.</p>");
                                        $messages->insertLast($alert);
                                        
                                        
                                        //and the other sizes (including aspect ratio)
                                        if(createImageSet($targetfilename, $uploaddir, $folder))
                                        {
                                            $alert = new Div();
                                            $alert->setClasses("alert alert-success");
                                            $alert->setContent("<p>Image copies have been created for a range of sizes.</p>");
                                            $messages->insertLast($alert); 
                                        }
                                        
                                        
                                        break;
                                    }

                                }
                                else
                                {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>Sorry, no images were added.</p>");
                                    $messages->insertLast($alert);
                                    break;
                                }

                            }
                            else
                            {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>No image found.</p>");
                                $messages->insertLast($alert);
                                break;
                            }
                            break;
                        }
                        else if($performActionId == 2)
                        {
                        }
                        else if($performActionId == 3)
                        {
                            //delete sets selected
                            $imgSelected = cleanQueryArray($_POST['resultSelect']);
                            
                            if(count($imgSelected) > 0)
                            {
                                //delete img set per img selected
                                
				$deleteCount = 0;
				foreach( $imgSelected as $i => $imgid){
                                    $imageSet = getImageSetByImgId($imgid);
                                    $deleteFailed = false;
                                    for($j=1; $j <= $imageSet->totalNodes(); $j++)    
                                    {
                                        $nxtImg = $imageSet->readNode($j);
                                        //delete from filesystem
                                        if(unlink($nxtImg->getSrc()))
                                        {
                                            //delete from db
                                            if(!removeImageById(0,$nxtImg->getId()))
                                            {
                                                $deleteFailed = true;
                                            }
                                        }
                                        else
                                        {
                                            $deleteFailed = true;
                                        }
                                    }  
                                    if(!$deleteFailed)
                                    {
                                        $deleteCount++;
                                    }
				}
                                
                                if($deleteCount > 0)
                                {
                                        $alert = new Div();
                                        $alert->setClasses("alert alert-success");
                                        $alert->setContent("<p>".$deleteCount." images sucessfully deleted.</p>");
                                        $messages->insertLast($alert);
                                }
                                else
                                {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>Sorry, no images were deleted.</p>");
                                    $messages->insertLast($alert);                            
                                }
                                break;
                            }   
                        }
                    break;
		case "editFiles":
                    
                    
                        $performActionId = cleanQuery($_POST['performActionId']);

                        if($performActionId == 1)
                        {
                            $fileSelected = cleanQueryArray($_POST['fileSelected']);

                            if(count($fileSelected) > 0)
                            {
                                //delete
                                
				$deleteCount = 0;
				foreach( $fileSelected as $i => $targetid){

                                    $target = getTargetById($targetid);
                                    if($target->getId() > 0)
                                    {
                                        if(unlink($target->getTarget()))
                                        {
                                            if(removeTargetById($user_id, $target->getId()))
                                            {
						$deleteCount = $deleteCount + 1;
                                            }
                                        }
                                    }
				}
                                
                                if($deleteCount > 0)
                                {
                                        $alert = new Div();
                                        $alert->setClasses("alert alert-success");
                                        $alert->setContent("<p>".$deleteCount." files sucessfully deleted.</p>");
                                        $messages->insertLast($alert);
                                }
                                else
                                {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>Sorry, no products were deleted.</p>");
                                    $messages->insertLast($alert);                            
                                }
                                break;
                            }
                        }
                        elseif($performActionId == 2)
                        {
                            $addfilecount = 0;
                            if(!empty($_FILES['fileupload']))
                            {
				
                                $folder = cleanQuery($_POST['folder']);
				$uploaddir = "./pdfs/$folder/";

				foreach( $_FILES['fileupload']['name'] as $i => $targetfilename){

		
					$uploadSuccess = false;			

			
					if ($_FILES["fileupload"]["size"][$i] < 200000000)//200MB limit
					{
						if ($_FILES["fileupload"]["error"][$i] > 0)
						{                                                        
                                                        $alert = new Div();
                                                        $alert->setClasses("alert alert-error");
                                                        $alert->setContent("<p>Return Code: " . $_FILES["fileupload"]["error"][$i]."</p>");
                                                        $messages->insertLast($alert);
						}
						else
						{
							if (file_exists($uploaddir . $_FILES["fileupload"]["name"][$i]))
							{
                                                            $alert = new Div();
                                                            $alert->setClasses("alert alert-error");
                                                            $alert->setContent("<p>".$_FILES["fileupload"]["name"][$i] . " already exists... </p>");
                                                            $messages->insertLast($alert);
							}
							else
							{
								if(move_uploaded_file($_FILES["fileupload"]["tmp_name"][$i],$uploaddir . $_FILES["fileupload"]["name"][$i]))
                                                                {
                                                                    $uploadSuccess = true;
                                                                    chmod($uploaddir . $_FILES["fileupload"]["name"][$i], 0644);
                                                                }
								
							}
						}
					}
					else
					{
                                            $alert = new Div();
                                            $alert->setClasses("alert alert-error");
                                            $alert->setContent("<p>File is too big, 200MB limit!</p>");
                                            $messages->insertLast($alert);
					}

					if($uploadSuccess)
					{
                                            $targetType = cleanQuery($_POST['docTypeId']);
                                            if(isset($targetType))
                                            {
                                                if(addTarget($user_id, $uploaddir.$targetfilename, $targetType))
                                                {
                                                    $addfilecount = $addfilecount + 1;
                                                }   
                                            }
					}

				}
                                if($addfilecount > 0)
                                {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-success");
                                    $alert->setContent("<p>The $addfilecount targets were successfully added.</p>");
                                    $messages->insertLast($alert);
                                    break;
                                }
                                else
                                {
                                    $alert = new Div();
                                    $alert->setClasses("alert alert-error");
                                    $alert->setContent("<p>Sorry, no files were added.</p>");
                                    $messages->insertLast($alert);
                                    break;
                                }

                            }
                            else
                            {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>No files found.</p>");
                                $messages->insertLast($alert);
                                break;
                            }
                            break;
                        }


		break;
                
		case "editImages":

		
			if(isset($_POST['deleteimage']) && !empty($_POST['deleteimage']))
			{
			
				$deleteimage = $_POST['deleteimage'];

				$deleteimagecount = 0;
				foreach( $deleteimage as $i => $imageid){

					if(removeImageById($imageid))
                                        {
						$deleteimagecount = $deleteimagecount + 1;                                            
                                        }
				}
                                
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>$deleteimagecount images were successfully deleted.</p>");
                                $messages->insertLast($alert);


			}

			$addimagecount = 0;
			if(!empty($_FILES['imageupload']))
			{
				
				$uploaddir = "./images/";

				foreach( $_FILES['imageupload']['name'] as $i => $targetimagename)
                                {

		
					$uploadSuccess = false;			

			
					if ($_FILES["imageupload"]["size"][$i] < 200000000)//200MB limit
					{
						if ($_FILES["imageupload"]["error"][$i] > 0)
						{
                                                    $alert = new Div();
                                                    $alert->setClasses("alert alert-error");
                                                    $alert->setContent("<p>Return Code: " . $_FILES["imageupload"]["error"][$i] . "</p>");
                                                    $messages->insertLast($alert);
						}
						else
						{
							if (file_exists($uploaddir . $_FILES["imageupload"]["name"][$i]))
							{
                                                                $alert = new Div();
                                                                $alert->setClasses("alert alert-error");
                                                                $alert->setContent("<p>".$_FILES["imageupload"]["name"][$i] . " already exists.</p>");
                                                                $messages->insertLast($alert);
							}
							else
							{
								move_uploaded_file($_FILES["imageupload"]["tmp_name"][$i],$uploaddir . $_FILES["imageupload"]["name"][$i]);
								
								$uploadSuccess = true;
							}
							chmod($uploaddir . $_FILES["imageupload"]["name"][$i], 0644);
						}
					}
					else
					{
                                            $alert = new Div();
                                            $alert->setClasses("alert alert-error");
                                            $alert->setContent("<p>File is too big!</p>");
                                            $messages->insertLast($alert);
					}

					if($uploadSuccess)
					{
                                            $imageToAdd = new SimpleImage();
                                            $imageToAdd->load($uploaddir.$targetimagename);

                                            if(addImage(0, $uploaddir.$targetimagename, "", $imageToAdd->getWidth(), $imageToAdd->getHeight()))
                                            {
                                                logEntry(StateMgr::logDebug, "image uploaded, name = $targetimagename");
                                                $addimagecount = $addimagecount + 1;
                                            }
					}

				}
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>The $addimagecount images were successfully added.</p>");
                                $messages->insertLast($alert);


			}


		break;
*/
		
}


return $messages;

}

function processGetAction()
{


    $messages = new LinkList();

    switch ($_GET['preprocess'])
    {
        
    }
    
    return $messages;
}
function processGet()
{

$messages = new LinkList();
    
switch ($_GET['preprocess'])
{
        case "requestretract":
            //DEPRECATED - no longer supported
                if((!isset($_SESSION['userid'])) || ($_SESSION['userid'] <= 0))
                {
                    header("Location: ".KeyRing::baseHref."Register?returnUrl=Account?info=requests");
                    exit();
                }
                else
                {
                    $userId = validateUser();
                    if ($userId > 0){
                        if(isset($_GET['requestid']))
                        {
                            $requestid = cleanQuery($_GET['requestid']);
                            $retractResult = retractRequest($requestid, $userId);
                            if($retractResult){
                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>Your request has been retracted.</p>");
                                $messages->insertLast($alert);

                                header("Location: ".KeyRing::baseHref."Account?info=requests");
                                exit();

                            }
                        }
                    }
                }
                $alert = new Div();
                $alert->setClasses("alert alert-error");
                $alert->setContent("<p>Sorry, an error occurred.</p>");
                $messages->insertLast($alert); 
                break;
            break;
        case "quoterequest":
            
                if((!isset($_SESSION['userid'])) || ($_SESSION['userid'] <= 0))
                {
                    header("Location: ".KeyRing::baseHref."SignIn?returnUrl=Basket");//TODO: FIX THIS
                    exit();
                }
                else
                {
                    if(isset($_SESSION['basket']))
                    {
                        $userId = validateUser();
                        if ($userId > 0){
                            //if basket not empty
                            if($_SESSION['basket']->getNbLineItems() <= 0)
                            {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>Sorry, you have no items in your basket.</p>");
                                $messages->insertLast($alert); 
                                break;
                            }
                            
                            //if limit not exceeded
                            if(getPendingRequestCount($userId) >= getMaxPendingRequestsPerUser())
                            {
                                $alert = new Div();
                                $alert->setClasses("alert alert-error");
                                $alert->setContent("<p>Sorry, you have too many pending requests. You can manage them in <a href=\"./Account?info=requests\">My Requests.</a></p>");
                                $messages->insertLast($alert); 
                                break;
                            }
                            
                            $requestResult = submitQuoteRequest($_SESSION['basket'], $userId);
                            if($requestResult){
                                $_SESSION['basket'] = new Basket();

                                $alert = new Div();
                                $alert->setClasses("alert alert-success");
                                $alert->setContent("<p>Thank you, your request has been submitted.</p>");
                                $messages->insertLast($alert);
                                
                                header("Location: ".KeyRing::baseHref."Account?info=requests");
                                exit();
                                
                            }
                        }
                    }
                }

            
            break;
            
	case "logout":
	
		if(isset($_SESSION['name'])&&isset($_SESSION['name']))
		{
			$user_name = $_SESSION['name'];
			$user_id = $_SESSION['userid'];
			
                        logEntry(StateMgr::logDebug, "logout $user_name");
		}


		logout();
                
                session_write_close();
                header("Location: ".KeyRing::baseHref."");
                exit();
                
	
	break;


}

return $messages;
}
?>
