<?php
function reGenPasswordAndNotifyUser($userId)
{
    $forgottenUser = getUserById($userId);
    //create random hash as temporary password
    $randomPass = generatePassword(8);
    $hash = hash('sha256', $randomPass);

    //update user
    if(updateUserPassword($userId, $hash))
    {
        $message = "\n Dear ".$forgottenUser->getTitle()." ".$forgottenUser->getLastname().
                "\n\n  Your new password is: ".$randomPass.
                "\n\n Please use this to login and change your password immediately.".
                "\n\n\n Kind Regards".
                "\n\n ADG Support";

        //send mail with this temporary password, asking to reset immediately
        sendMail($forgottenUser->getEmail(), "ADG password recovery", "noreply@adg.ie", $message);

        return true;
    }
    return false;
    
}
function generateMetaKeywords($pageName){
    $result = "";
    if(isset($pageName) && $pageName == "product")
    {
        //return metatags for that product
        if(isset($_GET['shortname'])){
            $shortname = cleanQuery($_GET['shortname']);  
            $product = getProductBaseByCode($shortname);
            $result = $product->getMetaTags();
        }
    }else
    {
        //list all categories
        $categories = getCategories();

        for($i=1; $i <= $categories->totalNodes(); $i++)    
        {
            $nextCat = $categories->readNode($i); 
            $result = $result." ".$nextCat->getName();
        }
    }
    return $result;
}
function generateShortnameForCategory($longname){
    //strip out all but alphanumeric values
    return preg_replace("/[^A-Za-z0-9]/", '', $longname);
}
function executeOSSUPDATEJob($userId,$job, &$errorStr)
{
    
}
function executeOSSDELETEJob($userId,$job, &$errorStr)
{
    $result = false;
    
    $productCode = $job[OSSKeyRing::header_code];
    $productBaseId = getProductBaseIdByCode($productCode);
    if($productBaseId<0)
    {
        $errorStr = "Failed to find product code [$productCode] to delete";
        return false;
    }
    if(deleteProductBase($productBaseId))
    {
        if(removeComponentMapping($productCode))
        {
            $errorStr = "Product was successfully deleted";
            $result = true;
        
        }else
        {
            $errorStr = "Failed to delete product mappings for [$productCode]";
            $result = false;
        }       
            
    }else
    {
        $errorStr = "Failed to delete product [$productCode]";
        $result = false;
    }          
    
    return $result;
}
function executeOSSCREATEJob($userId,$job, &$errorStr)
{
    $result = false;

    $catname = $job[OSSKeyRing::header_category];
    $catshortname = generateShortnameForCategory($catname);
    $cat = getCatIdByName($catname);
    if($cat<=0){
        //create category
        if(createCategory($catname, $catshortname)){
            $cat = getCatIdByName($catname);
            if($cat<=0){
                $errorStr = "failed to create category [$catname]";
                return false;
            }
        }

    }


    $name = $job[OSSKeyRing::header_name];
    $shortname = $job[OSSKeyRing::header_code];
    $desc = $job[OSSKeyRing::header_description];
    $details = $job[OSSKeyRing::header_details];
    $metatags = $job[OSSKeyRing::header_metatags];
    $searchImgId = 0; //soon to be deprecated
    $spotlightImgId = 0; //soon to be deprecated
    $basketImgId = 0; //soon to be deprecated
    $availability = $job[OSSKeyRing::header_availability];
    $productCode = $job[OSSKeyRing::header_code];
    $checkoutable = $job[OSSKeyRing::header_checkoutable];
    $listPrice = $job[OSSKeyRing::header_price];
    $discount = $job[OSSKeyRing::header_discount];
    $components = $job[OSSKeyRing::header_componentcodes];
    //product code must be unique
    if(getProductBaseIdByCode($productCode)>0){
        $errorStr = "Product code [$productCode] already exists";
        return false;
    }
    if(addProductBase($userId, $cat, $name, $shortname, $desc, $details, $searchImgId, $spotlightImgId, $basketImgId, $availability, $productCode, $listPrice, $discount,$checkoutable,$metatags))
    {
        $productBaseId = getProductBaseIdByCode($productCode);
        if($productBaseId > 0){
            
            //add component mappings
            if(isset($components))
            {

                $a = explode(';', $components);

                foreach ($a as $result) {
                    if(isset($result) && strlen($result)>0){
                        $b = explode(':', $result);
                        $componentsArr[$b[0]] = $b[1];
                    }
                }
                //$componentsArr = json_decode($components);
                if(isset($componentsArr)){
                    foreach ($componentsArr as $componentCode => $defaultQtyValue){
                        if(!updateComponentMapping($productCode,$componentCode,$defaultQtyValue)){
                            $errorStr = "Product was successfully created, but failed to assign component product [$componentCode]";
                            return false;
                        }
                    }
                }
            }
            //add product filters
            
            $result = true;
            foreach ($job as $key => $value){
                if (!in_array($key, OSSKeyRing::$createHeaders) && strlen($key) > 0 && strlen($value) > 0){
                    if(!addProductFilter($userId, $productCode, $key, $value)){
                        $errorStr = "Product was successfully created, but failed to assign product filter [$key][$value]";
                        return false;
                    }
                }
            }
        }
    }else
    {
        $errorStr = "Failed to create product [$productCode]";
    }
           
    
    return $result;
}

function csv_to_array($filename='', $delimiter=',')
{
	if(!file_exists($filename) || !is_readable($filename))
		return FALSE;
	
	$header = NULL;
	$data = array();
	if (($handle = fopen($filename, 'r')) !== FALSE)
	{
		while (($row = fgetcsv($handle, 1000, $delimiter)) !== FALSE)
		{
			if(!$header)
				$header = $row;
			else
				$data[] = array_combine($header, $row);
		}
		fclose($handle);
	}
	return $data;
}
function getBasket($refreshData=false)
{
    $basket = new Basket();
    
    do if(isset($_SESSION['basket']))
    {
        $basket = $_SESSION['basket'];
        
        if(!validateBasket($basket))
        {
            $basket = new Basket();
            break;
        }
        
        if($refreshData)
        {
            $basket->refreshBasketData();
        
            if(!validateBasket($basket))
            {
                $basket = new Basket();
                break;
            }
        }
    }while(false);
    
    $_SESSION['basket'] = $basket;
    
    return $basket;
}

function getIntersectionOfProductLists($listA, $listB)
{
    $result = new LinkList();
    
    if(isset($listA) && $listA->totalNodes() > 0)
    {
        if(isset($listB) && $listB->totalNodes() > 0)
        {
            for($i=1; $i <= $listA->totalNodes(); $i++)    
            {
                $nxtProduct = $listA->readNode($i);

                if(isProductInProductList($listB,$nxtProduct->getId()))
                {
                    $result->insertLast($nxtProduct);
                }
            }                
        }
    }
    
    return $result;    
}

function isProductInProductList($productList, $productId)
{
    if(isset($productId) && isset($productList) && $productList->totalNodes() > 0)
    {
        for($i=1; $i <= $productList->totalNodes(); $i++)    
        {
            $nxtProduct = $productList->readNode($i);
            
            if($nxtProduct->getId() === $productId)
            {
                return true;
            }
        }                
    }
    
    return false;
}


function getRealIpAddr()
{
    
    if (!empty($_SERVER['HTTP_CLIENT_IP']))   //check ip from share internet
    {
      $ip=$_SERVER['HTTP_CLIENT_IP'];
    }
    elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))   //to check ip is pass from proxy
    {
      $ip=$_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    else
    {
      $ip=$_SERVER['REMOTE_ADDR'];
    }
    return cleanQuery($ip);
}
function getProductReviewDiv($requestid)
{
    
                                            $nxtReviewReq = getRequest($requestid);
                                            $nxtReview = getReviewByReq($requestid);
?>
                                        <div class="row">
                                            <div class="span3">
<?php
                                                //product review score
                                                $qualityPerc = $nxtReview->getQualityScore() * 20;
                                                $valuePerc = $nxtReview->getValueScore() * 20;
                                                $performancePerc = $nxtReview->getPerformanceScore() * 20;
                                                $appearancePerc = $nxtReview->getAppearanceScore() * 20;
                                                $totalPerc = ($qualityPerc + $valuePerc + $performancePerc + $appearancePerc)/4;
                                                
                                                

?>
                                                <h5>Overall <?php echo $totalPerc?>%</h5>
                                                <div class="row">
                                                    <div class="span3">
                                                    </div>
                                                </div>
                                                
                                                <div class="row">
                                                    <div class="span1">
                                                        Quality 
                                                    </div>
                                                    <div class="span2">
<?php
                                                        echo $nxtReview->getQualityScore()."/5";

                                                        for($i=0; $i<$nxtReview->getQualityScore(); $i++)
                                                        {
?>
                                                        <span class="label label-important">
                                                            <i class="icon-star icon-white"></i>
                                                        </span>
<?php                                                                                                                
                                                        }
?>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="span1">
                                                        Value 
                                                    </div>
                                                    <div class="span2">
<?php
                                                        echo $nxtReview->getValueScore()."/5";

                                                        for($i=0; $i<$nxtReview->getValueScore(); $i++)
                                                        {
?>
                                                        <span class="label label-important">
                                                            <i class="icon-star icon-white"></i>
                                                        </span>
<?php                                                                                                               
                                                        }
?>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="span1">
                                                        Performance 
                                                    </div>
                                                    <div class="span2">
<?php
                                                        echo $nxtReview->getPerformanceScore()."/5";

                                                        for($i=0; $i<$nxtReview->getPerformanceScore(); $i++)
                                                        {
?>
                                                        <span class="label label-important">
                                                            <i class="icon-star icon-white"></i>
                                                        </span>
<?php                                                                                                                 
                                                        }
?>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div class="span1">
                                                        Appearance 
                                                    </div>
                                                    <div class="span2">
<?php
                                                        echo $nxtReview->getAppearanceScore()."/5";
                                                            
                                                        for($i=0; $i<$nxtReview->getAppearanceScore(); $i++)
                                                        {
?>
                                                        <span class="label label-important">
                                                            <i class="icon-star icon-white"></i>
                                                        </span>
<?php                                                                                                                 
                                                        }
?>
                                                    </div>
                                                </div>
                                                <br/>
                                                <br/>
                                                <p>
                                                    <small class=""><i><?php echo $nxtReviewReq->getRequestDateTime();?></i></small>
                                                </p>
                                            </div>
                                            <div class="span4">
                                                <div class="row">
                                                    <div class="span4">
                                                        <br/>
                                                        <blockquote>
                                                            <br/>
                                                            <p>
                                                                <?php echo $nxtReview->getReview();?>
                                                            </p>
                                                            <br/>
<?php
                                                            $displayName = "Anonomous";
                                                            if ($nxtReviewReq->getUserId() > 0)
                                                            {
                                                                $reviewer = getUserById($nxtReviewReq->getUserId());
                                                                $displayName = $reviewer->getTitle()." ".$reviewer->getLastname();
                                                            }
?>
                                                            <small><?php echo $displayName;?></small>
                                                        </blockquote> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>   
<?php
}
function getProductDetailLink($productid, $info="")
{
    $result = KeyRing::baseHref;
    /*
     * browse items are now gone, product code must be unique across system
    $catid = 0;
    
    $productBrowseItems = getBrowseItemsByProductBaseId($productid);
    
    if($productBrowseItems->totalNodes() > 0)
    {
        $productBrowseItemPrimary = $productBrowseItems->readNode(1);
        $catid = $productBrowseItemPrimary->getCatId();
    }
    */
    $nxtProduct = getProductBaseById($productid);
    $catshortname = getCatShortnameById($nxtProduct->getCatId());
    $result .= $catshortname."/".$nxtProduct->getShortname();
    
    if(isset($info) && !empty($info))
    {
        $result .= "?info=".$info;
    }
    
    return $result;
}
function createImageSet($imageName, $origDir, $folder)
{
    if(createImagePair($imageName, $origDir, "./images/_48x48/$folder/", 48, 48) &&
    createImagePair($imageName, $origDir, "./images/_200x100/$folder/", 200, 100) &&
    createImagePair($imageName, $origDir, "./images/_200x200/$folder/", 200, 200) &&
    createImagePair($imageName, $origDir, "./images/_400x200/$folder/", 400, 200) &&
    createImagePair($imageName, $origDir, "./images/_400x400/$folder/", 400, 400))
    {
        return true;
    }
    return false;
}
function createImagePair($imageName, $origDir, $destDir, $destWidth, $destHeight)
{
    //create image file
    //insert image db entry
    //and repeat for aspect ratio (done first for better quality)
    $result1 = false;
    $result2 = false;
    $original = new SimpleImage();
    $original->load($origDir.$imageName);
    $newDir = $destDir."aspectratio/";
    
    if($original->getHeight() > $destHeight){$original->resizeToHeight($destHeight);}
    if($original->getWidth() > $destWidth){$original->resizeToWidth($destWidth);}
    if(!is_dir($newDir)){mkdir($newDir);}
    if($original->save($newDir.$imageName, $original->image_type))
    {
        if(addImage(0,$newDir.$imageName , "", $destWidth,$destHeight))
        {
            $result1 = true;
        }
    }
    $original->resize($destWidth,$destHeight);
    if(!is_dir($destDir)){mkdir($destDir);}
    if($original->save($destDir.$imageName, $original->image_type))
    {
        if(addImage(0,$destDir.$imageName , "", $destWidth,$destHeight))
        {
            $result2 = true;
        }
    }
    return ($result1 && $result2);
}
function getPaginationDiv($itemList, $itemsPerPageOptions, $itemsPerPage, $pageLinksToShow, $currentPage, $pageLinkDest, $pageLinksOnly=false)
{
        $oldItemsPerPage = $itemsPerPageOptions[0];
        if(isset($_GET['pageSize']))
        {
            $oldItemsPerPage = $_GET['pageSize'];
        }
        if($oldItemsPerPage != $itemsPerPage)
        {
            $currentPage = 1;
        }

        $startProductIndex = (($currentPage- 1) * $itemsPerPage )+ 1;
        $endProductIndex = $startProductIndex + $itemsPerPage - 1;
        if($startProductIndex > $itemList->totalNodes()){$startProductIndex = $itemList->totalNodes() - $itemsPerPage;}
        if($startProductIndex <= 0){$startProductIndex = 1;}
        if($endProductIndex > $itemList->totalNodes()){$endProductIndex = $itemList->totalNodes();}
        if($itemList->totalNodes() <= 0){$startProductIndex = 0;$endProductIndex = 0;}
        
    if(!$pageLinksOnly)
    {
?>
        <div class="row">
            <div class="span9">
<?php
        echo "Showing results ".$startProductIndex." - ".$endProductIndex." of ".$itemList->totalNodes();
?>        
                <div class="pull-right">
                    Results per page
                    <?php
                    $pageLinkDest = remove_querystring_var($pageLinkDest, "pageSize");

                    if(!strstr($pageLinkDest, "?"))
                    {
                        $pageLinkDestAlt = $pageLinkDest."?";
                        $pageLinkDest .= "?pageSize=".$oldItemsPerPage; 
                    }
                    else
                    {
                        $pageLinkDestAlt = $pageLinkDest."&";
                        $pageLinkDest .= "&pageSize=".$oldItemsPerPage; 
                    }

                    ?>
                    <script type="text/javascript">
                        $(document).ready(function() {
                            $('#pageSizeSelect option').filter(function(){
                                return $(this).text() == '<?php echo $oldItemsPerPage;?>';
                            }).attr('selected', true);
                        });
                    </script>
                    <select class="span1" onchange="window.location = '<?php echo $pageLinkDestAlt."pageSize=";?>'+this[this.selectedIndex].value;" id="pageSizeSelect">
                        
<?php
                        foreach($itemsPerPageOptions as $prePageOption)
                        {
?>
                        <option value="<?php echo $prePageOption;?>"><?php echo $prePageOption;?></option>
<?php
                        }

?>
                    </select>
                </div>
            </div>
        </div>
<?php
    }
    
?>
        
        <div class="row">
            <div class="span9">
        <div class="pagination pagination-centered">
            <ul>
<?php
                
        $resultPageTotal = floor( $itemList->totalNodes() / $itemsPerPage );
        if($itemList->totalNodes() % $itemsPerPage > 0){
            $resultPageTotal += 1;
        }

        $resultPageStart = $currentPage - $pageLinksToShow/2;
        if($resultPageStart<=0){$resultPageStart = 1;}
        $resultPageFinish = $currentPage + $pageLinksToShow/2;
        if($resultPageFinish - $resultPageStart < $pageLinksToShow )
        {
            $resultPageFinish = $resultPageFinish + $pageLinksToShow - ($resultPageFinish - $resultPageStart);
        }
        if($resultPageFinish>$resultPageTotal)
        {
            $resultPageFinishDiff = $resultPageFinish - $resultPageTotal;
            $resultPageStart = $resultPageStart - $resultPageFinishDiff;
            if($resultPageStart <= 0){$resultPageStart = 1;}
            $resultPageFinish = $resultPageTotal;

        }
                
        //links
        $pageLinkDest = remove_querystring_var($pageLinkDest, "resultpage");
        if(!strstr($pageLinkDest, "?"))
        {
            $pageLinkDest .= "?";
        }
        else
        {
            $pageLinkDest .= "&";
        }
        $pageLinkDest .= "resultpage=";


        $linkPrev = $pageLinkDest.($currentPage-1);
        $linkNext = $pageLinkDest.($currentPage+1);

        $linkFirst = $pageLinkDest."1";
        $linkLast = $pageLinkDest.$resultPageTotal;
                
                
        if($resultPageStart > 1)
        { 
?>
                <li class="<?php if($currentPage <= 1){echo "disabled";}?>"><a href="<?php echo $linkFirst;?>"><<</a></li>
<?php     
        }
?>     
                <li class="<?php if($currentPage <= 1){echo "disabled";}?>"><a href="<?php echo $linkPrev;?>">Prev</a></li>
<?php
        for($i=$resultPageStart; $i <= $resultPageFinish; $i++)    
        {    
            $linkNum = $pageLinkDest.$i;
?>
                <li class="<?php if($i == $currentPage){ echo "active";}?>"><a href="<?php echo $linkNum;?>"><?php echo $i; ?></a></li>
<?php 
        }
?>
                <li class="<?php if($currentPage >= $resultPageTotal){echo "disabled";}?>"><a href="<?php echo $linkNext;?>">Next</a></li>
<?php
        if($resultPageFinish < $resultPageTotal)
        {   
?>
                <li class="<?php if($currentPage >= $resultPageTotal){echo "disabled";}?>"><a href="<?php echo $linkLast;?>">>></a></li>
<?php    
        }
?>
            </ul>
        </div>
    </div>
    </div>
<?php
}
function append_querystring_var($url, $keyval) {
    $seperator = (parse_url($url, PHP_URL_QUERY) == NULL) ? '?' : '&';
    return $url . $seperator . $keyval;
}
function remove_querystring_var($url, $key) { 
  $url = preg_replace('/(.*)(?|&)' . $key . '=[^&]+?(&)(.*)/i', '$1$2$4', $url . '&'); 
  $url = substr($url, 0, -1); 
  return $url; 
}

function detect_ie8($nav_agent)
{
    if(stristr($nav_agent,"msie 8")){
     return true;
    }
    return false;
    
}

function my_session_restart()
{
    $doc_root = preg_replace('%/site$%','',$_SERVER['DOCUMENT_ROOT']);
    ini_set('session.save_path',"$doc_root/SESSIONS");
    session_start();
}

function logout()
{

	$_SESSION['userid'] = 0;
	unset($_SESSION['userid']);
	session_destroy();

}


function isToday($date)
{
	$date = date("l, F d",strtotime($date));
  if($date == date("l, F d"))
  return true;
  else
  return false; 
}

function generatePassword ($length = 8)
  {

    $password = "";

    $possible = "2346789bcdfghjkmnpqrtvwxyzBCDFGHJKLMNPQRTVWXYZ";

    $maxlength = strlen($possible);
  
    if ($length > $maxlength) {
      $length = $maxlength;
    }
	
    $i = 0; 
    
    while ($i < $length) { 

      $char = substr($possible, mt_rand(0, $maxlength-1), 1);
        
      if (!strstr($password, $char)) { 
        $password .= $char;
        $i++;
      }

    }

    return $password;

  }
  //TODO: modify for products
  function generateSitemapXML()
  {
        
    $filename = "./sitemap.xml";

    $xmlDoc = new DOMDocument('1.0', 'utf-8');

    $urlset = $xmlDoc->createElement('urlset');
    $xmlns = $xmlDoc->createAttribute('xmlns');
    $xmlns->value = "http://www.sitemaps.org/schemas/sitemap/0.9";
    $urlset->appendChild($xmlns);
    
      
      
      
                     
                      
    $chapters = getChaptersByBookId(1);

    if($chapters->totalNodes() > 0)
    {
        
        for($i=1; $i <= $chapters->totalNodes(); $i++)    
        {
            $nextChapter = $chapters->readNode($i);
            
            $chapterLinks = getLinksByChapterId($nextChapter->getId());

            if($chapters->totalNodes() > 0)
            {
                
                for($j=1; $j <= $chapterLinks->totalNodes(); $j++)    
                {

                    $nextChapterLink = $chapterLinks->readNode($j);

                    //if a NAV1 link
                    if($nextChapterLink->getNavigational() == 1)
                    {

                        $nextTarget = $nextChapterLink->getTarget();

                        
                        $newurl = $xmlDoc->createElement("url");
                        $trgt = htmlspecialchars($nextTarget->getTarget(), ENT_QUOTES);
                        
                        // replace . with http://www.adg.ie
                        
                        $trgt = "http://www.adg.ie".substr($trgt,1);
                        
                        $newurlloc = $xmlDoc->createElement('loc', $trgt);
                        $newurl->appendChild($newurlloc);
                        
                        $urlset->appendChild($newurl);
                    }
                }
            }
        }
    }
    
    
    $xmlDoc->appendChild($urlset);
    return $xmlDoc->save($filename);	
  }
  
  function backupImages()
  {
    $doc_root = preg_replace('%/web$%','',$_SERVER['DOCUMENT_ROOT']);
    
    $backupName = 'images_'.time().'.zip';
    
    Zip('./images/', $doc_root.'/_BACKUPS/'.$backupName, true);
    
    return file_exists($doc_root.'/_BACKUPS/'.$backupName);
  }
  
  function backupFiles()
  {
    $doc_root = preg_replace('%/web$%','',$_SERVER['DOCUMENT_ROOT']);
    
    $backupName = 'files_'.time().'.zip';
    
    Zip('./upload/', $doc_root.'/_BACKUPS/'.$backupName, true);
    
    return file_exists($doc_root.'/_BACKUPS/'.$backupName);
  }
  
  function backupDb()
  {
      /* backup all tables of pslc2 */
    backup_tables(KeyRing::mysqlServer,KeyRing::mysqlUsername,KeyRing::mysqlPassword,KeyRing::mysqlDbName);
    
    $doc_root = preg_replace('%/web$%','',$_SERVER['DOCUMENT_ROOT']);
    
    $backupName = 'db_'.time().'.zip';
    
    Zip('./db/', $doc_root.'/_BACKUPS/'.$backupName, true);
    
    return file_exists($doc_root.'/_BACKUPS/'.$backupName);
  }
  


/* backup the db OR just a table */
function backup_tables($host,$user,$pass,$name,$tables = '*')
{

    $backup_link = mysql_connect($host,$user,$pass);
    mysql_select_db($name,$backup_link);

    //get all of the tables
    if($tables == '*')
    {
        $tables = array();
        $result = mysql_query('SHOW TABLES');
        while($row = mysql_fetch_row($result))
        {
            $tables[] = $row[0];
        }
    }
    else
    {
        $tables = is_array($tables) ? $tables : explode(',',$tables);
    }

    $return = '';
    //cycle through
    foreach($tables as $table)
    {
        $result = mysql_query('SELECT * FROM '.$table);
        $num_fields = mysql_num_fields($result);
        $return.= 'DROP TABLE '.$table.';';
        $row2 = mysql_fetch_row(mysql_query('SHOW CREATE TABLE '.$table));
        $return.= "\n\n".$row2[1].";\n\n";

        for ($i = 0; $i < $num_fields; $i++) 
        {
            while($row = mysql_fetch_row($result))
            {
                $return.= 'INSERT INTO '.$table.' VALUES(';
                for($j=0; $j<$num_fields; $j++) 
                {
                    $row[$j] = addslashes($row[$j]);
                    $row[$j] = ereg_replace("\n","\\n",$row[$j]);
                    if (isset($row[$j])) { $return.= '"'.$row[$j].'"' ; } else { $return.= '""'; }
                    if ($j<($num_fields-1)) { $return.= ','; }
                }
                $return.= ");\n";
            }
        }
        $return.="\n\n\n";
    }

    //save file
    $backupName = 'db-backup-'.time().'-'.(md5(implode(',',$tables)));
    $handle = fopen('./db/'.$backupName.'.sql','w+') or die("can't open file");

    fwrite($handle,$return);
    fclose($handle);
    
    
    
    $file = './db/'.$backupName.'.sql';
    
    if(Zip($file, './db/'.$backupName.'.zip', true))
    {
        unlink('./db/'.$backupName.'.sql');
    }
    
    
    
    return file_exists('./db/'.$backupName.'.zip');
}

/* creates a compressed zip file */
function create_zip($files = array(),$destination = '',$overwrite = false) {
	//if the zip file already exists and overwrite is false, return false
	if(file_exists($destination) && !$overwrite) { return false; }
	//vars
	$valid_files = array();
	//if files were passed in...
	if(is_array($files)) {
		//cycle through each file
		foreach($files as $file) {
			//make sure the file exists
			if(file_exists($file)) {
				$valid_files[] = $file;
			}
		}
	}
	//if we have good files...
	if(count($valid_files)) {
		//create the archive
		$zip = new ZipArchive();
		if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
			return false;
		}
		//add the files
		foreach($valid_files as $file) {
			$zip->addFile($file,$file);
		}
		//debug
		//echo 'The zip archive contains ',$zip->numFiles,' files with a status of ',$zip->status;
		
		//close the zip -- done!
		$zip->close();
		
		//check to make sure the file exists
		return file_exists($destination);
	}
	else
	{
		return false;
	}
}

function Zip($source, $destination = '',$overwrite = false)
{
    if (!extension_loaded('zip')) { return false; }
    if(file_exists($destination) && !$overwrite) { return false; }

    $zip = new ZipArchive();
    if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
            return false;
    }

    $source = str_replace('\\', '/', realpath($source));

    if (is_dir($source) === true)
    {
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source), RecursiveIteratorIterator::SELF_FIRST);

        foreach ($files as $file)
        {

            if(file_exists($file))
            {
                $file = str_replace('\\', '/', $file);

                // Ignore "." and ".." folders
                if( in_array(substr($file, strrpos($file, '/')+1), array('.', '..')) )
                    continue;

                $file = realpath($file);

                if (is_dir($file) === true)
                {
                    $zip->addEmptyDir(str_replace($source . '/', '', $file . '/'));
                }
                else if (is_file($file) === true)
                {
                    $zip->addFromString(str_replace($source . '/', '', $file), file_get_contents($file));
                }
            }
        }
    }
    else if(is_array($files)) {
            
                $valid_files = array();
		//cycle through each file
		foreach($files as $file) {
			//make sure the file exists
			if(file_exists($file)) {
				$valid_files[] = $file;
			}
		}
                //if we have good files...
                if(count($valid_files)) {
                        //create the archive
                        $zip = new ZipArchive();
                        if($zip->open($destination,$overwrite ? ZIPARCHIVE::OVERWRITE : ZIPARCHIVE::CREATE) !== true) {
                                return false;
                        }
                        //add the files
                        foreach($valid_files as $file) {
                                $zip->addFile($file,$file);
                        }

                }
                else
                {
                        return false;
                }
                
                
    }
    elseif (is_file($source) === true)
    {
        $zip->addFromString(basename($source), file_get_contents($source));
    }

    $zip->close();
    
    //check to make sure the file exists
    return file_exists($destination);
}

  
?>
