<?php

function addProductFilter($userid, $productCode, $filterName, $filterValue)
{
    $sql="INSERT INTO productFilters (productcode,filtername,filtervalue)
            values ('$productCode','$filterName','$filterValue');";
    
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productFilter added, productCode = $productCode, filtername = $filterName");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"productFilter add failed, productCode = $productCode, filtername = $filterName");
    return false;
}

function removeProductFilters($productCode)
{
    $sql="DELETE FROM productFilters WHERE productcode = '$productCode';";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"product filters deleted, productCode = $productCode");
        return true;
    }
    logEntry(StateMgr::logWarning,"product filters delete failed, productCode = $productCode");
    return false;
}

function getProductBaseIdByCodeAndCat($productBaseCode,$catId)
{
	$sql="SELECT DISTINCT id FROM productBases WHERE productcode = '$productBaseCode' and catid = $catId;";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();

            if($row->id >= 0)
            {
                return $row->id;
            }
	}

	return -1;
}

function getProductBaseIdByCode($productBaseCode)
{
	$sql="SELECT DISTINCT id FROM productBases WHERE productcode = '$productBaseCode'";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();

            if($row->id >= 0)
            {
                return $row->id;
            }
	}

	return -1;
}
function getOrphanProductBases()
{
    $result = new LinkList();
    
    $sql = "select productBases.id from productBases left  join productCategories on productBases.catid = productCategories.id where productCategories.id is null;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getProductBaseById($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;

    
    }
function getProductBaseCountByCat($id)
{
    $sql="SELECT count(*) as count FROM productBases WHERE catid = $id;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        if($row->count >= 0)
        {
            return $row->count;
        }
    }
    return -1; 
    
}
function removeEmptyCategories()
{
    $sql="DELETE FROM productCategories WHERE id NOT IN (SELECT DISTINCT catid FROM productBases);";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"orphan categories deleted");
        return true;
    }
    logEntry(StateMgr::logWarning,"orphan category delete failed");
    return false;
}
function removeCategoryById($catId)
{
    $sql="DELETE FROM browseItems WHERE catid = $catId;";
        
    if(executeNonQuery($sql))
    {
        $sql="DELETE FROM productCategories WHERE id = $catId;";
        if(executeNonQuery($sql))
        {
            logEntry(StateMgr::logDebug,"category deleted, id = $catId");
            return true;
        }
    }
    logEntry(StateMgr::logWarning,"category delete failed, id = $catId");
    return false;
}
function createCategory($name, $shortname)
{
    $sql="INSERT INTO productCategories (name, shortname) values ('$name','$shortname');";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"category added, name = $name");
        return true;
    }
    logEntry(StateMgr::logWarning,"category add failed, name = $name");
    return false;
}
        
function updateProductSpecifications($productid, $productSpecifications)
{
    $sql = "UPDATE productBases SET specifications = '$productSpecifications' WHERE id = $productid";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"product specifications updated, id = $productid");    
        return true;
    }
    logEntry(StateMgr::logWarning,"product specifications update failed, id = $productid");    
    return false;
}
function updateProductDescription($productid, $productDescription)
{
    $sql = "UPDATE productBases SET description = '$productDescription' WHERE id = $productid";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"product description updated, id = $productid");    
        return true;
    }
    logEntry(StateMgr::logWarning,"product description update failed, id = $productid");    
    return false;
}
function updateProductDetails($productid, $productDetails)
{
    $sql = "UPDATE productBases SET details = '$productDetails' WHERE id = $productid";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"product details updated, id = $productid");    
        return true;
    }
    logEntry(StateMgr::logWarning,"product details update failed, id = $productid");    
    return false;
}
function updateProductAvailability($productid, $productAvailability)
{
    $sql = "UPDATE productBases SET availability = '$productAvailability' WHERE id = $productid";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"product availabililty updated, id = $productid");    
        return true;
    }
    logEntry(StateMgr::logWarning,"product availabililty update failed, id = $productid");    
    return false;
}
function removeComponentMapping($productCode)
{
    $sql="DELETE FROM componentMapping WHERE productcode = '$productCode' or componentproductcode = '$productCode' ;";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"Components updated, removed productcode = $productCode");
        return true;
    }
    logEntry(StateMgr::logWarning,"Components update failed, productcode = $productCode");
    return false;
    
}
function updateComponentMapping($productCode, $componentCode, $defaultCount)
{
    $sql="DELETE FROM componentMapping WHERE productcode = '$productCode' AND componentproductcode = '$componentCode';";
        
    if(executeNonQuery($sql))
    {
        $sql="INSERT INTO componentMapping (productcode, componentproductcode, defaultcomponentqty) values ('$productCode','$componentCode',$defaultCount);";

        if(executeNonQuery($sql))
        {
            logEntry(StateMgr::logDebug,"Components updated, productcode = $productCode");
            return true;
        }
    }
    logEntry(StateMgr::logWarning,"Components update failed, productcode = $productCode");
    return false;
    
}
function getComponentDefaultQty($productCode, $componentProductCode)
{
    $sql = "SELECT defaultcomponentqty FROM componentMapping WHERE productcode='$productCode' AND componentproductcode = '$componentProductCode';";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->defaultcomponentqty;
    }
    return 0;
}
function getComponentProductsByCode($productCode)
{
	$result = new LinkList();
	
	$sql="SELECT DISTINCT componentproductcode as productcode FROM componentMapping WHERE productcode = '$productCode';";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductBaseByCode($row->productcode);
                $result->insertLast($nxt);
            }
	}

	return $result;
}
function addBrowseItem($catid, $productId)
{
    $sql="INSERT INTO browseItems (catid, productbaseid) values ($catid,$productId);";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"browseItem added, productbaseid = $productId");
        return true;
    }
    logEntry(StateMgr::logWarning,"browseItem add failed, productbaseid = $productId");
    return false;
}

function removeBrowseItemById($browseItemId)
{
    $sql="DELETE FROM browseItems WHERE id = $browseItemId;";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"browseItem deleted, id = $browseItemId");
        return true;
    }
    logEntry(StateMgr::logWarning,"browseItem delete failed, id = $browseItemId");
    return false;
}
function updateBrowseItemCat($browseItemId,$browseItemCat)
{
    $sql = "UPDATE browseItems SET catid = $browseItemCat WHERE id = $browseItemId";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"browseItem category updated, browseItemId = $browseItemId");    
        return true;
    }
    logEntry(StateMgr::logWarning,"browseItem category update failed, browseItemId = $browseItemId");    
    return false;
}
function getFolderNameByCatId($catId)
{
    $sql = "SELECT name FROM productFolders WHERE catid=$catId;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->name;
    }
    return "";
}
function getBrowseItemsByProductBaseId($productBaseId)
{
	$result = new LinkList();
	
	$sql="SELECT DISTINCT id FROM browseItems WHERE productbaseid = $productBaseId";
        
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getBrowseItemById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;
}
function getBrowseItemById($browseItemId)
{
	$sql="SELECT browseItems.id, browseItems.catid, browseItems.productbaseid, productBases.name, productBases.description, productBases.searchResultImgId ";
        $sql.=" FROM browseItems LEFT JOIN productBases ON browseItems.productbaseid = productBases.id ";
        $sql.=" WHERE browseItems.id = $browseItemId;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            
            $result = new BrowseItem();
            $result->setId($row->id);
            $result->setCatId($row->catid);
            $result->setProductBaseId($row->productbaseid);
            $result->setName($row->name);
            $result->setDescription($row->description);
            $result->setImgId($row->searchResultImgId);
            return $result;
	}

	$result = new BrowseItem();
        $result->setId(0);
	return $result;
}
function getBrowseItemsByCatIdAndProducts($catid, $productList)
{
	$result = new LinkList();
	
	$sql="SELECT * FROM browseItems WHERE catid = $catid";
        
        
        if(isset($productList) && $productList->totalNodes() > 0)
        {
            
            $sql .= " AND productbaseid in (";
            
            for($i=1; $i <= $productList->totalNodes(); $i++)    
            {
                $nxtProduct = $productList->readNode($i);
                $sql .= $nxtProduct->getId();
                
                if($i < $productList->totalNodes())
                {
                    $sql .= ",";
                }
            }
            
            $sql .= ")";
        }
        
        $sql .= ";";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getBrowseItemById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;
}
function getBrowseItemsByCatId($catid)
{
	$result = new LinkList();
	
	$sql="SELECT * FROM browseItems WHERE catid = $catid;";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getBrowseItemById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;
}
function getSearchResultProductBases($keys)
{
    $result = new LinkList();

    $sql = "SELECT id FROM productBases WHERE MATCH(name,description,details) AGAINST ('\"$keys\"' IN BOOLEAN MODE);";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
        }
    }

    return $result; 
}
function getSearchResultProductBasesNameDesc($keys)
{
    $result = new LinkList();

    $sql = "SELECT id FROM productBases WHERE shortname like '%$keys%' or name like '%$keys%' or description like '%$keys%';";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
        }
    }

    return $result; 
}
function getSearchResultProductBasesNameDescCat($keys,$catId)
{
    $result = new LinkList();

    $sql = "SELECT id FROM productBases WHERE catid = $catId AND (shortname like '%$keys%' or name like '%$keys%' or description like '%$keys%');";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
        }
    }

    return $result; 
}
function getSearchResultProductBasesComposite($keys)
{
    $result = getSearchResultProductBasesName($keys);
    $result->addListToEnd(getSearchResultProductBasesDesc($keys));
    return $result;
}
function getSearchResultProductBasesName($keys)
{
    $result = new LinkList();

    $sql = "SELECT id FROM productBases WHERE name like '%$keys%';";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
        }
    }

    return $result; 
}
function getSearchResultProductBasesDesc($keys)
{
    $result = new LinkList();

    $sql = "SELECT id FROM productBases WHERE description like '%$keys%';";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
        }
    }

    return $result; 
}
function getMessageByReq($requestId)
{
        
	$sql = "SELECT id FROM _messages WHERE requestid = $requestId;";      
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $result = getMessage($row->id);
            return $result;
	}

        $result = new Message();              
        $result->setId(0);
	return $result;
}
function getMessage($messageId)
{
        
	$sql = "SELECT * FROM _messages WHERE id = $messageId;";     
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $result = new Message();              
            $result->setId($row->id);
            $result->setRequestId($row->requestid);
            $result->setName($row->name);
            $result->setEmail($row->email);
            $result->setFax($row->fax);
            $result->setPhone($row->phone);
            $result->setMessage($row->message);
            return $result;
	}

        $result = new Message();              
        $result->setId(0);
	return $result;
}
function addMessage($name, $email,$fax, $phone,$message,$userId)
{
        $sql="SELECT MAX(id) as id FROM requests ;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $reqId = $row->id + 1;
        }
        else
        {
            return false;
        }
        if ($reqId > 0){
            
            $sql="INSERT INTO requests (id, type, userid, requestdatetime, state) values ($reqId, ".TypeMgr::contactRequest.", $userId, NOW(), ".StateMgr::requestPending.");";
            
            if(executeNonQuery($sql))
            {
                $sql="INSERT INTO _messages (requestid,name,email,fax,phone,message) ";
                $sql.="values ($reqId,'$name','$email','$fax','$phone','$message');";
                
                if(executeNonQuery($sql))
                {
                    $subject = "Feedback/Message";
                    $formattedMsg = "From:".$name." ($email) \n\n".$message;
                    sendMail("info@adg.ie", $subject, "feedback@adg.ie", $formattedMsg);

                    logEntry(StateMgr::logDebug,"contact request added, reqId = $reqId");    
                    return true;
                }
                
                logEntry(StateMgr::logWarning,"message add failed, reqId = $reqId");    
                return false;
            }
            
            logEntry(StateMgr::logWarning,"message request add failed, reqId = $reqId");    
            return false;
        }
        
        logEntry(StateMgr::logWarning,"message add failed");    
        return false;
}

function isValidProductId($productid)
{
    $sql="SELECT count(*) as count FROM productBases WHERE id = $productid;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        if($row->count > 0)
        {
            return true;
        }
    }
    return false; 
}
function isValidCatId($catid)
{
    $sql="SELECT count(*) as count FROM productCategories WHERE id = $catid;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        if($row->count > 0)
        {
            return true;
        }
    }
    return false; 
}
function isValidCatShortname($cat)
{
    $sql="SELECT count(*) as count FROM productCategories WHERE shortname = '$cat';";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        if($row->count > 0)
        {
            return true;
        }
    }
    return false; 
}
function updateRequestState($state,$requestid)
{
    $sql = "UPDATE requests SET state = $state WHERE id = $requestid";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"request state updated, requestid = $requestid");    
        return true;
    }
    logEntry(StateMgr::logWarning,"request state update failed, requestid = $requestid");    
    return false;
}
function getRequestCountByTypeAndState($type,$state)
{
    $sql = "SELECT count(DISTINCT id) as count FROM requests WHERE type=$type AND state=$state;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->count;
    }
    return "?";
}
function getRequestCountByType($type)
{
    $sql = "SELECT count(DISTINCT id) as count FROM requests WHERE type=$type;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->count;
    }
    return "?";
}
function getRequestCount($state)
{
    $sql = "SELECT count(DISTINCT id) as count FROM requests WHERE state=$state;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->count;
    }
    return "?";
}
function getRequestsByTypeAndState($requestType,$requestState)
{
    $result = new LinkList();
    
    $sql="SELECT id FROM requests WHERE type = $requestType AND state = $requestState;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getRequest($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;

}
function getRequestsByType($requestType)
{
    $result = new LinkList();
    
    $sql="SELECT id FROM requests WHERE type = $requestType;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getRequest($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;

}
function getRequestsByState($requestState)
{
    $result = new LinkList();
    
    $sql="SELECT id FROM requests WHERE state = $requestState;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getRequest($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;

}
function getApprovedReviews($productid)
{
    $result = new LinkList();

    $sql = "SELECT productReviews.id FROM productReviews JOIN requests ON productReviews.requestid = requests.id WHERE productReviews.productid = $productid and requests.state = ".StateMgr::requestAnswered." AND requests.type = ".TypeMgr::reviewRequest." ;";       
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $nxt = getReview($row->id);
                $result->insertLast($nxt);
	}
    }

    return $result;  
}
function getReviewByReq($requestid)
{
    $sql = "SELECT id FROM productReviews WHERE requestid = $requestid;";       
        
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();  
        return getReview($row->id);
    }

    $result = new Review();              
    $result->setId(0);
    return $result;
}
function getReview($reviewid)
{
    $sql = "SELECT * FROM productReviews WHERE id = $reviewid;";       
        
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $result = new Review();              
        $result->setId($row->id);
        $result->setRequestId($row->requestid);
        $result->setProductId($row->productid);
        $result->setQualityScore($row->qualityscore);
        $result->setValueScore($row->valuescore);
        $result->setPerformanceScore($row->performancescore);
        $result->setAppearanceScore($row->appearancescore);
        $result->setReview($row->review);
        return $result;
    }
    $result = new Review();              
    $result->setId(0);
    return $result;
}

function retractRequest($requestid, $userid)
{
    if ($requestid > 0){
        $sql="UPDATE requests set state = ".StateMgr::requestRetracted." where id = $requestid and userid = $userid;";
        if(executeNonQuery($sql))
        {
            logEntry(StateMgr::logDebug,"quote item retracted, requestid = $requestid");    
            return true;
        }
    }
    logEntry(StateMgr::logWarning,"quote item retract failed, requestid = $requestid"); 
    return false;
}
function getPendingRequestCount($userid)
{
    $sql = "SELECT count(*) as count FROM requests WHERE userid = $userid and state = ".StateMgr::requestPending.";";       

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->count;
    }

    return -1; 
}
function createBasketFromQuoteRequest($requestid)
{
    $result = New Basket();
    $req = getRequest($requestid);
    
    if($req->getId() <= 0)
    {
        return $result;
    }
    
    $reqItems = getQuoteRequestItems($req->getId());
    
    if(isset($reqItems) && $reqItems->totalNodes() > 0)
    {
        for($j=1; $j <= $reqItems->totalNodes(); $j++)    
        {
            $nxtItem = $reqItems->readNode($j);
            $result->addItem($nxtItem->getQuantity(), $nxtItem->getProductCode());
        }
    }
    
    return $result;
    
}
function getQuoteRequestItems($requestid)
{
    $result = new LinkList();

    $sql = "SELECT id FROM quoteRequestItems WHERE quoterequestid = $requestid;";  
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getQuoteRequestItemById($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;  
}
function getQuoteRequestItemById($itemid)
{
    $sql = "SELECT * FROM quoteRequestItems WHERE id = $itemid;";       
        
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $result = new QuoteRequestItem();    
        $result->setId($row->id);
        $result->setQuoteRequestId($row->quoterequestid);
        $result->setProductCode($row->productcode);
        $result->setQuantity($row->quantity);
        return $result;  
    }
    $result = new QuoteRequestItem();              
    $result->setId(0);
    return $result;  
}
function getRequests($userid)
{
    $result = new LinkList();

    $sql = "SELECT id FROM requests WHERE userid = $userid;"; 

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getRequestById($userid, $row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;  
}
function getRequestById($userid, $requestid)
{
    $sql = "SELECT * FROM requests WHERE userid = $userid AND id = $requestid;";       
        
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $result = new Request();       
        $result->setId($row->id);
        $result->setType($row->type);
        $result->setUserId($row->userid);
        $result->setRequestDateTime($row->requestdatetime);
        $result->setState($row->state);
        return $result;  
    }

    $result = new Request();              
    $result->setId(0);
    return $result;  
}
function getRequest($requestid)
{
    $sql = "SELECT * FROM requests WHERE id = $requestid;";       
        
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $result = new Request(); 
        $result->setId($row->id);
        $result->setType($row->type);
        $result->setUserId($row->userid);
        $result->setRequestDateTime($row->requestdatetime);
        $result->setState($row->state);
        return $result;  
    }

    $result = new Request();              
    $result->setId(0);
    return $result;  
}
function submitReviewRequest($productid, $quailtyScore,$valueScore,$performanceScore,$appearanceScore,$review, $userId)
{
        $sql="SELECT MAX(id) as id FROM requests ;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $reqId = $row->id + 1;
        }
        else
        {
            return false;
        }
        if ($reqId > 0){
            
            $sql="INSERT INTO requests (id, type, userid, requestdatetime, state) values ($reqId, ".TypeMgr::reviewRequest.", $userId, NOW(), ".StateMgr::requestPending.");";
            if(executeNonQuery($sql))
            {
                $sql="INSERT INTO productReviews (requestid,productid,qualityscore,valuescore,performancescore,appearancescore,review) ";
                $sql.="values ($reqId,$productid,$quailtyScore,$valueScore,$performanceScore,$appearanceScore,'$review');";
                if(executeNonQuery($sql))
                {
                    logEntry(StateMgr::logDebug,"product review added, reqId = $reqId");    
                    return true;
                }
            }
            
            logEntry(StateMgr::logWarning,"product review request add failed, reqId = $reqId");   
            return false;
        }
        
        logEntry(StateMgr::logWarning,"product review request add failed");   
        return false;
}
function submitQuoteRequest($basket, $userId)
{
    $sql="SELECT MAX(id) as id FROM requests ;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $reqId = $row->id + 1;
    }
    else
    {
        return false;
    }
    $result = false;
    if ($reqId > 0){

        $sql="INSERT INTO requests (id, type, userid, requestdatetime, state) values ($reqId, ".TypeMgr::quoteRequest.", $userId, NOW(), ".StateMgr::requestPending.");";
        $result = executeNonQuery($sql);

        for($i=1; $i <= $basket->getNbLineItems(); $i++)    
        {
            $nxtItem = $basket->items->readNode($i);

            if($result){ 

                $sql="INSERT INTO quoteRequestItems (quoterequestid, productcode, quantity) values ($reqId, '".$nxtItem->getProductCode()."', ".$nxtItem->getQty().");";

                if(!$result = executeNonQuery($sql))
                {
                    $sql="UPDATE requests set state = ".StateMgr::requestFailed." where quoterequestid = $reqId);";
                    executeNonQuery($sql);
                    logEntry(StateMgr::logSevere,"quote request item failed to add, reqId = $reqId");
                }
            }
        }
    }

    if ($result) {
        logEntry(StateMgr::logDebug,"quote request added, reqId = $reqId");           
        return true;
    }
    logEntry(StateMgr::logSevere,"quote request failed to add, reqId = $reqId");           
    return false;
}

function getCatShortnameById($catid)
{
    $sql="SELECT shortname FROM productCategories WHERE id = $catid;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->shortname;
    }
    return "UNKNOWN";   
}
function getCatIdByName($name)
{
    $name = strtolower($name);
    
    $sql="SELECT id FROM productCategories WHERE LOWER(name) = '$name';";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->id;
    }

    return 0;   
}
function getCatIdByShortname($shortname)
{
    $shortname = strtolower($shortname);
    
    $sql="SELECT id FROM productCategories WHERE LOWER(shortname) = '$shortname';";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->id;
    }

    return 0;   
}
function getProductIdByShortname($shortname)
{
    $shortname = strtolower($shortname);
    
    $sql="SELECT id FROM productBases WHERE LOWER(shortname) = '$shortname';";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->id;
    }
    
    return 0;   
}

function doesBaseShortnameExists($shortname,$excludeId)
{
    $sql="SELECT count(*) as count FROM productBases WHERE shortname = '$shortname' AND id <> $excludeId;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        if($row->count <= 0)
        {
            return false;
        }
    }
    return true;    
}

function doesBaseCodeExists($productCode,$excludeId)
{
    $sql="SELECT count(*) as count FROM productBases WHERE productCode = '$productCode' AND id <> $excludeId;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        if($row->count <= 0)
        {
            return false;
        }
    }
    return true;    
}

function removeProductSpecMapping($userid, $catchId)
{
    $sql="DELETE FROM productSpecMappings WHERE id = $catchId;";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpecMapping deleted, id = $catchId");
        return true;
    }
    logEntry(StateMgr::logWarning,"productSpecMapping delete failed, id = $catchId");
    return false;
}
function addProductSpecInstance($userid, $specid, $specvallower, $specvalupper)
{
    $sql="INSERT INTO productSpecInstances (specid, specvallower, specvalupper) values ($specid, '$specvallower','$specvalupper');";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpecInstance added, specid = $specid");
        return true;
    }
    logEntry(StateMgr::logWarning,"productSpecInstance add failed, specid = $specid");
    return false;
}
function addProductSpec($userid, $name, $type, $dim)
{
    if(isset($dim) && strlen($dim) > 0)
    {
        $sql="INSERT INTO productSpecs (name, type, dim) values ('$name', '$type', '$dim');";
    }
    else
    {
        $sql="INSERT INTO productSpecs (name, type) values ('$name', '$type');";
    }
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpec added, name = $name");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"productSpec add failed, name = $name");
    return false;
}
function addProductSpecMapping($userid, $baseid, $specid, $specinstanceid)
{
    $sql="INSERT INTO productSpecMappings (baseid, specid, specinstanceid) values ($baseid, $specid,$specinstanceid);";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpecMapping added, specinstanceid = $specinstanceid");
        return true;
    }
    logEntry(StateMgr::logWarning,"productSpecMapping add failed, specinstanceid = $specinstanceid");
    return false;
}

function clearAllProductSpecMapping($userid, $baseid)
{
    $sql="DELETE FROM productSpecMappings WHERE baseid = $baseid;";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpecMappings deleted, baseid = $baseid");
        return true;
    }
    logEntry(StateMgr::logWarning,"productSpecMappings delete failed, baseid = $baseid");
    return false;
}
function getProductSpecInstances($specid)
{
    $result = new LinkList();

    $sql = "SELECT * FROM productSpecInstances WHERE specid = $specid;";  
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getProductSpecInstanceById($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;   
}
function getProductSpecMappings($productid)
{
        $result = new LinkList();
        
	$sql = "SELECT * FROM productSpecMappings WHERE baseid = $productid;";    
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductSpecMappingById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;   
}

function deleteProductSpec($userId, $id)
{
    if(deleteProductSpecInstance($userId, $id))
    {
        $sql = "delete from productSpecs where id = $id;";

        if(executeNonQuery($sql))
        {
            logEntry(StateMgr::logDebug,"productSpec deleted, id = $id");
            return true;
        }
    }
    
    logEntry(StateMgr::logWarning,"productSpec delete failed, id = $id");
    return false;
}
function deleteProductSpecInstanceBySpecId($userId, $specid)
{
    $sql = "delete from productSpecInstances where specid = $specid;";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpecInstances deleted, specid = $specid");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"productSpecInstance deleted, specid = $specid");
    return false;
}
function deleteProductSpecInstance($userId, $id)
{
    $sql = "delete from productSpecInstances where id = $id;";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productSpecInstance deleted, id = $id");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"productSpecInstance delete failed, id = $id");
    return false;
}
function getProductSpecInstanceById($id)
{
        
	$sql = "SELECT * FROM productSpecInstances WHERE id = $id;";       
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $result = new ProductSpecInstance();     
            $result->setId($row->id);
            $result->setSpecId($row->specid);
            $result->setSpecValLower($row->specvallower);
            $result->setSpecValUpper($row->specvalupper);
            return $result;  
	}

        $result = new ProductSpecInstance();              
        $result->setId(0);
	return $result;   
}
function getProductSpecMappingById($id)
{
        
    $sql = "SELECT * FROM productSpecMappings WHERE id = $id;";       

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $result = new ProductSpecMapping();  
        $result->setId($row->id);
        $result->setBaseId($row->baseid);
        $result->setSpecId($row->specid);
        $result->setSpecInstanceId($row->specinstanceid);
        return $result;   
    }

    $result = new ProductSpecMapping();              
    $result->setId(0);
    return $result;   
}
function getTopProducts($count)
{
    $result = new LinkList();

    $sql = "SELECT DISTINCT id FROM productBases LIMIT 0, $count;";  
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxt = getProductBaseById($row->id);
            $result->insertLast($nxt);
        }
    }

    return $result;
}
function getProductBaseCount($specid, $specval)
{
    $sql = "SELECT count(DISTINCT baseid) as count FROM productSpecMappings WHERE specid=$specid AND specval='$specval';";
    
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->count;
    }

    return "?";
}

function countProductBasesBySpecsAndCat($specinstances)
{
    $sql = "SELECT DISTINCT baseid as count FROM productSpecMappings WHERE specinstanceid IN ";

    if(count($specinstances)>0){$sql .= " ( ";}
    for($i=0; $i < count($specinstances); $i++)    
    {
        $sql .= $specinstances_arr[$i];//TODO: change this on condition specType (text/numeric)
        if($i < count($specinstances)-1){$sql .= " , ";}   
    }
    if(count($specinstances)>0){$sql .= " ) ";}

    $sql .= ";";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->count;
    }

    return "?";
}

function countProductBasesBySpecs($catId,$specinstances)
{
        $specinstances_arr = $specinstances;
	
        if(count($specinstances_arr) <= 0)
        {
            return "?";// empty list
        }
        
        
	$sql = "SELECT count(DISTINCT id) as count FROM productBases WHERE catid=$catId ";
        $filters = "";
        for($i=0; $i < count($specinstances_arr); $i++)    
        {
            $filters .= "select distinct baseid from productSpecMappings m where ";
            $filters .= "(m.specinstanceid = ".$specinstances_arr[$i].")";//TODO: change this on condition specType (text/numeric)
            if($i < count($specinstances_arr)-1)
            {
                $filters .= " AND baseid IN ("    ;            
            }
            
        }
        
        if(count($specinstances_arr) > 0)
        {
            $sql .= " AND id IN (".$filters;
            for($i=0; $i < count($specinstances_arr); $i++)    
            {
                $sql .= ")";
            }
        }
        $sql .= ";";
        
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            return $row->count;
	}

	return "?";

}
function getProductBasesByBrowseItems($browseItemList)
{
    
        $result = new LinkList();
        
        if($browseItemList->totalNodes() <= 0)
        {
            return $result;// empty list
        }
        
        
	$sql = "SELECT DISTINCT id FROM productBases WHERE id IN (";
        
        for($i=1; $i <= $browseItemList->totalNodes(); $i++)    
        {
            $nxtBrowseItem = $browseItemList->readNode($i);
            $sql .= $nxtBrowseItem->getProductBaseId();   
            if($i < $browseItemList->totalNodes())
            {
                $sql .= ","    ;            
            }            
        }
        $sql .= ");";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;
}
function getProductBasesByFilters($filters)
{
        $result = new LinkList();
        
        if(count($filters) <= 0)
        {
            return $result;// empty list
        }
        $filterStr = implode(',',$filters);
        $sql = "select distinct productBases.* from productFilters 
                join productBases on productFilters.productcode = productBases.productcode
                where concat(filtername,'.',filtervalue) in (
                select concat(filtername,'.',filtervalue) as filter from productFilters
                where id in ($filterStr));";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = new ProductBase();
                $nxt->setId($row->id);
                $nxt->setCatId($row->catid);
                $nxt->setName($row->name);
                $nxt->setShortname($row->shortname);
                $nxt->setDescription($row->description);
                $nxt->setDetails($row->details);
                $nxt->setSpecifications($row->specifications);
                $nxt->setSearchResultImgId($row->searchResultImgId);
                $nxt->setSpotlightImgId($row->spotlightImgId);
                $nxt->setBasketImgId($row->basketImgId);
                $nxt->setAvailability($row->availability);
                $nxt->setPrice($row->price);
                $nxt->setDiscount($row->discount);
                $nxt->setIsCheckoutItem($row->ischeckoutitem);
                $nxt->setProductCode($row->productcode);
                $result->insertLast($nxt);
            }
	}

	return $result;

}
function getProductBrowseItmesBySpecs($catid, $specinstances)
{
        $result = new LinkList();
        
        $specinstance_arr = $specinstances;
	
        if(count($specinstance_arr) <= 0)
        {
            return $result;// empty list
        }
        
        
	$sql = "SELECT DISTINCT id FROM browseItems WHERE catid = $catid ";
        $filters = "";
        for($i=0; $i < count($specinstance_arr); $i++)    
        {
            $filters .= "select distinct baseid from productSpecMappings m where ";
            $filters .= "( m.specinstanceid = '".$specinstance_arr[$i]."')";//TODO: change this on condition specType (text/numeric)
            if($i < count($specinstance_arr)-1)
            {
                $filters .= " AND baseid IN ("    ;            
            }
            
        }
        
        if(count($specinstance_arr) > 0)
        {
            $sql .= "AND productbaseid IN (".$filters;
            for($i=0; $i < count($specinstance_arr); $i++)    
            {
                $sql .= ")";
            }
        }
        $sql .= ";";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getBrowseItemById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;

}
function getProductBasesBySpecs($specinstances)
{
        $result = new LinkList();
        
        $specinstance_arr = $specinstances;
	
        if(count($specinstance_arr) <= 0)
        {
            return $result;// empty list
        }
        
        
	$sql = "SELECT DISTINCT id FROM productBases  ";
        $filters = "";
        for($i=0; $i < count($specinstance_arr); $i++)    
        {
            $filters .= "select distinct baseid from productSpecMappings m where ";
            $filters .= "( m.specinstanceid = '".$specinstance_arr[$i]."')";//TODO: change this on condition specType (text/numeric)
            if($i < count($specinstance_arr)-1)
            {
                $filters .= " AND baseid IN ("    ;            
            }
            
        }
        
        if(count($specinstance_arr) > 0)
        {
            $sql .= "WHERE id IN (".$filters;
            for($i=0; $i < count($specinstance_arr); $i++)    
            {
                $sql .= ")";
            }
        }
        $sql .= ";";
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductBaseById($row->id);
                $result->insertLast($nxt);
            }
	}

	return $result;

}

function getProductFiltersByProductList($productList)
{
        $result = new LinkList();
        if(count($productList) <= 0)
        {
            return $result;// empty list
        }
        $productBaseIds = array();
        for($i=1; $i <= $productList->totalNodes(); $i++)   
        {
            $nxtProductBase = $productList->readNode($i);
            $productBaseIds[$i] = $nxtProductBase->getId();
        }
        $productListStr = implode(',',$productBaseIds);
	$sql = "select productFilters.id, productFilters.filtername, productFilters.filtervalue
                from productFilters
                join productBases on productFilters.productcode = productBases.productcode
                where productBases.id in ($productListStr)
                order by productFilters.filtername, productFilters.filtervalue
                ";
        
                
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = new ProductFilter();
                $nxt->setId($row->id);
                $nxt->setFilterName($row->filtername);
                $nxt->setFilterValue($row->filtervalue);
                $result->insertLast($nxt);
            }
	}

	return $result;

}
function getDistinctOrderedProductInstancesByBrowseItems($browseItemList)
{
        $result = new LinkList();
	
	$sql = "SELECT DISTINCT specinstanceid FROM productSpecMappings";
        
        
        if(isset($browseItemList) && $browseItemList->totalNodes() > 0)
        {
            $sql .= " WHERE baseid in (";
            for($i=1; $i <= $browseItemList->totalNodes(); $i++)    
            {
                $nxtBrowseItem = $browseItemList->readNode($i);
                $sql .= $nxtBrowseItem->getProductBaseId();
                if($i < $browseItemList->totalNodes()){ $sql .= ",";}
            }
            
            $sql .= " ) order by specid,specinstanceid;";
        }
                
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductSpecInstanceById($row->specinstanceid);
                $result->insertLast($nxt);
            }
	}

	return $result;

}
function getDistinctOrderedProductInstancesByProductBases($productList)
{
        $result = new LinkList();
	
	$sql = "SELECT DISTINCT specinstanceid FROM productSpecMappings";
        
        
        if(isset($productList) && $productList->totalNodes() > 0)
        {
            $sql .= " WHERE baseid in (";
            for($i=1; $i <= $productList->totalNodes(); $i++)    
            {
                $nxtBase = $productList->readNode($i);
                $sql .= $nxtBase->getId();
                if($i < $productList->totalNodes()){ $sql .= ",";}
            }
            
            $sql .= " ) order by specid,specinstanceid;";
        }
                
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductSpecInstanceById($row->specinstanceid);
                $result->insertLast($nxt);
            }
	}

	return $result;

}
function getDistinctProductSpecsByProductBases($productList)
{
        $result = new LinkList();
	
	$sql = "SELECT DISTINCT specid FROM productSpecMappings";
        
        
        if(isset($productList) && $productList->totalNodes() > 0)
        {
            $sql .= " WHERE baseid in (";
            for($i=1; $i <= $productList->totalNodes(); $i++)    
            {
                $nxtBase = $productList->readNode($i);
                $sql .= $nxtBase->getId();
                if($i < $productList->totalNodes()){ $sql .= ",";}
            }
            
            $sql .= " )";
        }
                
        
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductSpecById($row->specid);
                $result->insertLast($nxt);
            }
	}

	return $result;

}
function getDistinctProductSpecsByCatId($catId)
{
        $result = new LinkList();
	
	$sql = "SELECT DISTINCT m.specid FROM productBases as b JOIN productSpecMappings AS m ON b.id = m.baseid WHERE b.catid=$catId;";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductSpecById($row->specid);
                $result->insertLast($nxt);
            }
	}

	return $result;

}

function getProductSpecs()
{
        $result = new LinkList();	
	$sql = "SELECT * FROM productSpecs;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $nxt = getProductSpecById($row->id);    
                $result->insertLast($nxt);
            }
	}
	return $result;
}

function getProductSpecById($specId)
{
	
	$sql = "SELECT * FROM productSpecs WHERE id=$specId;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $result = new ProductSpec();
            $result->setId($row->id);
            $result->setName($row->name);
            $result->setType($row->type);
            $result->setDim($row->dim);
            return $result;

	}

        $result = new ProductSpec();
        $result->setId(0);
	return $result;

}
function getProductInstancesBySpecIdAndProductBases($specId, $productList)
{
        $result = new LinkList();
	
	$sql = "SELECT DISTINCT specinstanceid FROM productSpecMappings WHERE specid=$specId ";
        
        if(isset($productList) && $productList->totalNodes() > 0)
        {
            $sql .= " AND baseid in (";
            for($i=1; $i <= $productList->totalNodes(); $i++)    
            {
                $nxtBase = $productList->readNode($i);
                $sql .= $nxtBase->getId();
                if($i < $productList->totalNodes()){ $sql .= ",";}
            }
            
            $sql .= " )";
        }
                
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
            
                $nxt = getProductSpecInstanceById($row->specinstanceid);
                $result->insertLast($nxt);
            }
	}

	return $result;

}

function deleteProductBase($baseid)
{
    //TODO: requests & requestItems?
        
    //$sql = "delete from productReviews where productid = $baseid;";
    //if(executeNonQuery($sql))
    //{
        $sql = "delete from productBases where id = $baseid;";
        if(executeNonQuery($sql))
        {
            logEntry(StateMgr::logDebug,"productBase deleted, id = $baseid");
            return true;
        }
    //}
    logEntry(StateMgr::logWarning,"productBase delete failed, id = $baseid");
    return false;
}

function updateProductBase($userid, $cat, $productId, $name, $shortname, $desc, $details,$searchImgId,$spotlightImgId,$basketImgId,$availability,$isCheckoutItem,$productCode,$listPrice,$discount)
{
    
    //EDIT#201309291331:img updates are currently disabled
    
    $sql="UPDATE productBases SET 
            catid = $cat,name = '$name',shortname = '$shortname',description = '$desc',
            details = '$details',availability = '$availability', ischeckoutitem = $isCheckoutItem,
            productcode = '$productCode', price = $listPrice, discount = $discount
            WHERE id = $productId";
    
    /*
     * $sql="UPDATE productBases SET 
            catid = $cat,name = '$name',shortname = '$shortname',description = '$desc',
            details = '$details',searchResultImgId = $searchImgId,spotlightImgId = $spotlightImgId,
            basketImgId = $basketImgId,availability = '$availability', ischeckoutitem = $isCheckoutItem
            WHERE id = $productId";
     */
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productBases updated, id = $productId");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"productBases update failed, id = $productId");
    return false;
}
function addProductBase($userid, $cat, $name, $shortname, $desc, $details,$searchImgId,$spotlightImgId,$basketImgId,$availability,$productCode,$listPrice,$discount,$checkoutable,$metaTags)
{
    
    //EDIT#201309291331:img updates are currently disabled
    $sql="INSERT INTO productBases (catid,name,shortname,description,details,availability,productCode,price,discount,ischeckoutitem,metatags)
            values ($cat,'$name','$shortname','$desc','$details','$availability','$productCode',$listPrice,$discount,$checkoutable,'$metaTags');";
    /*
    $sql="INSERT INTO productBases (catid,name,shortname,description,details,searchResultImgId,spotlightImgId,basketImgId,availability)
            values ($cat,'$name','$shortname','$desc','$details',$searchImgId,$spotlightImgId,$basketImgId,'$availability');";
    */    
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"productBases added, catid = $cat, name = $name");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"productBases add failed, catid = $cat, name = $name");
    return false;
}

/*
function getDocumentationTypeById($id)
{
    $sql="SELECT name FROM productDocumentationType WHERE id=$id;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->name;
    }

    return "";

}
function getTargetById($id)
{
	$sql="SELECT * FROM targets WHERE id=$id;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            $result = new Target();
            $result->setId($row->id);
            $result->setTarget($row->target);
            $result->setTargetType($row->targettype);
            return $result;
	}
	$result = new Target();
        $result->setId(0);
	return $result;
}
function removeTargetById($user_id, $id)
{
    $sql="DELETE FROM targets WHERE id=$id;";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"target deleted, id = $id");
        return true;
    }
    
    logEntry(StateMgr::logWarning,"target delete failed, id = $id");
    return false;
}
function addTarget($user_id, $target, $targetType)
{	
    $sql="INSERT INTO targets (target, targettype) VALUES ($target, $targetType);";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"target added, target = $target");
        return true;
    }
    logEntry(StateMgr::logWarning,"target add failed, target = $target");
    return false;
}

function addDocumentation($user_id, $baseid, $targetid)
{
    $sql="INSERT INTO productDocumentation (baseid, targetid) VALUES ($baseid, $targetid);";
    
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"documentation added, baseid = $baseid & targetid = $targetid");
        return true;
    }
    logEntry(StateMgr::logWarning,"documentation add failed, baseid = $baseid & targetid = $targetid");
    return false;
}
function removeDocumentationById($user_id, $docid)
{
    $sql="DELETE FROM productDocumentation WHERE id = $docid;";
    
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"documentation removed, id = ".$docid);
        return true;
    }

    logEntry(StateMgr::logWarning,"documentation removal failed, id = ".$docid);
    return false;
}
function getDocumentByBaseId($baseId)
{
        $result = new LinkList();
	
	$sql = "SELECT * FROM productDocumentation WHERE baseid=$baseId;";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $doc = new ProductDocumentation();
                
                $doc->setId($row->id);
                $doc->setBaseId($row->baseid);
                $doc->setTargetId($row->targetid);
                
                $result->insertLast($doc);
            }
	}

	return $result;

}
function getDocumentsByTargetId($targetId)
{
        $result = new LinkList();
	
	$sql = "SELECT * FROM productDocumentation WHERE targetid=$targetId;";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $doc = new ProductDocumentation();
                
                $doc->setId($row->id);
                $doc->setBaseId($row->baseid);
                $doc->setTargetId($row->targetid);
                
                $result->insertLast($doc);
            }
	}

	return $result;

}
*/
function getDocumentsByProductCode($productCode)
{
    $result = new LinkList();
	
    $fileDir = "./files/$productCode/";
    $files = scandir($fileDir);
    
    foreach($files as $nxtFile)
    {
        if(!is_dir($nxtFile))
        {
            $pathinfo = pathinfo($nxtFile);
            if($pathinfo['extension'] == 'pdf')
            {
                $result->insertLast($nxtFile);
            }
        }
    }
    return $result;

}
function getCategoryById($catid)
{
	$sql = "SELECT * FROM productCategories WHERE id = $catid;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            
            $result = new ProductCategory();
            $result->setId($row->id);
            $result->setName($row->name);
            $result->setShortname($row->shortname);
            $result->setImgId($row->imgid);

            return $result;
	}

        $result = new ProductCategory();
        $result->setId(0);
        $result->setName("UNKNOWN");
        $result->setShortname("UNKNOWN");
        $result->setImgId(0);
	
	return $result;

}
function getCategories()
{
        $result = new LinkList();
	
	$sql = "SELECT id FROM productCategories;";  
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $cat = getCategoryById($row->id);
                
                $result->insertLast($cat);
            }
	}

	return $result;

}

function getProductBaseByCode($code)
{
	$sql="SELECT * FROM productBases WHERE productcode = '$code';";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            
            $result = new ProductBase();
            $result->setId($row->id);
            $result->setCatId($row->catid);
            $result->setName($row->name);
            $result->setShortname($row->shortname);
            $result->setDescription($row->description);
            $result->setDetails($row->details);
            $result->setSpecifications($row->specifications);
            $result->setSearchResultImgId($row->searchResultImgId);
            $result->setSpotlightImgId($row->spotlightImgId);
            $result->setBasketImgId($row->basketImgId);
            $result->setAvailability($row->availability);
            $result->setPrice($row->price);
            $result->setDiscount($row->discount);
            $result->setIsCheckoutItem($row->ischeckoutitem);
            $result->setProductCode($row->productcode);
            $result->setMetaTags($row->metatags);
            return $result;
	}

	$result = new ProductBase();
        $result->setId(0);
	return $result;
}

function getProductBaseById($baseId)
{
	$sql="SELECT * FROM productBases WHERE id = $baseId;";
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            
            $result = new ProductBase();
            $result->setId($row->id);
            $result->setCatId($row->catid);
            $result->setName($row->name);
            $result->setShortname($row->shortname);
            $result->setDescription($row->description);
            $result->setDetails($row->details);
            $result->setSpecifications($row->specifications);
            $result->setSearchResultImgId($row->searchResultImgId);
            $result->setSpotlightImgId($row->spotlightImgId);
            $result->setBasketImgId($row->basketImgId);
            $result->setAvailability($row->availability);
            $result->setPrice($row->price);
            $result->setDiscount($row->discount);
            $result->setIsCheckoutItem($row->ischeckoutitem);
            $result->setProductCode($row->productcode);
            $result->setMetaTags($row->metatags);
            return $result;
	}

	$result = new ProductBase();
        $result->setId(0);
	return $result;
}
function getProductBasesByCatId($catid)
{
	$result = new LinkList();
	
	$sql="SELECT * FROM productBases WHERE catid = $catid;";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $productBase = new ProductBase();
                $productBase->setId($row->id);
                $productBase->setCatId($row->catid);
                $productBase->setName($row->name);
                $productBase->setShortname($row->shortname);
                $productBase->setDescription($row->description);
                $productBase->setDetails($row->details);
                $productBase->setSpecifications($row->specifications);
                $productBase->setSearchResultImgId($row->searchResultImgId);
                $productBase->setSpotlightImgId($row->spotlightImgId);
                $productBase->setBasketImgId($row->basketImgId);
                $productBase->setAvailability($row->availability);
                $productBase->setPrice($row->price);
                $productBase->setDiscount($row->discount);
                $productBase->setIsCheckoutItem($row->ischeckoutitem);
                $productBase->setProductCode($row->productcode);
                $productBase->setMetaTags($row->metatags);
                
                $result->insertLast($productBase);
            }
	}

	return $result;

}
function getCheckoutProductBases()
{
	$result = new LinkList();
	
	$sql="SELECT * FROM productBases WHERE ischeckoutitem = 1;";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $productBase = getProductBaseById($row->id);
                $result->insertLast($productBase);
            }
	}

	return $result;

}
/*
function addImage($userid, $src, $alt, $width, $height)
{
    $sql="INSERT INTO images (src,alt,width,height) values ('$src','$alt',$width,$height);";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"image added, src = ".$src);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"image add failed, src = ".$src);
    return false;
}



function getImageIdBySrc($src)
{
    $sql="SELECT id FROM images WHERE src = '$src';";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->id;
    }
    return 0;
}


function getImagesBySize($width, $height)
{
    $result = new LinkList();

    $sql="SELECT * FROM images WHERE width = $width AND height = $height;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $image = getImageByImageId($row->id);                
		$result->insertLast($image);
        }
    }

    return $result;

}

function getImageSetByImgId($id)
{
    $result = new LinkList();

    $image = getImageByImageId($id);
    if($image->getId()>0)
    {
        $imageBasename = basename($image->getSrc());

        $sql="SELECT * FROM images WHERE src like '%$imageBasename';";

        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $image = getImageByImageId($row->id);                
		$result->insertLast($image);
            }
        }
    }
    return $result;
}

function getImagesByFolder($folder)
{
	$result = new LinkList();
	
	$sql="SELECT * FROM images WHERE src like '%/$folder/%' AND src NOT LIKE '%aspectratio/%';";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $image = getImageByImageId($row->id);                
		$result->insertLast($image);
            }
	}
	return $result;
}
function getImagesBySizeAndFolder($width, $height, $folder)
{
	$result = new LinkList();
	
	$sql="SELECT * FROM images WHERE width = $width AND height = $height AND src like '%$folder%' AND src NOT LIKE '%aspectratio/%';";
	
        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                $image = getImageByImageId($row->id);                
		$result->insertLast($image);
            }
	}
	return $result;
}

function getAnyImageByImageId($imageid, $altWidth, $altHeight)
{
	
    $sql="SELECT * FROM images WHERE id = $imageid;";
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        $image = getImageByImageId($row->id); 
        return $image;
    }
    
    $result = get404Image($altWidth, $altHeight);
    if($result->getId() <= 0)
    {
        $result = new Image();
        $result->setId(0);  
    }

    return $result; 
}

function getImages()
{
    $result = new LinkList();

    $sql="SELECT * FROM images;";

    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
                $image = getImageByImageId($row->id);                
		$result->insertLast($image);
        }
    }

    return $result;

}


function removeImageById($userid, $id)
{
    $sql="DELETE FROM images WHERE id = $id;";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"image deleted, id = ".$id);
        return true;
    }
    logEntry(StateMgr::logWarning,"image delete failed, id = ".$id);    
    return false;
}
function getPublicTargets()
{
    $result = new LinkList();

    $sql="SELECT * FROM targets WHERE targettype <= 5;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $target = new Target();
            $target->setId($row->id);
            $target->setTarget($row->target);
            $target->setTargetType($row->targettype);

            $result->insertLast($target);
        }
    }

    return $result;
}
function getPublicTargetsInFolder($folder)
{
    $result = new LinkList();

    $sql="SELECT * FROM targets WHERE targettype <= 5 AND target like '%/$folder/%';";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $target = new Target();
            $target->setId($row->id);
            $target->setTarget($row->target);
            $target->setTargetType($row->targettype);

            $result->insertLast($target);
        }
    }
    return $result;
}


*/
function getBestImageByProductCode($productCode,$altWidth, $altHeight)
{
    $result = new Image();
    $result->setId(0);  
    $result->setWidth(0);
    $result->setHeight(0);
    $fileDir = "./files/$productCode/";
    $files = scandir($fileDir);
    
    //find exact height with best ratio
    //find close height (+-10%) with best ratio
    
    $exactHeightMatches = array();
    $exactWidthMatches = array();
    $closeHeightMatches = array();
    $closeWidthMatches = array();
    
    foreach($files as $nxtFile)
    {
        if(!is_dir($fileDir.$nxtFile) && file_exists($fileDir.$nxtFile))
        {
            $imageInfo = getimagesize($fileDir.$nxtFile);
            if($imageInfo)
            {
                if(abs($imageInfo[1] - $altHeight) < $altHeight*0.1)
                {
                    $match = new Image();
                    $match->setId(0);  
                    $match->setSrc($fileDir.$nxtFile);
                    $match->setWidth($imageInfo[0]);
                    $match->setHeight($imageInfo[1]);
                    
                    array_push($closeHeightMatches,$match);
                    if($imageInfo[1] == $altHeight)
                    {
                        array_push($exactHeightMatches,$match);
                    }
                }
                if(abs($imageInfo[0] - $altWidth) < $altWidth*0.1)
                {
                    $match = new Image();
                    $match->setId(0);  
                    $match->setSrc($fileDir.$nxtFile);
                    $match->setWidth($imageInfo[0]);
                    $match->setHeight($imageInfo[1]);
                    
                    array_push($closeWidthMatches,$match);
                    if($imageInfo[0] == $altWidth)
                    {
                        array_push($exactWidthMatches,$match);
                    }
                }
            }
        }
    }
    
    if(count($exactWidthMatches)>0)
    {
        //return one with best ratio
        foreach($exactWidthMatches as $nxtImage){
            if(!isset($bestYet)){$bestYet = $nxtImage;}
            if(abs(($bestYet->getWidth()/$bestYet->getHeight()) - ($altWidth/$altHeight)) < abs(($nxtImage->getWidth()/$nxtImage->getHeight()) - ($altWidth/$altHeight)))
            {
                $bestYet = $nxtImage;
            }
        }
        return $bestYet;
    }
    
    if(count($exactHeightMatches)>0)
    {
        //return one with best ratio
        foreach($exactHeightMatches as $nxtImage){
            if(!isset($bestYet)){$bestYet = $nxtImage;}
            if(abs(($bestYet->getWidth()/$bestYet->getHeight()) - ($altWidth/$altHeight)) < abs(($nxtImage->getWidth()/$nxtImage->getHeight()) - ($altWidth/$altHeight)))
            {
                $bestYet = $nxtImage;
            }
        }
        return $bestYet;
    }
    if(count($closeWidthMatches)>0)
    {
        //return one with best ratio
        foreach($closeWidthMatches as $nxtImage){
            if(!isset($bestYet)){$bestYet = $nxtImage;}
            if(abs(($bestYet->getWidth()/$bestYet->getHeight()) - ($altWidth/$altHeight)) < abs(($nxtImage->getWidth()/$nxtImage->getHeight()) - ($altWidth/$altHeight)))
            {
                $bestYet = $nxtImage;
            }
        }
        return $bestYet;
    }
    if(count($closeHeightMatches)>0)
    {
        //return one with best ratio
        foreach($closeHeightMatches as $nxtImage){
            if(!isset($bestYet)){$bestYet = $nxtImage;}
            if(abs(($bestYet->getWidth()/$bestYet->getHeight()) - ($altWidth/$altHeight)) < abs(($nxtImage->getWidth()/$nxtImage->getHeight()) - ($altWidth/$altHeight)))
            {
                $bestYet = $nxtImage;
            }
        }
        return $bestYet;
    }
    
    $result = get404Image($altWidth, $altHeight);
    if($result->getId() <= 0)
    {
        $result = new Image();
        $result->setId(0);  
    }

    return $result; 
}
//TODO: consider sql simplification
function get404Image($width, $height)
{
	
    $sql="SELECT * FROM images WHERE src like '%aspect%404-not-found%' AND width = $width AND height = $height LIMIT 1;";
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        $result = new Image();
        
        return getImageByImageId($row->id);  
    }
    
    $result = new Image();
    $result->setId(0);
    return $result;
    
    
    
}

function getImageByImageId($imageid)
{
	
    $sql="SELECT * FROM images WHERE id = $imageid;";
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        $result = new Image();
        $result->setId($row->id);
        $result->setSrc($row->src);
        $result->setAlt($row->alt);
        $result->setWidth($row->width);
        $result->setHeight($row->height);
        return $result;
    }
    
    $result = new Image();
    $result->setId(0);
    return $result;
}

function sendMail($toAddr, $subject, $fromAddr, $message)
{
    
    $result = false;
    
    try{

        $headers = "From: ".$fromAddr;
        
        $message = $message."\n\n\n".MailString::emailConfidential;
        
        mail($toAddr,$subject,$message,$headers);
        
        $result = true;
    }
    catch(Exception $e)
    {
        
        $result = false;

    }
    
    return $result;
    
}


function removeQuoteRequestItemsByRequest($requestid)
{
    $sql="DELETE FROM quoteRequestItems WHERE quoterequestid = $requestid;";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"QuoteRequestItems removed, requestid = ".$requestid);
        return true;
    }    
    logEntry(StateMgr::logWarning,"QuoteRequestItems removal failed, requestid = ".$requestid);
    return false;
}
function removeRequestsByUser($userid)
{
        $sql="SELECT id FROM requests WHERE userid = $userid;";
        
        $query_result = getDataSet($sql);

        $result = $query_result;
        
        if($query_result && $query_result->num_rows > 0)
        {
            while($row = $query_result->fetch_object())
            {
                if(!removeQuoteRequestItemsByRequest($row->id))
                {
                    $result = false;
                }
            }
        }
        
        if($result)
        {
            $sql="DELETE FROM requests WHERE userid = $userid;";
            if(executeNonQuery($sql))
            {
                logEntry(StateMgr::logDebug,"user requests removed, id = ".$userid);
                return true;
            }    
        }
        logEntry(StateMgr::logWarning,"user requests removal failed, id = ".$userid);
        return false;
}
function removeUser($userid)
{
    if(removeRequestsByUser($userid))
    {
        $sql="DELETE FROM user WHERE userid = $userid;";
        if(executeNonQuery($sql))
        {
            logEntry(StateMgr::logDebug,"user removed, id = ".$userid);
            return true;
        }    
    }
    logEntry(StateMgr::logWarning,"user removal failed, id = ".$userid);
    return false;
}
function updateUserTradeAcc($tradeAcc,$userid)
{
    $sql = "UPDATE user SET tradeaccount = $tradeAcc WHERE userid = $userid";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user tradeaccount updated, id = ".$userid);
        return true;
    }

    logEntry(StateMgr::logWarning,"user tradeaccount update failed, id = ".$userid);
    return false;
}
function updateUserState($userState,$userid)
{
    $sql = "UPDATE user SET userState = $userState WHERE userid = $userid";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user state updated, id = ".$userid);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user state update failed, id = ".$userid);
    return false;
    
}
function updateUserVAT($vatRate,$userid)
{
    $sql = "UPDATE user SET vatrate = $vatRate WHERE userid = $userid";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user VAT updated, id = ".$userid);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user VAT update failed, id = ".$userid);
    return false;
    
}
function updateUserDiscount($discount,$userid)
{
    $sql = "UPDATE user SET discount = $discount WHERE userid = $userid";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user discount updated, id = ".$userid);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user discount update failed, id = ".$userid);
    return false;
    
}
function updateSecurityDetails($user_id,$user_password)
{
    $user_password = hash('sha256', $user_password);

    $sql  = "UPDATE user SET ";
    $sql .= " password = '$user_password' ";
    $sql .= " WHERE userid = $user_id;";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user security details updated, id = ".$user_id);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user security details update failed, id = ".$user_id);
    return false;
}
function createBillingDetails($user_id)
{
    $sql  = "INSERT INTO userAddresses (userid) VALUES ($user_id); ";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user billing details updated, userid = ".$user_id);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user billing details update failed, userid = ".$user_id);
    return false;
}
function updateBillingDetails($user_id,$addr_id, $user_billingaddr1,$user_billingaddr2, $user_county, $user_postcode,$user_country)
{
    //encrypt some
    $user_billingaddr1 = cryptIt($user_billingaddr1);
    $user_billingaddr2 = cryptIt($user_billingaddr2);
    $user_county = cryptIt($user_county);
    $user_postcode = cryptIt($user_postcode);
    $user_country = cryptIt($user_country);

    $sql  = "UPDATE userAddresses SET ";
    $sql .= " billingaddr1 = AES_ENCRYPT('$user_billingaddr1','".KeyRing::MySQLAESKey."'), ";
    $sql .= " billingaddr2 = AES_ENCRYPT('$user_billingaddr2','".KeyRing::MySQLAESKey."'), ";
    $sql .= " county = AES_ENCRYPT('$user_county','".KeyRing::MySQLAESKey."'), ";
    $sql .= " country = AES_ENCRYPT('$user_country','".KeyRing::MySQLAESKey."'), ";
    $sql .= " postcode = AES_ENCRYPT('$user_postcode','".KeyRing::MySQLAESKey."') ";
    $sql .= " WHERE userid = $user_id AND id = $addr_id;";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user billing details updated, userid/id = ".$addr_id."/".$user_id);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user billing details update failed, userid/id = ".$addr_id."/".$user_id);
    return false;
    
}
function deleteBillingDetails($user_id,$addr_id)
{
    $sql  = "DELETE FROM userAddresses WHERE userid = $user_id AND id = $addr_id; ";
        
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user billing details updated, userid/id = ".$addr_id."/".$user_id);
        return true;
    }
    
    logEntry(StateMgr::logWarning,"user billing details update failed, userid/id = ".$addr_id."/".$user_id);
    return false;
}
function updateUserDetails($user_id,$user_title,$user_firstname,$user_lastname,$user_billingphoneno,$user_contactphoneno,$user_email,$user_newslettersubscribe)
{
    //encrypt some
    $user_firstname = cryptIt($user_firstname);
    $user_lastname = cryptIt($user_lastname);
    $user_billingphoneno = cryptIt($user_billingphoneno);
    $user_contactphoneno = cryptIt($user_contactphoneno);
    $user_email = cryptIt($user_email);

    $sql  = "UPDATE user ";
    $sql .= " SET title = '$user_title', ";
    $sql .= " firstname = AES_ENCRYPT('$user_firstname','".KeyRing::MySQLAESKey."'), ";
    $sql .= " lastname = AES_ENCRYPT('$user_lastname','".KeyRing::MySQLAESKey."'), ";
    $sql .= " billingphoneno = AES_ENCRYPT('$user_billingphoneno','".KeyRing::MySQLAESKey."'), ";
    $sql .= " contactphoneno = AES_ENCRYPT('$user_contactphoneno','".KeyRing::MySQLAESKey."'), ";
    $sql .= " email = AES_ENCRYPT('$user_email','".KeyRing::MySQLAESKey."'), ";
    $sql .= " newslettersubscribe = $user_newslettersubscribe ";
    $sql .= " WHERE userid = $user_id;";

    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user details updated, id = ".$user_id);
        return true;
    }
    logEntry(StateMgr::logWarning,"user details update failed, id = ".$user_id);
    return false;
}
function addUser($user_title,$user_firstname,$user_lastname,$user_contactphoneno,$user_email,$user_password,$userState) 
{
    
    //encrypt some
    $user_firstname = cryptIt($user_firstname);
    $user_lastname = cryptIt($user_lastname);
    $user_contactphoneno = cryptIt($user_contactphoneno);
    $user_email = cryptIt($user_email);
    //hash others
    $user_password = hash('sha256', $user_password);

    $sql  = "INSERT INTO user ";
    $sql .= "(title, firstname, lastname, contactphoneno, email,";
    $sql .= " password,  newslettersubscribe,userState)";
    $sql .= " VALUES ";
    $sql .= "( ";
    $sql .= " '$user_title', ";
    $sql .= " AES_ENCRYPT('$user_firstname','".KeyRing::MySQLAESKey."'), ";
    $sql .= " AES_ENCRYPT('$user_lastname','".KeyRing::MySQLAESKey."'), ";
    $sql .= " AES_ENCRYPT('$user_contactphoneno','".KeyRing::MySQLAESKey."'), ";
    $sql .= " AES_ENCRYPT('$user_email','".KeyRing::MySQLAESKey."'), ";
    $sql .= " '$user_password', ";
    $sql .= " 1 ,";
    $sql .= "$userState);";

    if(executeNonQuery($sql))
    {

        $sql = "SELECT userid FROM user WHERE '$user_firstname' = AES_DECRYPT(firstname, '".KeyRing::MySQLAESKey."') AND '$user_lastname' = AES_DECRYPT(lastname, '".KeyRing::MySQLAESKey."');";

        $query_result = getDataSet($sql);

        if($query_result && $query_result->num_rows > 0)
        {
            $row = $query_result->fetch_object();
            logEntry(StateMgr::logInfo,"new user added, id = ".$row->userid);
            return true;                
        }
    }
            
    logEntry(StateMgr::logSevere,"Failed to add new user, email = $user_email");
    return false;
}

function updateUserPassword($userid, $password)
{
    $sql="UPDATE user SET password = '$password' WHERE userid = $userid;";
    if(executeNonQuery($sql))
    {
        logEntry(StateMgr::logDebug,"user password updated, userid = $userid");
        return true;
    }
    logEntry(StateMgr::logWarning,"user password update failed, userid = $userid");
    return false;
}

function getUserIdByEmail($email)
{
    $email = cryptIt($email);
    $sql="SELECT userid FROM user WHERE AES_DECRYPT(email, '".KeyRing::MySQLAESKey."') = '$email' ;";   

    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->userid;
    }
    
    return 0;
}

function getUserId($email, $passwordhash)
{
    $email = cryptIt($email);
    $sql="SELECT userid FROM user WHERE AES_DECRYPT(email, '".KeyRing::MySQLAESKey."') = '$email' AND password = '$passwordhash'";

    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->userid;
    }
    
    return 0;
}
function getUser($email, $password)
{
    $email = cryptIt($email);
    $passwordhash = hash('sha256', $password);

    $sql="SELECT userid FROM user WHERE AES_DECRYPT(email, '".KeyRing::MySQLAESKey."') = '$email' AND password = '$passwordhash'";
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        
        return getUserById($row->userid);
    }
    
    $result = new User();
    $result->setUserId(0);
    return $result;    
}
function getAllUsers()
{
    $result = new LinkList();
    
    $sql="SELECT userid FROM user;";
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxtUser = getUserById($row->userid);
            $result->insertLast($nxtUser);
        }
    }

    return $result;

}
function getAllUsersOrderByState()
{
    $result = new LinkList();
    
    $sql="SELECT userid FROM user ORDER BY userState ASC;";
 
    $query_result = getDataSet($sql);

    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxtUser = getUserById($row->userid);
            $result->insertLast($nxtUser);
        }
    }

    return $result;

}

function getUserNameById($userid)
{
    $sql = "SELECT  userid,";
    $sql .= " title, ";
    $sql .= " AES_DECRYPT(firstname,'".KeyRing::MySQLAESKey."') as firstname, ";
    $sql .= " AES_DECRYPT(lastname,'".KeyRing::MySQLAESKey."') as lastname ";
    $sql .= " FROM user WHERE userid = $userid;";
    //echo $sql;
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->title." ".decryptIt($row->firstname)." ".decryptIt($row->lastname);
    }
    return "";
    
}
function getUserById($userid)
{

    $sql = "SELECT  userid,";
    $sql .= " title, ";
    $sql .= " AES_DECRYPT(firstname,'".KeyRing::MySQLAESKey."') as firstname, ";
    $sql .= " AES_DECRYPT(lastname,'".KeyRing::MySQLAESKey."') as lastname, ";
    $sql .= " AES_DECRYPT(billingphoneno,'".KeyRing::MySQLAESKey."') as billingphoneno, ";
    $sql .= " AES_DECRYPT(contactphoneno,'".KeyRing::MySQLAESKey."') as contactphoneno, ";
    $sql .= " AES_DECRYPT(email,'".KeyRing::MySQLAESKey."') as email, ";
    $sql .= " tradeaccount, ";
    $sql .= " password, ";
    $sql .= " newslettersubscribe, ";
    $sql .= " userState, ";
    $sql .= " vatrate, ";
    $sql .= " discount ";
    $sql .= "  FROM user WHERE userid = $userid;";
    //echo $sql;
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        $result = new User();

        $result->setUserId($row->userid);
        $result->setTitle($row->title);
        $result->setFirstname(decryptIt($row->firstname));
        $result->setLastname(decryptIt($row->lastname));
        $result->setBillingPhoneNo(decryptIt($row->billingphoneno));
        $result->setContactPhoneNo(decryptIt($row->contactphoneno));
        $result->setEmail(decryptIt($row->email));
        $result->setTradeAccount($row->tradeaccount);
        //$result->setPassword($row->password);
        $result->setNewsletterSubscribe($row->newslettersubscribe);
        $result->setUserState($row->userState);
        $result->setVatRate($row->vatrate);
        $result->setDiscount($row->discount);
        
        return $result;
    }
    
    $result = new User();
    $result->setUserId(0);
    return $result;
    
}

function getUserAddressesByUserId($userid)
{
    $result = new LinkList();

    $sql = "SELECT id, userid,";
    $sql .= " AES_DECRYPT(billingaddr1,'".KeyRing::MySQLAESKey."') as billingaddr1, ";
    $sql .= " AES_DECRYPT(billingaddr2,'".KeyRing::MySQLAESKey."') as billingaddr2, ";
    $sql .= " AES_DECRYPT(county,'".KeyRing::MySQLAESKey."') as county, ";
    $sql .= " AES_DECRYPT(postcode,'".KeyRing::MySQLAESKey."') as postcode, ";
    $sql .= " AES_DECRYPT(country,'".KeyRing::MySQLAESKey."') as country ";
    $sql .= "  FROM userAddresses WHERE userid = $userid;";
    //echo $sql;
    
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        while($row = $query_result->fetch_object())
        {
            $nxtAddr = new UserAddress();

            $nxtAddr->setId($row->id);
            $nxtAddr->setUserId($row->userid);
            $nxtAddr->setBillingAddr1(decryptIt($row->billingaddr1));
            $nxtAddr->setBillingAddr2(decryptIt($row->billingaddr2));
            $nxtAddr->setCounty(decryptIt($row->county));
            $nxtAddr->setCountry(decryptIt($row->country));
            $nxtAddr->setPostcode(decryptIt($row->postcode));

            $result->insertLast($nxtAddr);
        }
    }

    return $result;   
}
function getMinLogState()
{
    $sql = "SELECT minLogState FROM _systemOptions LIMIT 1;";
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->minLogState;
    }
    return StateMgr::logDebug;
    
}
function getMaxPendingRequestsPerUser()
{
    $sql = "SELECT maxPendingRequestsPerUser FROM _systemOptions LIMIT 1;";
    $query_result = getDataSet($sql);
    
    if($query_result && $query_result->num_rows > 0)
    {
        $row = $query_result->fetch_object();
        return $row->maxPendingRequestsPerUser;
    }
    return 5;
    
}

function logEntry($state, $desc)
{
    if($state >= getMinLogState())
    {
        $userid = 0;
        if(isset($_SESSION['userid']))
        {
            $userid = $_SESSION['userid'];
        }
        $sql="INSERT INTO _logs (time, userid, state, description) values (NOW(), $userid, $state,'$desc');";
        return executeNonQuery($sql);
    }
    return true;
}

function executeNonQuery($sql)
{
    $result = false;
    $mysqli = dbconnecti();
    if($mysqli->query($sql) === true)
    {
        $result = true;
    }
    dbclosei($mysqli);
    return $result;
}
function getDataSet($sql)
{
    $mysqli = dbconnecti();
    $query_result = $mysqli->query($sql);
    dbclosei($mysqli);
    return $query_result;
}


?>
