<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
class State{
    private $status;
    private $code;
    
    function __construct($status, $code) {
        $this->status = $status;
        $this->code = $code;
    }
    
    public function getStatus(){
            return $this->status;
    }

    public function setStatus($status){
            $this->status = $status;
    }
    
    public function getCode(){
            return $this->code;
    }

    public function setCode($code){
            $this->code = $code;
    }
}

abstract class StateMgr {
 
    /* Requests */
    
 const requestFailed = -1;
 const requestPending = 1;
 const requestArchived = 2;
 
 public static function getRequestStates()
 {
     $result = new LinkList();
     $result->insertLast(New State("Failed",-1));
     $result->insertLast(New State("Pending",1));
     $result->insertLast(New State("Archived",2));
     return $result;
 }
 public static function getRequestStatus($state)
 {
     if($state == StateMgr::requestFailed)
         return "Failed";
     if($state == StateMgr::requestPending)
         return "Pending";
     if($state == StateMgr::requestArchived)
         return "Archived";
 }
 public static function getRequestStatusRowColor($state)
 {
    switch($state){
        case StateMgr::requestFailed:
            $rowColour = "error";break;
        case StateMgr::requestPending:
            $rowColour = "warning";break;
        case StateMgr::requestArchived:
            $rowColour = "success";break;
        default:
            $rowColour = "";
    }
    return $rowColour;
 }
    /* Quotations */
 
 public static function getQuoteStatus($state)
 {
     if($state == StateMgr::requestFailed)
         return "Failed";
     if($state == StateMgr::requestPending)
         return "Pending";
     if($state == StateMgr::requestArchived)
         return "Archived";
 }
 
 
    /* Users */
    
 const userError = -1;
 const userPending = 1;
 const userApproved = 2;
 const userDeclined = 3;
 
 public static function getUserStates()
 {
     $result = new LinkList();
     $result->insertLast(New State("Error",-1));
     $result->insertLast(New State("Pending",1));
     $result->insertLast(New State("Approved",2));
     $result->insertLast(New State("Declined",3));
     return $result;
 }
 public static function getUserStatus($state)
 {
     if($state == StateMgr::userError)
         return "Error";
     if($state == StateMgr::userPending)
         return "Pending";
     if($state == StateMgr::userApproved)
         return "Approved";
     if($state == StateMgr::userDeclined)
         return "Declined";
 }
 public static function getUserStatusRowColor($state)
 {
    switch($state){
        case StateMgr::userError:
            $rowColour = "error";break;
        case StateMgr::userPending:
            $rowColour = "warning";break;
        case StateMgr::userApproved:
            $rowColour = "success";break;
        case StateMgr::userDeclined:
            $rowColour = "info";break;
        default:
            $rowColour = "";
    }
    return $rowColour;
 }
 
    /* Log Entries */
    
 const logDebug = 1;
 const logInfo = 2;
 const logWarning = 3;
 const logSevere = 4;
 
 public static function getLogStates()
 {
     $result = new LinkList();
     $result->insertLast(New State("Debug",1));
     $result->insertLast(New State("Info",2));
     $result->insertLast(New State("Warning",3));
     $result->insertLast(New State("Severe",4));
     return $result;
 }
 public static function getLogStatus($state)
 {
     if($state == StateMgr::logDebug)
         return "Debug";
     if($state == StateMgr::logInfo)
         return "Info";
     if($state == StateMgr::logWarning)
         return "Warning";
     if($state == StateMgr::logSevere)
         return "Severe";
 }
 public static function getLogStatusRowColor($state)
 {
    switch($state){
        case StateMgr::logDebug:
            $rowColour = "success";break;
        case StateMgr::logInfo:
            $rowColour = "info";break;
        case StateMgr::logWarning:
            $rowColour = "warning";break;
        case StateMgr::logSevere:
            $rowColour = "error";break;
        default:
            $rowColour = "";
    }
    return $rowColour;
 }
 
}

?>
