<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of Basket
 *
 * @author root
 */
class Basket {
    public $items;


    function Basket() {
        $this->items = new LinkList();
    }
    
function validateBasket()
{
    //is the list well formed?
    //are the counts correct & positive?
    try{
        
        $current = $this->items->firstNode;
        while(true)
        {
            if(is_null($current) && $this->items->totalNodes() == 0)
                return true;
            
            if($current->next == NULL)
                return true;
            else
                $current = $current->next;
        }
            
        
    }catch(Exception $e)
    {
        $specifics = $e->getMessage();
        $specifics .= $e->getTraceAsString();
        logEntry(StateMgr::logSevere,"Exception thrown when validating basket. [$specifics]");
        return false;
    }
    return true;    
}

    function getNbLineItems() {
        return $this->items->totalNodes();
    }

    function getTotalItems() {
        $totalItems=0;
        for($i=1; $i <= $this->items->totalNodes(); $i++)    
        {
            $nxtItem = $this->items->readNode($i);
            $totalItems = $totalItems + $nxtItem->getQty();
        }
        return $totalItems;
    }

    function isEmpty() {
        return ($this->getNbLineItems()==0);
    }

    function itemExists($productCode) {
        $theItem = $this->getItem($productCode);
        return isset($theItem);
    }

    function getItemQty($productCode) {
        $theItem = $this->getItem($productCode);
        return $theItem->getQty();
    }

    function setItemQty($productCode, $qty) {
        if ($qty <= 0 ) {
                $this->removeItem($productCode);
        } else {
            $theItem = $this->getItem($productCode);
            $this->items->deleteNode($theItem);
            $theItem->setQty($qty);
            $this->items->insertLast($theItem);
        }
    }

    function addItem($qty, $productCode) {
        // If item exists, simply add more to it
        if ($this->itemExists($productCode)) {
            $this->setItemQty($productCode, $this->getItemQty($productCode) + $qty);
        } else {
            
            $product = getProductBaseByCode($productCode);
            $this->items->insertLast(new BasketItem($qty,$productCode, $product->getPrice(), $product->getDiscount()));
        }
    }
    
    function getItem($productCode) {
        for($i=1; $i <= $this->items->totalNodes(); $i++)    
        {
            $nxtItem = $this->items->readNode($i);
            if($nxtItem->getProductCode() == $productCode)
            {
                return $nxtItem;
            }
        }
    }

    function removeItem($productCode) {
        if (!$this->isEmpty())	{
            $theItem = $this->getItem($productCode);
            $this->items->deleteNode($theItem);
        };
    }

    function removeAll() {
        $this->items=new LinkList();
    }
    

    //CALCULATIONS
    
    
    
    function calculateBasketSubtotal() {
        $basketSubtotal=0;
        for($i=1; $i <= $this->items->totalNodes(); $i++)    
        {
            $nxtItem = $this->items->readNode($i);
            $nxtItemSubtotal = $nxtItem->calculateItemSubtotal();
            $basketSubtotal = $basketSubtotal + $nxtItemSubtotal;
        }
        return $basketSubtotal;
    }
    function calculateUserDiscount($discountPercentage){
        $basketSubtotal = $this->calculateBasketSubtotal();
        $userDiscountTotal = $basketSubtotal * ($discountPercentage/100);
        return $userDiscountTotal;
    }
    function calculateBasketDelivery(){
        $deliveryTotal = 0;
        return $deliveryTotal;
    }
    function calculateBasketVAT($vatPercentage,$userDiscountPercntage){
        $basketSubtotal = $this->calculateBasketSubtotal();
        $userDiscountTotal = $this->calculateUserDiscount($userDiscountPercntage);
        $basketDelivery = $this->calculateBasketDelivery();
        $vatTotal = ($basketSubtotal-$userDiscountTotal+$basketDelivery) * ($vatPercentage/100);
        return $vatTotal;
    }
    function calculateOrderSubtotal($vatPercentage,$userDiscountPercntage){
        $basketSubtotal = $this->calculateBasketSubtotal();
        $userDiscountTotal = $this->calculateUserDiscount($userDiscountPercntage);
        $deliveryTotal = $this->calculateBasketDelivery();
        $vatTotal = $this->calculateBasketVAT($vatPercentage,$userDiscountPercntage);
        $orderSubtotal = $basketSubtotal - $userDiscountTotal + $deliveryTotal + $vatTotal;
        return $orderSubtotal;
    }
    
    
       /* 
        function getTotalWeight() {
            $totalWeight=0;
            for($i=1; $i <= $this->items->totalNodes(); $i++)    
            {
                $nxtItem = $items->readNode($i);
                $totalWeight = $totalWeight + ($nxtItem->qty * $nxtItem->getWeight());
            }
            return $totalWeight;		
        }


        * 
        */
    
    function refreshBasketData(){
        //TODO: implement this... it should load data from database for each product code       
        for($i=1; $i <= $this->items->totalNodes(); $i++)    
        {
            $nxtItem = $this->items->readNode(1);
            $nxtProduct = getProductBaseByCode($nxtItem->getProductCode());
            if($nxtProduct->getId()>0){
                $updatedItem = new BasketItem($nxtItem->getQty(), $nxtItem->getProductCode(), $nxtProduct->getPrice(), $nxtProduct->getDiscount());   
                $this->removeItem($nxtItem->getProductCode());
                $this->items->insertLast($updatedItem);
            }
            else
            {
                $this->removeItem($nxtItem->getProductCode());
            }
        }
         
    }
}

?>
