<?php


if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}




$basket = getBasket(true);

?>

<div class="span11">
    <div class="row">
        <script type="text/javascript" src="js/livevalidation_standalone.js"></script>
        <script>
            function updateSelectInput(selid,varid,inputid)
            {
                    var sel = document.getElementById(selid);
                    var opt = sel.selectedIndex;
                    if('undefined' === typeof sel[opt].getAttribute(varid))
                    {	
                            return;
                    }
                    var selectid = sel[opt].getAttribute(varid);
                    document.getElementById(inputid).value = selectid;
            }  


            $(document).ready(function() {

                //user details
                var firstname = new LiveValidation("user_firstname", {validMessage: "Good", wait: 500});
                firstname.add(Validate.Presence, {failureMessage: "Please enter your first name"});
                var lastname = new LiveValidation("user_lastname", {validMessage: "Good", wait: 500});
                lastname.add(Validate.Presence, {failureMessage: "Please enter your last name"});
                var contactphoneno = new LiveValidation("user_contactphoneno", {validMessage: "Good", wait: 500});
                contactphoneno.add(Validate.Presence, {failureMessage: "Please enter a contact number"});
                var email = new LiveValidation("user_email", {validMessage: "Good", wait: 500});
                email.add(Validate.Presence, {failureMessage: "Please enter your email address"});
                email.add(Validate.Email);

                var acceptpolicy = new LiveValidation("user_acceptpolicy");
                acceptpolicy.add(Validate.Acceptance);
            });

        </script>

        <div id="register-modal" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="register-modal" aria-hidden="true">
            <div class="modal-header">
                <h3 id="myModalLabel">Submit a quote request</h3>
                
            </div>
            <div class="modal-body">
                <a href="./SignIn?returnUrl=Basket">Already registered?</a><div class="pull-right"><small>* required fields</small></div>
                <br/>
                <br/>
                <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post" id="requestQuoteForm" class="form-horizontal">
                    <input type="hidden" name="formType" value="quoteRequestRegister"/>
                    <div class="control-group">
                        <label class="control-label" for="user_title" >Title</label>
                        <div class="controls">
                            <select class="span1" id="titleselect" onchange="javascript:updateSelectInput('titleselect','id','user_title');">
                                <option id="Mr">Mr</option>
                                <option id="Mrs">Mrs</option>
                                <option id="Miss">Miss</option>
                                <option id="Ms">Ms</option>
                                <option id="Dr">Dr</option>
                                <option id="Prof">Prof</option>
                                <option id="Rev">Rev</option>
                            </select>
                            <input type="hidden" id="user_title" name="user_title" value="Mr"/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="user_firstname" >*First Name</label>
                        <div class="controls">
                            <input type="text" name="user_firstname" id="user_firstname" required/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="user_lastname" >*Last Name</label>
                        <div class="controls">
                            <input type="text" name="user_lastname" id="user_lastname" required/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="user_contactphoneno" >*Contact No.</label>
                        <div class="controls">
                            <input type="text" name="user_contactphoneno" id="user_contactphoneno" required/>
                        </div>
                    </div>
                    <div class="control-group">
                        <label class="control-label" for="user_email" >*Email</label>
                        <div class="controls">
                            <input type="text" name="user_email" id="user_email" placeholder="example@domain.ie" required/>
                        </div>
                    </div>
                    <small>I have read and agree to the <a href="./Policy?policy=purchase">Purchasing Terms and Conditions</a> and <a href="./Policy?policy=privacy">Privacy Policy</a>.</small>
                    <input type="checkbox" name="user_acceptpolicy" id="user_acceptpolicy">*
                    <br/><br/>
                </form>
            </div>
            <div class="modal-footer">
                <span class="span3"><a href="./SignIn?returnUrl=Basket">Already registered?</a><div class="pull-right"></div></span>
                <a href="javascript:$('#requestQuoteForm').submit();" class="btn btn-primary"/>Request Quote</a>
                <button class="btn" data-dismiss="modal" aria-hidden="true">Cancel</button>
            </div>
        </div>
    </div>
</div>
<div class="span11">
    <div class="row">
        <div class="span11">
            <ul class="breadcrumb">
                <li><a href=".">Home</a> <span class="divider">/</span></li>
                <li class="active">Basket</li>
            </ul>
        </div>
    </div>
    <div class="row">
        <div class="span8">
            <h3>Your Basket</h3>
            
            <?php
            
            $priceVisibility = ($userId > 0);
            
            ?>

<?php
            if($basket->getNbLineItems() <= 0)
            {           
?>
                <p>There are no items in your basket.</p>
<?php                    
            }
            else
            {
                
?>

            <table class="table table-striped">
                <thead>
                    <th colspan="2">Item Description</th>
                    <th>Quantity</th>
<?php
                    if($priceVisibility)
                    {
?>
                    <th>List Price</th>
                    <th>Item Price</th>
                    <th>Subtotal</th>
<?php
                    }
?>   
                </thead>
                <tbody>               
<?php

                    $items_subtotal = 0;
                    $vat_rate = 0.23;
                    $delivery_cost = 0;
                    $order_subtotal = 0;

                    for($i=1; $i <= $basket->getNbLineItems(); $i++)    
                    {
                        $nxtItem = $basket->items->readNode($i);
?>
                    <tr>
                        <td>
                            
<?php 
                        $nxtProduct = getProductBaseByCode($nxtItem->getProductCode());
                        $nxtImg = getBestImageByProductCode($nxtProduct->getProductCode(), 48, 48);
?>
                            <img src="<?php echo $nxtImg->getSrc();?>" width="48" height="48" class="thumbnail"/>
                        </td>
                        <td>
                            <a href="<?php echo getProductDetailLink($nxtProduct->getId(), "");?>">
                                <p class="header_text"><?php echo $nxtProduct->getName(); ?></p>
                            </a>
                            <small><?php echo $nxtProduct->getAvailability();?></small>
                            <br/>
                            <form action="./Basket" method="post">
                                <input type="hidden" name="formType" value="removeBasketItem"/>
                                <input type="hidden" name="removeBasketItem" value="<?php echo $nxtProduct->getId();?>"/>
                                <input type="submit" class="btn btn-mini" value="Remove"/>
                            </form>
                        </td>
                        <td>
                            <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post">
                                <input type="hidden" name="formType" value="addBasketItem"/>
                                <input type="hidden" name="addBasketItem" value="<?php echo $nxtProduct->getId();?>"/>
                                <input class="input-mini" name="totalBasketItemCount" type="number" min="0" max="999" value="<?php echo $nxtItem->getQty();?>" />
                                <br/><input type="submit" class="btn btn-mini" value="Update"/>
                            </form>
                        </td>
<?php
                        if($priceVisibility)
                        {
?>
                        <td>
<?php
                            $listPrice = number_format($nxtItem->getListPrice(),2,'.',',');
                            echo '€'.$listPrice;
?>
                        </td>                        
                        <td>
<?php
                            $itemPrice = number_format($nxtItem->calculateItemPrice(),2,'.',',');
                            echo '€'.$itemPrice;                       
                            if($nxtItem->getItemDiscount()>0)
                            {
?>
                            <small class="muted">
                                <br/>saving
                                <br/>€
<?php 
                                $itemDiscount = number_format($nxtItem->getItemDiscount(),2,'.',',');
                                echo $itemDiscount;
?>
                                (
<?php 
                                $itemDiscountPercent = number_format($nxtItem->getDiscountPercent(),2,'.',',');
                                echo $itemDiscountPercent;
?>
                                %)
                            </small>    
<?php
                            }
?>
                        </td>
                        <td>
<?php
                            $itemSubtotal = number_format($nxtItem->calculateItemSubtotal(),2,'.',',');
                            echo '€'.$itemSubtotal;
?>
                        </td>
<?php
                        }
?>
                    </tr>
<?php
                    }
                    
                    if($priceVisibility)
                    {
                        $vatPercentage = $user->getVatRate();
                        $customerDiscountPercentage = $user->getDiscount();
?>
                    
                    <tr><td></td><td></td><td></td>
                        <td colspan="2">Items Subtotal</td>
                        <td>€
<?php 
                            $basketSubtotal = number_format($basket->calculateBasketSubtotal(),2,'.',',');
                            echo $basketSubtotal;
?>
                        </td>
                    </tr> 
<?php
                    if($customerDiscountPercentage>0)
                    {
?>
                    <tr><td></td><td></td><td></td>
                        <td colspan="2">Customer Discount (<?php echo number_format($customerDiscountPercentage,2,'.',',');?>%)</td>
                        <td>( €
<?php 
                            $userDiscount = number_format($basket->calculateUserDiscount($customerDiscountPercentage),2,'.',',');
                            echo $userDiscount;
?>                          )
                        </td>
                    </tr>    
<?php
                    }
?>
                    <tr><td></td><td></td><td></td>
                        <td colspan="2">Carriage & Pack</td>
                        <td>€
<?php 
                            $basketDelivery = number_format($basket->calculateBasketDelivery(),2,'.',',');
                            echo $basketDelivery;
?>
                        </td>
                    </tr>    
                    <tr><td></td><td></td><td></td>
                        <td colspan="2">VAT (<?php echo $vatPercentage;?>%)</td>
                        <td>€
<?php 
                            $basketVAT = number_format($basket->calculateBasketVAT($vatPercentage,$customerDiscountPercentage),2,'.',',');
                            echo $basketVAT;
?>
                        </td>
                    </tr>    
                    <tr class="lead"><td></td><td></td><td></td>
                        <td colspan="2">Order Subtotal</td>
                        <td>€
<?php 
                            $orderSubtotal = number_format($basket->calculateOrderSubtotal($vatPercentage,$customerDiscountPercentage),2,'.',',');
                            echo $orderSubtotal;
?>
                        </td>
                    </tr>  
<?php
                    }
?>
                     
                </tbody>
            </table>  
                
                
                
<?php
                }
?>
                             
            
            <div class="row">
                <div class="span5">
                    <?php
                    $throwBackTo = "./";
                    if (isset($_SESSION['recentlyViewed'][0]))
                    {
                        $nxtProduct = getProductBaseById($_SESSION['recentlyViewed'][0]);
                        $throwBackTo = getProductDetailLink($nxtProduct->getId(), "");
                    }
                    ?>
                    
                    <a href="<?php echo $throwBackTo;?>" class="btn">Continue Shopping</a>
                </div>
                
<?php
                    if(!$priceVisibility && $basket->getNbLineItems() > 0)
                    {
?>
                    <a href="#register-modal" data-toggle="modal" class="btn btn-large btn-primary">Get a Quote</a>
<?php
                    }
?>
                </div>
            </div>
        
        <div class="span3">
            <div class="well">
                <h3>Know the code?</h3>
                <p>Enter product codes here...</p>
                <form action="<?php echo $_SERVER['REQUEST_URI']?>" method="post">
                    <input type="hidden" name="formType" value="addBasketItemAsProductCode"/>
                    <input type="text" class="input-medium" name="addProductCode" value="" placeholder="Product code">
                    <input type="submit" class="btn btn-mini" value="Add To Basket"/>
                </form>
            </div>
        </div>
    </div>
</div>

