<?php

if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}

$resultsPerPage = 10;
$pagesPerWindow = 10;


if(isset($_GET['pageSize'])){
        $resultsPerPage = cleanQuery($_GET['pageSize']);
}

$resultPage = 1;
if(isset($_GET['resultpage'])){
        $resultPage = cleanQuery($_GET['resultpage']);
}

$requestId = 0;
if(isset($_GET['requestId'])){
        $requestId = cleanQuery($_GET['requestId']);
}

$requestState = StateMgr::requestPending;
if(isset($_GET['requestState'])){
        $requestState = cleanQuery($_GET['requestState']);
}
$requestType = TypeMgr::quoteRequest;
if(isset($_GET['requestType'])){
        $requestType = cleanQuery($_GET['requestType']);
}

?>
<script >
    
        function updateSelectInput(selid,varid,inputid)
        {
                var sel = document.getElementById(selid);
                var opt = sel.selectedIndex;
                if('undefined' === typeof sel[opt].getAttribute(varid))
                {	
                        return;
                }
                var selectid = sel[opt].getAttribute(varid);
                document.getElementById(inputid).value = selectid;
        }  
    </script>
<div class="span12">
        
    <div class="row">
        <div class="span11">
            <ul class="breadcrumb">
                <li><a href=".">Home</a> <span class="divider">/</span></li>
                <li class="active"><?php echo TypeMgr::getRequestType($requestType)?>s</li>
            </ul>          
        </div>
    </div>
    <div class="row">
            <div class="span2">
    
                <h5 class="badge">Folders</h5>
<?php
        $states = StateMgr::getRequestStates();

        if(isset($states) && $states->totalNodes() > 0)
        {
                for($i=1; $i <= $states->totalNodes(); $i++)    
                {
                    $nxtState = $states->readNode($i);
                    if($nxtState->getCode() > 0)//only show normal states
                    {
                        if($requestState == $nxtState->getCode()){
                            
            ?>
                    <?php echo $nxtState->getStatus()." (".getRequestCountByTypeAndState($requestType,$nxtState->getCode()).")";?>
                    <br/>
            <?php
                        }
                        else{
            ?>
                    <a href="<?php echo "./Admin/Requests?requestType=".$requestType."&requestState=".$nxtState->getCode();?>"><?php echo $nxtState->getStatus()." (".getRequestCountByTypeAndState($requestType,$nxtState->getCode()).")";?></a>
                    <br/>
            <?php
                        }
                    }
                }
        }
?>
                    <br/>
            </div>
        
        
<?php
            
?>
        
        
        
        
        <div class="span9">
            <div class="row">
                <div class="span9">
                        <table class="table table-hover">
                            <thead><th>Id</th><th>User</th><th>Created on</th><th>Actions</th></thead>
                            <tbody>
<?php
                    
                    if(isset($requestType) && isset($requestState))
                    {
                        $requests = getRequestsByTypeAndState($requestType,$requestState);
                    }
                    
                    if(isset($requests) && $requests->totalNodes() > 0)
                    {
                        
    $startIndex = 1;
    $endIndex = $requests->totalNodes();
    
    if($endIndex > $resultsPerPage){
        $endIndex = $resultsPerPage;
    }
    
    if(isset($resultPage) && $resultPage > 1){
        $startIndex = $resultsPerPage * ($resultPage-1) + 1;
        $endIndex =  $resultsPerPage * ($resultPage-1) + $resultsPerPage;
    }
    
    if($endIndex > $requests->totalNodes()){
        $endIndex = $requests->totalNodes();
    }

                    for($i=$startIndex; $i <= $endIndex; $i++)    
                    {
                        $nxtRequest = $requests->readNode($i);
                        $nxtUser = getUserById($nxtRequest->getUserId());
    ?>
                                
                                <div id="<?php echo "user-".$nxtUser->getUserId()."-modal";?>" class="modal hide fade" tabindex="-1" role="dialog" aria-labelledby="<?php echo "user-".$nxtUser->getUserId()."-modal";?>" aria-hidden="true">
                                    <div class="modal-body">
                                        <dl class="dl-horizontal">
                                            <dt>Title</dt><dd><?php echo $nxtUser->getTitle();?></dd>
                                            <dt>First Name</dt><dd><?php echo $nxtUser->getFirstname();?></dd>
                                            <dt>Last Name</dt><dd><?php echo $nxtUser->getLastname();?></dd>
                                            <dt>Mobile Phone No</dt><dd><?php if($nxtUser->getBillingPhoneNo()){echo $nxtUser->getBillingPhoneNo();}else{echo "empty";}?></dd>
                                            <dt>Contact No</dt><dd><?php if($nxtUser->getContactPhoneNo()){echo $nxtUser->getContactPhoneNo();}else{echo "empty";}?></dd>
                                            <dt>Email</dt><dd><?php echo $nxtUser->getEmail();?></dd>
                                            <dt>Trade A/c</dt><dd><?php if($nxtUser->getTradeAccount()){echo "true";}else{echo "false";}?></dd>

                                            <dt>Newsletter subscribed</dt><dd><?php if($nxtUser->getNewsletterSubscribe()){echo "true";}else{echo "false";}?></dd>
                                            <dt>Status</dt><dd><?php echo StateMgr::getUserStatus($nxtUser->getUserState());?></dd>
                                        </dl>

                                    </div>
                                    <div class="modal-footer">
                                        <button class="btn" data-dismiss="modal" aria-hidden="true">Close</button>
                                    </div>
                                </div>
                                            <tr class="<?php echo StateMgr::getRequestStatusRowColor($nxtRequest->getState());?>">
                                                <input type="hidden" name="requestId[]" value="<?php echo $nxtRequest->getId();?>">
                                                <td><?php echo $nxtRequest->getId();?></td>
                                                <td>
                                                    <a href="#<?php echo "user-".$nxtRequest->getUserId()."-modal";?>" data-toggle="modal">
                                                        <?php echo getUserNameById($nxtRequest->getUserId());?>
                                                    </a>
                                                </td>
                                                <td><?php echo $nxtRequest->getRequestDateTime();?></td>
                                                <td><a class="btn btn-small" href="./Request?requestid=<?php echo $nxtRequest->getId();?>">View <?php echo TypeMgr::getRequestType($nxtRequest->getType());?>
                                                <?php
                                                if($nxtRequest->getState() != StateMgr::requestArchived)
                                                {
                                                ?>
                                                
                                                    <a class="btn btn-small" href="javascript:$('#changeRequestState > #requestId').val('<?php echo $nxtRequest->getId();?>');$('#changeRequestState > #targetState').val('<?php echo StateMgr::requestArchived;?>');$('#changeRequestState').submit();">Archive This</a>
                                                
                                                <?
                                                }
                                                ?>
                                                </td>
                                            </tr>
                        
    <?php
                    } 
                
                }
                else
                {
?>
                            <tr><td colspan="5">No requests found.</td></tr>
<?php
                }
?>
                            </tbody>
                        </table>
                    
                    <form id="changeRequestState" action="<?php echo $_SERVER['REQUEST_URI'];?>" method="post" class="form-inline">
                        <input type="hidden" name="formType" value="changeRequestState"/>
                        <input type="hidden" name="requestId" id="requestId"/>
                        <input type="hidden" name="targetRequestState" id="targetState"/>
                    </form>
                </div>
            </div>
            <br/>
<?php

                        $resultsPerPageOptionsArr = array("10", "20", "50", "100");
                        getPaginationDiv($requests, $resultsPerPageOptionsArr, $resultsPerPage, $pagesPerWindow, $resultPage, $_SERVER['REQUEST_URI']);

                   
?>
        </div>
        
<?php
?>
        
</div>