<?php

if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}
$defaultResultsPerPage = 20;
$resultsPerPage = 20;
$pagesPerWindow = 10;
$resultsPerRow = 4;

if(isset($_GET['pageSize'])){
        $resultsPerPage = cleanQuery($_GET['pageSize']);
}

$resultPage = 1;
if(isset($_GET['resultpage'])){
        $resultPage = cleanQuery($_GET['resultpage']);
}

if(isset($_GET['folder'])){
        $folder = cleanQuery($_GET['folder']);
}

?>
<script>    
    $(document).ready(function(){
        $('#fileuploaddiv').hide();
                
        $('#actionSelect').change(function(){
            var selected = $('#actionSelect').find(":selected");
            if(selected.attr('actionid')==1)
                {
                    $('#fileuploaddiv').show();
                    return
                }
                
            $('#fileuploaddiv').hide();
        })
    });
        function updateSelectInput(selid,varid,inputid)
        {
                var sel = document.getElementById(selid);
                var opt = sel.selectedIndex;
                if('undefined' === typeof sel[opt].getAttribute(varid))
                {	
                        return;
                }
                var selectid = sel[opt].getAttribute(varid);
                document.getElementById(inputid).value = selectid;
        }  
        function confirmAction()
        {
            var displaymessage = "Are you sure you would like to  ";

            var sel = document.getElementById('actionSelect');
            var opt = sel.selectedIndex;
            if(opt > 0)
            {
                
                $('input[name=formType]').attr('value','editImages');
                displaymessage = displaymessage + sel[opt].text;
                if(confirm(displaymessage))
                {
                    return true;
                }
            }
            return false;
        }
</script>
<div class="span12">
        <div class="row">
            <div class="span2">
    
                <h5 class="badge">Folder Select</h5>
                    <a href="./Admin/Images?folder=slid">Sliding Systems (slid)</a>
                    <br/>
                    <a href="./Admin/Images?folder=auto">Automation (auto)</a>
                    <br/>
                    <a href="./Admin/Images?folder=brush">Brush & Seals (brush)</a>
                    <br/>
                    <a href="./Admin/Images?folder=garage">Garage Doors (garage)</a>
                    <br/>
                    <a href="./Admin/Images?folder=closers">Door Closers (closers)</a>
                    <br/>
                    <a href="./Admin/Images?folder=traffic">Traffic Doors (traffic)</a>
                    <br/>
                    <a href="./Admin/Images?folder=metal">Metal Works (metal)</a>
                    <br/>
                    <a href="./Admin/Images?folder=curtains">Strip Curtains (curtains)</a>
                    <br/>
                    <a href="./Admin/Images?folder=misc">Miscellaneous (misc)</a>
                    <br/>
            </div>
<?php

if(isset($folder))
{
        $images = getImagesBySizeAndFolder(200,200,$folder);
        
?>                
            <div class="span9">
                <div class="row">
                    <div class="span3">
                        <a href="javascript:$('[type=checkbox]').trigger('click');">All On/Off</a>
                    </div>
                </div>
            <form action="<?php echo $_SERVER['REQUEST_URI'];?>" id="mainForm" method="post" enctype="multipart/form-data">
                <input type="hidden" name="formType" value="editImages"/>
                
<?php
        if(isset($images) && $images->totalNodes() > 0)
        {
            
            $startIndex = 1;
            $endIndex = $images->totalNodes();

            if($endIndex > $resultsPerPage){
                $endIndex = $resultsPerPage;
            }

            if(isset($resultPage) && $resultPage > 1){
                $startIndex = $resultsPerPage * ($resultPage-1) + 1;
                $endIndex =  $resultsPerPage * ($resultPage-1) + $resultsPerPage;
            }

            if($endIndex > $images->totalNodes()){
                $endIndex = $images->totalNodes();
            }

?>
                <div class="row">
<?php
                for($i=$startIndex; $i <= $endIndex; $i++)    
                {
                    $nxtImage = $images->readNode($i);
                    
                    if(($i-$startIndex)%$resultsPerRow == 0)
                    {
?>
                </div>
                <br/>
                <div class="row">
<?php
                    }
    ?> 
                <div class="span2">
                    <a class="thumbnail" href="javascript: $('#resultSelect_<?php echo $nxtImage->getId();?>').trigger('click');">
                        <input type="checkbox" name="resultSelect[]" id="resultSelect_<?php echo $nxtImage->getId();?>" value="<?php echo $nxtImage->getId();?>"/>
                        <img src="<?php echo $nxtImage->getSrc();?>"/>
                        <div class="caption">
                            <?php echo basename($nxtImage->getSrc());?>
                        </div>
                    </a>
                </div>
    <?php
    
                }
        }
?>
                </div>
                <br/>  
                    <select onchange="javascript:updateSelectInput('actionSelect','actionid','performActionId');" id="actionSelect">
                        <option actionid="0">Select Action</option>
                        <option actionid="1">Add new image</option>
                        <option actionid="2">Change selected image</option>
                        <option actionid="3">Delete selected image(s)</option>
                    </select>
                
                <br/>
                <div id="fileuploaddiv">
                <input type="file" name="fileupload"/>
                </div>
                <br/>
                
                <input type="hidden" id="folder" name="folder" value="<?php echo $folder;?>"/>                
                <input type="hidden" id="performActionId" name="performActionId" value="0"/>
                <input type="Submit" value="Perform"onclick="return confirmAction()" class="btn btn-primary"/>
                <a role="button" href="<?php echo $_SERVER['REQUEST_URI'];?>" class="btn">Refresh / Reset</a>
            </form>
<?php

        $resultsPerPageOptionsArr = array("20", "60", "100");
        getPaginationDiv($images, $resultsPerPageOptionsArr, $resultsPerPage, $pagesPerWindow, $resultPage, $_SERVER['REQUEST_URI']);
    
}
?>
        </div>     
        </div>
</div>