<?php

if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}

$defaultResultsPerPage = 10;
$resultsPerPage = 10;
$pagesPerWindow = 10;


if(isset($_GET['pageSize'])){
        $resultsPerPage = cleanQuery($_GET['pageSize']);
}

$resultPage = 1;
if(isset($_GET['resultpage'])){
        $resultPage = cleanQuery($_GET['resultpage']);
}

if(isset($_GET['folder'])){
        $folder = cleanQuery($_GET['folder']);
}

?>
<script>    
    
    $(document).ready(function(){
        $('#newFileRow').hide();
                
        $('#actionSelect').change(function(){
            var selected = $('#actionSelect').find(":selected");
            if(selected.attr('actionid')==2)
                {
                    $('#newFileRow').show();
                    return
                }
                
            $('#newFileRow').hide();
        })
    });
        function updateSelectInput(selid,varid,inputid)
        {
                var sel = document.getElementById(selid);
                var opt = sel.selectedIndex;
                if('undefined' === typeof sel[opt].getAttribute(varid))
                {	
                        return;
                }
                var selectid = sel[opt].getAttribute(varid);
                document.getElementById(inputid).value = selectid;
        }  
        function confirmAction()
        {
            var displaymessage = "Are you sure you would like to  ";

            var sel = document.getElementById('actionSelect');
            var opt = sel.selectedIndex;
            if(opt > 0)
            {
                
                $('input[name=formType]').attr('value','editFiles');
                displaymessage = displaymessage + sel[opt].text;
                if(confirm(displaymessage))
                {
                    return true;
                }
            }
            return false;
        }
</script>
<div class="span12">
        <div class="row">
            <div class="span2">
    
                <h5 class="badge">Folder Select</h5>
                    <a href="./Admin/Files?folder=slid">Sliding Systems (slid)</a>
                    <br/>
                    <a href="./Admin/Files?folder=auto">Automation (auto)</a>
                    <br/>
                    <a href="./Admin/Files?folder=brush">Brush & Seals (brush)</a>
                    <br/>
                    <a href="./Admin/Files?folder=garage">Garage Doors (garage)</a>
                    <br/>
                    <a href="./Admin/Files?folder=closers">Door Closers (closers)</a>
                    <br/>
                    <a href="./Admin/Files?folder=traffic">Traffic Doors (traffic)</a>
                    <br/>
                    <a href="./Admin/Files?folder=metal">Metal Works (metal)</a>
                    <br/>
                    <a href="./Admin/Files?folder=curtains">Strip Curtains (curtains)</a>
                    <br/>
                    <a href="./Admin/Files?folder=misc">Miscellaneous (misc)</a>
                    <br/>
            </div>
<?php

if(isset($folder))
{

        $files = getPublicTargetsInFolder($folder);

        
        if(isset($files) && $files->totalNodes() > 0)
        {
?>                
            <div class="span9">
                <div class="row">
                    <div class="span3">
                        <a href="javascript:$('[type=checkbox]').trigger('click');">All On/Off</a>
                    </div>
                </div>
            <form action="<?php echo $_SERVER['REQUEST_URI'];?>" id="mainForm" method="post" enctype="multipart/form-data">
                <input type="hidden" name="formType" value="editFiles"/>
                <table class="table table-hover">
                    <thead><th>Action</th><th>Location</th><th>Type</th><th>Assigned to</th></thead>
                    <tbody>
<?php
    $startIndex = 1;
    $endIndex = $files->totalNodes();
    
    if($endIndex > $resultsPerPage){
        $endIndex = $resultsPerPage;
    }
    
    if(isset($resultPage) && $resultPage > 1){
        $startIndex = $resultsPerPage * ($resultPage-1) + 1;
        $endIndex =  $resultsPerPage * ($resultPage-1) + $resultsPerPage;
    }
    
    if($endIndex > $files->totalNodes()){
        $endIndex = $files->totalNodes();
    }

                for($i=$startIndex; $i <= $endIndex; $i++)    
                {
                    $nxtFile = $files->readNode($i);
    ?>
                        
                    <tr id="">
                        <td><input type="checkbox" name="fileSelected[]" value="<?php echo $nxtFile->getId();?>" /></td>
                        <td><a href="<?php echo $nxtFile->getTarget();?>" target="_blank"><?php echo $nxtFile->getTarget();?></a></td>   
                        <td>
<?php
                        $nxtDocType = getDocumentationTypeById($nxtFile->getTargetType());
                        echo $nxtDocType;
?>
                        </td>
                        <td>
<?php
                        $docs = getDocumentsByTargetId($nxtFile->getId());
                        if($docs->totalNodes() > 0)
                        {
                            //print_r($docs);
                            for($j=1; $j <= $docs->totalNodes(); $j++)    
                            {
                                $nxtDoc = $docs->readNode($j);
                                $nxtProd = getProductBaseById($nxtDoc->getBaseId());
                                echo $nxtProd->getName();
                                if($j<$docs->totalNodes()){echo ",";}
                            }
                        }
?>
                        </td>
                        </tr>   
    <?php
                }
?>
                        <tr id="newFileRow">
                            <td>n/a</td>
                            <td><input type="file" name="fileupload[]"/></td>
                            <td>
                                <select onchange="javascript:updateSelectInput('docTypeSelect','value','docTypeId');" id="docTypeSelect">
                                    <option value="0">Select type</option>
                                    <option value="1">Brochure</option>
                                    <option value="2">Technical</option>
                                </select>
                                <input type="hidden" name="docTypeId" id="docTypeId" value="0">
                            </td>
                            <td>n/a</td>
                        </tr>
                    </tbody>
                </table>
                
                    <select onchange="javascript:updateSelectInput('actionSelect','actionid','performActionId');" id="actionSelect">
                        <option actionid="0">Select Action</option>
                        <option actionid="1">Delete</option>
                        <option actionid="2">Add new file</option>
                    </select>
                
                <br/>
                
                
                <input type="hidden" id="folder" name="folder" value="<?php echo $folder;?>"/>                
                <input type="hidden" id="performActionId" name="performActionId" value="0"/>
                <input type="Submit" value="Perform"onclick="return confirmAction()" class="btn btn-primary"/>
                <a role="button" href="<?php echo $_SERVER['REQUEST_URI'];?>" class="btn">Refresh / Reset</a>
            </form>
<?php

        $resultsPerPageOptionsArr = array("10", "20", "50", "100");
        getPaginationDiv($files, $resultsPerPageOptionsArr, $resultsPerPage, $pagesPerWindow, $resultPage, $_SERVER['REQUEST_URI']);
    
        }
}
?>
        </div>     
        </div>
</div>