<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
if(!isset($_SESSION['valid']) || empty($_SESSION['valid']))
{
    header("Location: ./");
    exit();
}
$info = "details";

if (isset($_GET['info']))
{
    $info = $_GET['info'];
}

if (($userId = validateUser()) > 0)
{
    $thisUser = getUserById($userId);

?>      <script type="text/javascript" src="js/livevalidation_standalone.js"></script>
        <script>
        function updateSelectInput(selid,varid,inputid)
        {
                var sel = document.getElementById(selid);
                var opt = sel.selectedIndex;
                if('undefined' === typeof sel[opt].getAttribute(varid))
                {	
                        return;
                }
                var selectid = sel[opt].getAttribute(varid);
                document.getElementById(inputid).value = selectid;
        }  
        

        $(document).ready(function() {
            
            //postcode option hidden by default
            $("#div-postcode").hide();
            $("#countryselect").change(function(){
                if($(this).attr('value') == "United Kingdom")
                {
                    $("#div-postcode").show();
                }
                else
                {                                        
                    $("#div-postcode").hide();
                }

                if($(this).attr('value') != "Ireland")
                {
                    $("#countyselect option").filter(function(){

                        return $(this).text() == "Outside Ireland";
                    }).prop('selected',true);
                }
            });
            //user details
            var firstname = new LiveValidation("user_firstname", {validMessage: "Good", wait: 500});
            firstname.add(Validate.Presence, {failureMessage: "Please enter your first name"});
            var lastname = new LiveValidation("user_lastname", {validMessage: "Good", wait: 500});
            lastname.add(Validate.Presence, {failureMessage: "Please enter your last name"});
            var billingphoneno = new LiveValidation("user_billingphoneno", {validMessage: "Good", wait: 500});
            billingphoneno.add(Validate.Length, {minimum: 5});
            var contactphoneno = new LiveValidation("user_contactphoneno", {validMessage: "Good", wait: 500});
            contactphoneno.add(Validate.Presence, {failureMessage: "Please enter a contact number"});
            var email = new LiveValidation("user_email", {validMessage: "Good", wait: 500});
            email.add(Validate.Presence, {failureMessage: "Please enter your email address"});
            email.add(Validate.Email);
            var emailconfirm = new LiveValidation("user_emailconfirm", {validMessage: "Good", wait: 500});
            emailconfirm.add(Validate.Confirmation, {match: 'user_email' });
            //billing details
            //var billingaddr1 = new LiveValidation("user_billingaddr1", {validMessage: "Good", wait: 500});
            //billingaddr1.add(Validate.Presence, {failureMessage: "Please enter a billing address"});
            //security details
            var password = new LiveValidation("user_password", {validMessage: "Good", wait: 500});
            password.add(Validate.Presence, {failureMessage: "Please enter a password"});
            password.add(Validate.Length, {minimum: 5});
            var passwordconfirm = new LiveValidation("user_passwordconfirm", {validMessage: "Good", wait: 500});            
            passwordconfirm.add(Validate.Confirmation, {match: 'user_password' });
            
         
        });
        
    </script>
<div class="span11">
    <div class="row">
        <div class="span11">
            <ul class="breadcrumb">
                <li><a href=".">Home</a> <span class="divider">/</span></li>
                <li class="active">Account</li>
            </ul>
        </div>
    </div>
    <div class="row">
        <div class="span9">
            <div class="tabbable">
                <ul class="nav nav-tabs">
                    <li class="<?php if ($info == "details"){echo "active";}?>"><a href="#details" data-toggle="tab">My Details</a></li>
                    <li class="<?php if ($info == "requests"){echo "active";}?>"><a href="#requests" data-toggle="tab">Requests</a></li>
                </ul>
                <div class="tab-content border_sides border_bottom padding_medium">
                       
<?php
/*
 * 
 * My Details
 * 
 */
?>
                    <div class="tab-pane <?php if ($info == "details"){echo "active";}?>" id="details">

                        <h3>My Details</h3>
                        
                                <div class="well">
                                    <h5 class="badge">User Details</h5>
                                    <div id="readUserDetails">
                                        <dl class="dl-horizontal">
                                            <dt>Name</dt>
                                            <dd><?php echo $thisUser->getTitle()." ".$thisUser->getFirstname()." ".$thisUser->getLastname();?></dd>
                                            <dt>Phone</dt>
                                            <dd><?php echo $thisUser->getContactPhoneNo();?></dd>
                                            <dt>Mobile</dt>
                                            <dd><?php echo $thisUser->getBillingPhoneNo();?></dd>
                                            <dt>Email</dt>
                                            <dd><?php echo $thisUser->getEmail();?></dd>
                                            <dt>Newsletter Subscribe</dt>
                                            <dd><?php echo $thisUser->getNewsletterSubscribe() ? 'Yes' : 'No';?></dd>
                                        </dl>
                                    </div>
                                    <script type="text/javascript">
                                        $(document).ready(function(){
                                            $('#updateUserDetails').hide();
                                            $('#securityDetailsUpdateForm').hide();
                                        });
                                        function openUpdateUserDetailsForm(){
                                            $('#openUpdateUserDetailsBtn').hide();
                                            $('#readUserDetails').hide();
                                            $('#updateUserDetails').show();
                                        }
                                        function closeUpdateUserDetailsForm(){
                                            $('#openUpdateUserDetailsBtn').show();
                                            $('#readUserDetails').show();
                                            $('#updateUserDetails').hide();
                                        }
                                    </script>
                                    <a id="openUpdateUserDetailsBtn" href="javascript:openUpdateUserDetailsForm()">Edit</a>
                        
                                    <div id="updateUserDetails">
                                        <form action="./Account" method="post" class="form-horizontal">
                                            <input type="hidden" name="formType" value="userDetailsUpdate"/>
                                
                                            <div class="control-group">
                                                <label class="control-label" for="user_title" >Title</label>
                                                <div class="controls">
                                                        <script type="text/javascript">
                                                            $(document).ready(function() {
                                                                $('#titleselect option').filter(function(){
                                                                    return $(this).text() == '<?php echo $thisUser->getTitle();?>';
                                                                }).attr('selected', true);
                                                            });
                                                        </script>
                                                    <select class="span1" id="titleselect" onchange="javascript:updateSelectInput('titleselect','id','user_title');">
                                                        <option id="Mr">Mr</option>
                                                        <option id="Mrs">Mrs</option>
                                                        <option id="Miss">Miss</option>
                                                        <option id="Ms">Ms</option>
                                                        <option id="Dr">Dr</option>
                                                        <option id="Prof">Prof</option>
                                                        <option id="Rev">Rev</option>
                                                    </select>
                                                    <input type="hidden" id="user_title" name="user_title" value="<?php echo $thisUser->getTitle();?>"/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <label class="control-label" for="user_firstname" >*First Name</label>
                                                <div class="controls">
                                                    <input type="text" name="user_firstname" id="user_firstname" value="<?php echo $thisUser->getFirstname();?>" required/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <label class="control-label" for="user_lastname" >*Last Name</label>
                                                <div class="controls">
                                                    <input type="text" name="user_lastname" id="user_lastname" value="<?php echo $thisUser->getLastName();?>" required/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <label class="control-label" for="user_billingphoneno" >Mobile Phone No.</label>
                                                <div class="controls">
                                                    <input type="text" name="user_billingphoneno" id="user_billingphoneno" value="<?php echo $thisUser->getBillingPhoneNo();?>"/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <label class="control-label" for="user_contactphoneno" >*Contact No.</label>
                                                <div class="controls">
                                                    <input type="text" name="user_contactphoneno" id="user_contactphoneno" value="<?php echo $thisUser->getContactPhoneNo();?>" required/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <label class="control-label" for="user_email" >*Email</label>
                                                <div class="controls">
                                                    <input type="text" name="user_email" id="user_email" value="<?php echo $thisUser->getEmail();?>" required/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <label class="control-label" for="user_emailconfirm" >*Re-type Email</label>
                                                <div class="controls">
                                                    <input type="text" name="user_emailconfirm" id="user_emailconfirm" value="<?php echo $thisUser->getEmail();?>" required/>
                                                </div>
                                            </div>
                                            <div class="control-group">
                                                <div class="controls">
                                                    <label class="checkbox">
                                                        <input type="checkbox" name="user_newslettersubscribe" id="user_newslettersubscribe" <?php if($thisUser->getNewsletterSubscribe() > 0){echo "checked";}?>> Receive promotional information and news
                                                    </label>
                                                </div>
                                            </div>
                                            <br/>
                                            <input class="btn btn-primary" type="submit" value="Update" />
                                            <a id="closeUpdateUserDetailsBtn" href="javascript:closeUpdateUserDetailsForm()">Cancel</a>
                                        </form>
                                    </div>
                                </div>

<?php
/*
 * 
 * Address Details
 * 
 */
?>
<script type="text/javascript">

    function openUpdateAddrDetailsForm(id){
        $('#openUpdateAddrDetailsBtn-'.concat(id)).hide();
        $('#removeAddr-'.concat(id)).hide();
        $('#readAddrDetails-'.concat(id)).hide();
        $('#updateBillingDetails-'.concat(id)).show();
    }
    function closeUpdateAddrDetailsForm(id){
        $('#openUpdateAddrDetailsBtn-'.concat(id)).show();
        $('#removeAddr-'.concat(id)).show();
        
        $('#readAddrDetails-'.concat(id)).show();
        $('#updateBillingDetails-'.concat(id)).hide();
    }
    function openUpdateSecurityDetailsForm(){
        $('#openUpdateSecurityDetailsBtn').hide();
        $('#readSecurityDetails').hide();
        $('#securityDetailsUpdateForm').show();
    }
    function closeUpdateSecurityDetailsForm(){
        $('#openUpdateSecurityDetailsBtn').show();
        $('#readSecurityDetails').show();
        $('#securityDetailsUpdateForm').hide();
    }
    
</script>
                                <div class="well">
                                    <h5 class="badge">Address Details</h5>

<?php
                                    $userAddresses = getUserAddressesByUserId($thisUser->getUserId());
                                    for($i=1; $i <= $userAddresses->totalNodes(); $i++)    
                                    {
                                        $nxtAddr = $userAddresses->readNode($i);
?>
                                    
<?php
                                        getAddrDiv($nxtAddr);
?>   
                                            <script type="text/javascript">
                                                $(document).ready(function(){
                                                    $('#updateBillingDetails-<?php echo $nxtAddr->getId();?>').hide();
                                                });
                                            </script>
                                            <a id="openUpdateAddrDetailsBtn-<?php echo $nxtAddr->getId();?>" href="javascript:openUpdateAddrDetailsForm(<?php echo $nxtAddr->getId();?>)">Edit</a>
                                            
                                            <form action="./Account" method="post" id="removeAddr-<?php echo $nxtAddr->getId();?>">
                                                <input type="hidden" name="formType" value="RemoveUserAddr"/>
                                                <input type="hidden" name="billingDetailsIndex" value="<?php echo $nxtAddr->getId();?>"/>
                                                <a href="javascript:$('#removeAddr-<?php echo $nxtAddr->getId();?>').submit();" />Remove</a>
                                            </form>
                                            <div id="updateBillingDetails-<?php echo $nxtAddr->getId();?>">
<?php
                                                getAddrUpdateForm($nxtAddr);
?>                                           
                                            </div>
<?php
                                    }
?>
                                            
                                    <form action="./Account" method="post">
                                        <input type="hidden" name="formType" value="AddUserAddr"/>
                                        <input type="submit" class="btn btn-primary" value="Add"/>
                                    </form>
                                </div>



                                        <div class="well">
                                                <h5 class="badge">Security Details</h5>

                                                <?php
                                                getSecurityDetailsDiv();
                                                ?>
                                                
                                            <a id="openUpdateSecurityDetailsBtn" href="javascript:openUpdateSecurityDetailsForm()">Edit</a>
                                            
                                            <div id="securityDetailsUpdateForm">
                                            
                                                <form action="./Account" method="post" class="form-horizontal">
                                                    
                                                    <input type="hidden" name="formType" value="securityDetailsUpdate"/>
                                                    <div class="control-group">
                                                        <label class="control-label" for="user_password" >*Password</label>
                                                        <div class="controls">
                                                            <input type="password" name="user_password" id="user_password" placeholder="ADG password" required/>
                                                        </div>
                                                    </div>
                                                    <div class="control-group">
                                                        <label class="control-label" for="user_passwordconfirm" >*Re-Type Password</label>
                                                        <div class="controls">
                                                            <input type="password" name="user_passwordconfirm" id="user_passwordconfirm" placeholder="ADG password" required/>
                                                        </div>
                                                    </div>


                                                    <br/>
                                                    <input class="btn btn-primary" type="submit" value="Update" />
                                                    <a id="closeUpdateSecurityDetailsBtn" href="javascript:closeUpdateSecurityDetailsForm()">Cancel</a>
                                                </form>
                                            </div>
                                        </div>
                                
                    </div> 

<?php
/*
 * 
 * 
 * Requests
 * 
 * 
 */
?>
                    
                    <div class="tab-pane <?php if ($info == "requests"){echo "active";}?>" id="requests">
                        <h3>Quotes</h3>
                        <div class="well">    
                                    <table class="table table-hover">
                                        <thead><th>Created on</th><th>Status</th><th>Action</th></thead>
                                        <tbody>
                    <?php
                    $requests = getRequests($thisUser->getUserId());
                    
                    if(isset($requests) && $requests->totalNodes() > 0)
                    {
                        for($j=1; $j <= $requests->totalNodes(); $j++)    
                        {
                            $nxtRequest = $requests->readNode($j);
                            
                            if( $nxtRequest->getState() != StateMgr::requestFailed )
                            {
                                $rowColourClass = StateMgr::getRequestStatusRowColor($nxtRequest->getState());
                    ?>

                                            <tr class="<?php echo $rowColourClass;?>">
                                                <td><?php echo $nxtRequest->getRequestDateTime();?></td>
                                                <td><?php echo StateMgr::getRequestStatus($nxtRequest->getState());?></td>
                                                <td>
<?php
                                        switch ($nxtRequest->getType()){
                                            case TypeMgr::quoteRequest :
?>
                                                <a href="./Request?requestid=<?php echo $nxtRequest->getId();?>">View</a>
<?php   
                                                break;
                                        }
?>
                                                </td>
                                            </tr>   

                    <?php
                            }
                        }
                    }
                    ?>
                                        </tbody>
                                    </table>

			</div>
                    </div>        
     
<?php
/*
 * 
 * 
 * Quotes
 * 
 * 
 */
?>
      
<?php
/*
 * 
 * 
 * Orders
 * 
 * 
 */
?>
                    
<?php
/*
 * 
 * 
 * Reviews
 * 
 * 
 */
?>                        
                    
                </div>
            </div>
            
        </div>
    </div>
</div>
    
<?php


}
?>

    
    
<?php


function getSecurityDetailsDiv()
{
    $result = "";
    $result .= "<div id=\"readSecurityDetails\"><dl class=\"dl-horizontal\">";
    $result .=         "<dt>Password</dt>";
    $result .=         "<dd>********</dd>";
    $result .=     "</dl></div>";
    echo $result;    
}
function getAddrDiv($addr)
{
    $result = "";
    $result .= "<div id=\"readAddrDetails-".$addr->getId()."\"><dl class=\"dl-horizontal\">";
    $result .=         "<dt>Address</dt>";
    $result .=         "<dd>".$addr->getBillingAddr1()."</dd>";
    $result .=         "<dt></dt>";
    $result .=         "<dd>".$addr->getBillingAddr2()."</dd>";
    $result .=         "<dt>County</dt>";
    $result .=         "<dd>".$addr->getCounty()."</dd>";
    $result .=         "<dt>Country</dt>";
    $result .=         "<dd>".$addr->getCountry()."</dd>";
    $result .=        "<dt>Postcode</dt>";
    $result .=         "<dd>".$addr->getPostcode()."</dd>";
    $result .=     "</dl></div>";
    echo $result;    
}

function getAddrUpdateForm($addr)
{
    $result = "";
 ?>
    
<form action="./Account" method="post" class="form-horizontal">
    <input type="hidden" name="formType" value="billingDetailsUpdate"/>
    <input type="hidden" name="billingDetailsIndex" value="<?php echo $addr->getId();?>"/>
    <div class="control-group">
        <label class="control-label" for="user_billingaddr1-<?php echo $addr->getId();?>" >*Address</label>
        <div class="controls">
            <input type="text" name="user_billingaddr1-<?php echo $addr->getId();?>" id="user_billingaddr1-<?php echo $addr->getId();?>" value="<?php echo $addr->getBillingAddr1();?>" required/><br/>
            <input type="text" name="user_billingaddr2-<?php echo $addr->getId();?>" id="user_billingaddr2-<?php echo $addr->getId();?>" value="<?php echo $addr->getBillingAddr2();?>"/>
        </div>
    </div>
    <div class="control-group">
        <label class="control-label" for="user_county-<?php echo $addr->getId();?>" >*County</label>
        <div class="controls">
            <script type="text/javascript">
                $(document).ready(function() {
                    $('#countyselect-<?php echo $addr->getId();?> option').filter(function(){
                        return $(this).text() == '<?php echo $addr->getCounty();?>';
                    }).attr('selected', true);
                });
            </script>
            <select class="span2" id="countyselect-<?php echo $addr->getId();?>" onchange="javascript:updateSelectInput('countyselect-<?php echo $addr->getId();?>','value','user_county-<?php echo $addr->getId();?>');">
                <option value="">Choose a County</option>
                <option value="Outside Ireland">Outside Ireland</option><option value="Carlow">Carlow</option><option value="Cavan">Cavan</option>
                <option value="Clare">Clare</option><option value="Cork">Cork</option><option value="Donegal">Donegal</option>
                <option value="Dublin 1">Dublin 1</option><option value="Dublin 2">Dublin 2</option><option value="Dublin 3">Dublin 3</option>
                <option value="Dublin 4">Dublin 4</option><option value="Dublin 5">Dublin 5</option><option value="Dublin 6">Dublin 6</option>
                <option value="Dublin 6W">Dublin 6W</option><option value="Dublin 7">Dublin 7</option><option value="Dublin 8">Dublin 8</option>
                <option value="Dublin 9">Dublin 9</option><option value="Dublin 10">Dublin 10</option><option value="Dublin 11">Dublin 11</option>
                <option value="Dublin 12">Dublin 12</option><option value="Dublin 13">Dublin 13</option><option value="Dublin 14">Dublin 14</option>
                <option value="Dublin 15">Dublin 15</option><option value="Dublin 16">Dublin 16</option><option value="Dublin 17">Dublin 17</option>
                <option value="Dublin 18">Dublin 18</option><option value="Dublin 19">Dublin 19</option><option value="Dublin 20">Dublin 20</option>
                <option value="Dublin 21">Dublin 21</option><option value="Dublin 22">Dublin 22</option><option value="Dublin 23">Dublin 23</option>
                <option value="Dublin 24">Dublin 24</option><option value="Dublin County">Dublin County</option><option value="Galway">Galway</option>
                <option value="Kerry">Kerry</option><option value="Kildare">Kildare</option><option value="Kilkenny">Kilkenny</option>
                <option value="Laois">Laois</option><option value="Leitrim">Leitrim</option><option value="Limerick">Limerick</option>
                <option value="Longford">Longford</option><option value="Louth">Louth</option><option value="Mayo">Mayo</option>
                <option value="Meath">Meath</option><option value="Monaghan">Monaghan</option><option value="Offaly">Offaly</option>
                <option value="Roscommon">Roscommon</option><option value="Sligo">Sligo</option><option value="TipperaryN">Tipperary North</option>
                <option value="TipperaryS">Tipperary South</option><option value="Waterford">Waterford</option><option value="Westmeath">Westmeath</option>
                <option value="Wexford">Wexford</option><option value="Wicklow">Wicklow</option>
            </select>
            <input type="hidden" name="user_county-<?php echo $addr->getId();?>" id="user_county-<?php echo $addr->getId();?>" value="<?php echo $addr->getCounty();?>"/>
        </div>
    </div>

    <div class="control-group">
        <label class="control-label" for="user_country-<?php echo $addr->getId();?>" >*Country</label>
        <div class="controls">
            <script type="text/javascript">
                $(document).ready(function() {
                    $('#countryselect-<?php echo $addr->getId();?> option').filter(function(){
                        return $(this).text() == '<?php echo $addr->getCountry();?>';
                    }).attr('selected', true);
                });
            </script>
            <select class="span2" id="countryselect-<?php echo $addr->getId();?>" onchange="javascript:updateSelectInput('countryselect-<?php echo $addr->getId();?>','value','user_country-<?php echo $addr->getId();?>');">
                <option value="Argentina">Argentina</option><option value="Australia">Australia</option><option value="Austria">Austria</option>
                <option value="Bahamas">Bahamas</option><option value="Belgium">Belgium</option><option value="Bolivia">Bolivia</option>
                <option value="Brazil">Brazil</option><option value="Canada">Canada</option><option value="Chile">Chile</option>
                <option value="China">China</option><option value="Colombia">Colombia</option><option value="Costa Rica">Costa Rica</option>
                <option value="Croatia">Croatia</option><option value="Cuba">Cuba</option><option value="Czech, Rep.">Czech, Rep.</option>
                <option value="Denmark">Denmark</option><option value="Dominican, Rep.">Dominican, Rep.</option><option value="Ecuador">Ecuador</option>
                <option value="Egypt">Egypt</option><option value="El Salvador">El Salvador</option><option value="Finland">Finland</option>
                <option value="France">France</option><option value="Germany">Germany</option><option value="Greece">Greece</option>
                <option value="Guatemala">Guatemala</option><option value="Honduras">Honduras</option><option value="Hong Kong">Hong Kong</option>
                <option value="India">India</option><option value="Ireland">Ireland</option><option value="Israel">Israel</option>
                <option value="Italy">Italy</option><option value="Jamaica">Jamaica</option><option value="Japan">Japan</option>
                <option value="Luxembourg">Luxembourg</option><option value="Mexico">Mexico</option><option value="Morocco">Morocco</option>
                <option value="Netherlands">Netherlands</option><option value="New Zealand">New Zealand</option><option value="Nicaragua">Nicaragua</option>
                <option value="Nigeria">Nigeria</option><option value="Norway">Norway</option><option value="Paraguay">Paraguay</option>
                <option value="Peru">Peru</option><option value="Poland">Poland</option><option value="Portugal">Portugal</option>
                <option value="Puerto Rico">Puerto Rico</option><option value="Russia">Russia</option><option value="Saudi Arabia">Saudi Arabia</option>
                <option value="Singapore">Singapore</option><option value="South Africa">South Africa</option><option value="Spain">Spain</option>
                <option value="Sweden">Sweden</option><option value="Switzerland">Switzerland</option><option value="Taiwan">Taiwan</option>
                <option value="Turkey">Turkey</option><option value="United Kingdom">United Kingdom</option><option value="United States">United States</option>
                <option value="Uruguay">Uruguay</option><option value="Venezuela">Venezuela</option><option value="Other...">Other...</option>
            </select>

            <input type="hidden" name="user_country-<?php echo $addr->getId();?>" id="user_country-<?php echo $addr->getId();?>" value="Ireland"/>
        </div>
    </div>

    <div class="control-group" id="div-postcode">
        <label class="control-label" for="user_postcode-<?php echo $addr->getId();?>" >Postcode (UK only)</label>
        <div class="controls">
            <input type="text" name="user_postcode-<?php echo $addr->getId();?>" id="user_postcode-<?php echo $addr->getId();?>" value="<?php echo $addr->getPostcode();?>" />
        </div>
    </div>
    <br/>
    <input class="btn btn-primary" type="submit" value="Update" />
    <a id="closeUpdateAddrDetailsBtn-<?php echo $addr->getId();?>" href="javascript:closeUpdateAddrDetailsForm(<?php echo $addr->getId();?>)">Cancel</a>
</form>
<?php
    return $result;    
}

?>
                              